﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 采购单详情
    /// </summary>
    public class dc_base_purchase_details
    {
        /// <summary>
		/// 
        /// </summary>		
        public int id { get; set; }

        /// <summary>
        /// 采购单号
        /// </summary>		
        public string purchase_id { get; set; }

        /// <summary>
        /// 状态-1：作废，0：待确认，1：已确认 4：已完成
        /// </summary>		
        public int status { get; set; }

        /// <summary>
        /// 采购类型
        /// </summary>		
        public string purchase_category_name { get; set; }

        /// <summary>
        /// 采购系统的供应商ID
        /// </summary>		
        public int deliver_id { get; set; }

        /// <summary>
        /// 采购系统的供应商名称
        /// </summary>		
        public string deliver_name { get; set; }

        /// <summary>
        /// 采购员名称
        /// </summary>		
        public string buyer_name { get; set; }

        /// <summary>
        /// 采购仓库编码
        /// </summary>		
        public string warehouse_from_code { get; set; }

        /// <summary>
        /// 采购仓库名称
        /// </summary>		
        public string warehouse_from_name { get; set; }

        /// <summary>
        /// 目的仓库编码
        /// </summary>		
        public string warehouse_into_code { get; set; }

        /// <summary>
        /// 目的仓库名称
        /// </summary>		
        public string warehouse_into_name { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public string bailun_sku { get; set; }

        /// <summary>
        /// 采购数量
        /// </summary>		
        public int quantity_purchase { get; set; }

        /// <summary>
        /// 采购单价
        /// </summary>		
        public decimal unit_price { get; set; }

        /// <summary>
        /// 采购总价
        /// </summary>		
        public decimal amount_paid { get; set; }

        /// <summary>
        /// 币种编码
        /// </summary>		
        public string currency_code { get; set; }

        /// <summary>
        /// 币种名称
        /// </summary>		
        public string currency_name { get; set; }

        /// <summary>
        /// 退货数量
        /// </summary>		
        public int quantity_return { get; set; }

        /// <summary>
        /// 入库数量
        /// </summary>		
        public int quantity_inbound { get; set; }

        /// <summary>
        /// 发货数量
        /// </summary>		
        public int quantity_deliver { get; set; }

        /// <summary>
        /// 未发货数量
        /// </summary>		
        public int quantity_not_deliver { get; set; }

        /// <summary>
        /// 到货数量
        /// </summary>		
        public int quantity_arrival { get; set; }

        /// <summary>
        /// 未到货数量
        /// </summary>		
        public int quantity_not_arrival { get; set; }

        /// <summary>
        /// 质检数量
        /// </summary>		
        public int quantity_inspect { get; set; }

        /// <summary>
        /// 质检合格数量
        /// </summary>		
        public int quantity_qualified_inspect { get; set; }

        /// <summary>
        /// 质检不合格数量
        /// </summary>		
        public int quantity_unqualified_inspect { get; set; }

        /// <summary>
        /// 待调拨数量
        /// </summary>		
        public int quantity_wait_transfer { get; set; }

        /// <summary>
        /// 换货数量
        /// </summary>		
        public int quantity_exchange { get; set; }

        /// <summary>
        /// 入库丢失数量
        /// </summary>		
        public int quantity_lose_inbound { get; set; }

        /// <summary>
        /// 采购系统创建时间
        /// </summary>		
        public DateTime create_time { get; set; }

        /// <summary>
        /// 采购系统更新时间
        /// </summary>		
        public DateTime update_time { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public DateTime gmt_modified { get; set; }

        /// <summary>
        /// 未入库数量
        /// </summary>		
        public int quantity_not_inbound { get; set; }

        /// <summary>
        /// 阿里巴巴单号
        /// </summary>		
        public string alibaba_order_id { get; set; }

        /// <summary>
        /// 物流单号
        /// </summary>		
        public string logistics_order_id { get; set; }

        /// <summary>
        /// 物流公司
        /// </summary>		
        public string logistics_company_name { get; set; }

        /// <summary>
        /// 公司Id,0和1是百伦
        /// </summary>		
        public int company_id { get; set; }

        /// <summary>
        /// 0：无需推送，1：未推送，2：推送成功，3：推送失败
        /// </summary>		
        public int ispush { get; set; }

        /// <summary>
        /// 1：调拨，0：非调拨
        /// </summary>		
        public int isallot { get; set; }

        public decimal amount { get; set; }
    }
}
