﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// ebay费用详情
    /// </summary>
    public class dc_base_finance_ebay
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime bj_create { get; set; }

        /// <summary>
        /// 数据中心更新时间
        /// </summary>
        public DateTime bj_modified { get; set; }

        /// <summary>
        /// 费用类型
        /// </summary>
        public string account_entry_type { get; set; }

        /// <summary>
        /// 费用描述
        /// </summary>
        public string description { get; set; }

        /// <summary>
        /// 费用产生时间,以GMT格式指示条目过帐到帐户的日期和时间
        /// </summary>
        public DateTime? gmt_date { get; set; }

        /// <summary>
        /// 费用产生时间,以GMT+8格式指示条目过帐到帐户的日期和时间
        /// </summary>
        public DateTime? bj_date { get; set; }

        /// <summary>
        /// ebay评估的总费用,包括净费用和增值税
        /// </summary>
        public decimal gross_amount { get; set; }

        /// <summary>
        /// item id
        /// </summary>
        public string item_id { get; set; }

        /// <summary>
        /// 费用条目的备注行
        /// </summary>
        public string memo { get; set; }

        /// <summary>
        /// ebay评估的净费用
        /// </summary>
        public decimal net_amount { get; set; }

        /// <summary>
        /// 帐户条目的唯一标识符
        /// </summary>
        public string ref_number { get; set; }

        /// <summary>
        /// 计算交易增值税（增值税）的适用税率
        /// </summary>
        public decimal vat_percent { get; set; }

        /// <summary>
        /// eBay用户帐户的货币交易或管理操作的描述或评论
        /// </summary>
        public string title { get; set; }

        /// <summary>
        /// eBay订单行项目的唯一标识符
        /// </summary>
        public string order_line_id { get; set; }

        /// <summary>
        /// 订单行项目的唯一标识符
        /// </summary>
        public string transaction_id { get; set; }

        /// <summary>
        /// 公司id
        /// </summary>
        public int company_id { get; set; }

        /// <summary>
        /// 是否有顶级折扣
        /// </summary>
        public int received_top_rated_discount { get; set; }

        /// <summary>
        /// 账号ID
        /// </summary>
        public int account_id { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string currency { get; set; }

        /// <summary>
        /// 汇率,根据bj_date取值
        /// </summary>
        public decimal exchange_rate { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public decimal gross_amount_rmb { get; set; }

        /// <summary>
        /// 帐号
        /// </summary>
        public string account_name { get; set; }
    }
}
