﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Orders
{
    /// <summary>
    /// FBA异常订单
    /// </summary>
    public class mFBAAbnormalOrder
    {
        /// <summary>
        /// 订单号
        /// </summary>
        public string origin_order_id { get; set; }

        /// <summary>
        /// 平台名称
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }

        /// <summary>
        /// 销售帐号
        /// </summary>
        public string seller_account { get; set; }

        /// <summary>
        /// 产品Sku
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 订单币种
        /// </summary>
        public string order_currency { get; set; }

        /// <summary>
        /// 订单原始币种FBA费
        /// </summary>
        public decimal cost_fba_fee { get; set; }

        /// <summary>
        /// 实际FBA费
        /// </summary>
        public decimal fba_fee_rmb { get; set; }

        /// <summary>
        /// 平均费用
        /// </summary>
        public decimal average_fba_fee { get; set; }

        /// <summary>
        /// 理论最小值FBA费
        /// </summary>
        public decimal min_fba_fee { get; set; }

        /// <summary>
        /// 理论最大值FBA费
        /// </summary>
        public decimal max_fba_fee { get; set; }

        /// <summary>
        /// 产品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 下单时间
        /// </summary>
        public DateTime create_time { get; set; }

        /// <summary>
        /// 销售订单汇率
        /// </summary>
        public decimal seller_order_exchange_rate { get; set; }

    }
}
