﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 应收账款明细
    /// </summary>
    public class dc_daily_receivable
    {
        public int id { get; set; }

        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform { get; set; }

        /// <summary>
        /// 记录日期
        /// </summary>
        public DateTime day { get; set; }

        /// <summary>
        /// 期初应收
        /// </summary>
        public decimal amount_start { get; set; }

        /// <summary>
        /// 付款维度的销售额
        /// </summary>
        public decimal amount_sale_pay { get; set; }

        /// <summary>
        /// 发货金额
        /// </summary>
        public decimal amount_shipping { get; set; }

        /// <summary>
        /// 退款金额
        /// </summary>
        public decimal amount_refund { get; set; }

        /// <summary>
        /// 发货维度的销售额
        /// </summary>
        public decimal amount_sale_shipping { get; set; }

        /// <summary>
        /// 平台费（佣金+FBA）
        /// </summary>
        public decimal amount_platformfee { get; set; }

        /// <summary>
        /// 放款金额
        /// </summary>
        public decimal amount_incoming { get; set; }

        /// <summary>
        /// 其他金额（手工调整金额）
        /// </summary>
        public decimal amount_other { get; set; }

        /// <summary>
        /// 期末金额
        /// </summary>
        public decimal amount_end { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createtime { get; set; }

        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime lastupdatetime { get; set; }

        /// <summary>
        /// 更新人id
        /// </summary>
        public int lastupdateuserid { get; set; }

        /// <summary>
        /// 更新人名称
        /// </summary>
        public string lastupdateusername { get; set; }

    }
}
