﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Bailun.ServiceFabric.Authorize;
using Bailun.ServiceFabric.Core.Extension.HttpContext;
using Microsoft.AspNetCore.Mvc;
using Bailun.ServiceFabric.Core.Extension;
using Bailun.DC.Models;
using Newtonsoft.Json;

namespace Bailun.DC.Web.Areas.Supplier.Controllers
{
    [Area("Supplier")]
    public class HomeController : Base.BaseController
    {
        public IActionResult Index()
        {
            return View();
        }

        public IActionResult ListLogisticsSupplierConfig()
        {
            return View();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="parameter"></param>
        /// <param name="supplier"></param>
        /// <param name="type">类型，1：需合并的，2：需删除不统计的</param>
        /// <returns></returns>
        public string ListLogisticsSupplierConfigJson(BtTableParameter parameter,string supplier,int type)
        {
            var total = 0;

            var obj = new Services.LogisticsServices().ListLogisticsSupplierConfig(parameter, supplier, type, ref total);

            var list = obj.Select(a => new { 
                a.suppliername,
                a.parentsuppliername,
                lastupdatetime = a.lastupdatetime.ToString("yyyy-MM-dd HH:mm:ss"),
                a.lastupdateusername,
                type = a.type==1?"需合并":"需删除",
            });

            return JsonConvert.SerializeObject(new
            {
                total = total,
                rows = list,
            });
        }

        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult DelLogisticsSupplierConfig(int id)
        {
            var user = HttpContextHelper.Current?.User;

            var result = new Services.LogisticsServices().DelLogisticsSupplierConfig(id, (user != null ? user.GetUid() : 0), (user != null ? user.GetUserName() : ""));

            return Json(new { 
                success = string.IsNullOrEmpty(result),
                msg = result
            });
        }


        public IActionResult SetLogisticsSupplierConfig()
        {
            return View();
        }


        public ActionResult AddLogisticsSupplierConfig()
        {
            return View();
        }

        /// <summary>
        /// 更新物流供应商往来的统计配置
        /// </summary>
        /// <param name="supplier">供应商名称</param>
        /// <param name="supplierparent">父级供应商名称</param>
        /// <param name="type">类型，1：需合并的，2：需删除不统计的</param>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult SetLogisticsSupplierConfigJson(string suppliername,string supplierparent,int type)
        {
            var user = HttpContextHelper.Current?.User;

            var result = new Services.LogisticsServices().SaveLogisticsSupplierConfig(suppliername, supplierparent, type, (user != null ? user.GetUid() : 0), (user != null ? user.GetUserName() : ""));

            return Json(new { 
                success = string.IsNullOrEmpty(result),
                msg = result
            });

        }

    }
}
