﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 用于计算itemno的利润率计算的订单明细
    /// </summary>
    public class dc_mid_itemno_profit_order
    {
        public int id { get; set; }

        /// <summary>
        /// 记录日期
        /// </summary>
        public DateTime day { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public double order_sku_id { get; set; }

        /// <summary>
        /// 百伦单号
        /// </summary>
        public string bailun_order_id { get; set; }

        /// <summary>
        /// 平台单号
        /// </summary>
        public string origin_order_id { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public string item_id { get; set; }

        /// <summary>
        /// 平台SKU
        /// </summary>
        public string platform_sku { get; set; }

        /// <summary>
        /// itemid 的销售数量
        /// </summary>
        public int platform_sku_quantity_ordered { get; set; }

        /// <summary>
        /// 映射百伦SKU数量
        /// </summary>
        public int count { get; set; }

        /// <summary>
        /// 百伦SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 付款时间
        /// </summary>
        public DateTime paid_time { get; set; }

        /// <summary>
        /// 平台付款时间
        /// </summary>
        //public DateTime? platform_paid_time { get; set; }

        /// <summary>
        /// 销售额
        /// </summary>
        public decimal amount_sales { get; set; }

        /// <summary>
        /// 产品成本
        /// </summary>
        public decimal cost_product { get; set; }

        /// <summary>
        /// 平台费
        /// </summary>
        public decimal cost_platform_fee { get; set; }

        /// <summary>
        /// paypal费
        /// </summary>
        public decimal cost_paypal_fee { get; set; }

        /// <summary>
        /// fba费
        /// </summary>
        public decimal cost_fba_fee { get; set; }

        /// <summary>
        /// 头程费-根据LMS线路算出来的
        /// </summary>
        public decimal cost_first { get; set; }

        /// <summary>
        /// 物流费-真实物流费，取不到则LMS
        /// </summary>
        public decimal cost_logistics { get; set; }

        /// <summary>
        /// 处理费-平台收取收取
        /// </summary>
        public decimal cost_handle_platform { get; set; }

        /// <summary>
        /// 处理费-百伦收取
        /// </summary>
        public decimal cost_handle_bailun { get; set; }

        /// <summary>
        /// 发货仓库
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 发货状态
        /// </summary>
        public string shipping_status { get; set; }

        /// <summary>
        /// 转RMB汇率
        /// </summary>
        public decimal seller_order_exchange_rate { get; set; }

        /// <summary>
        /// ebay 平台费 转RMB汇率
        /// </summary>
        public decimal seller_other_exchange_rate { get; set; }

        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }

        /// <summary>
        /// 销售帐号
        /// </summary>
        public int bailun_account_id { get; set; }

        /// <summary>
        /// 提现损耗
        /// </summary>
        public decimal losswithdraw { get; set; }

        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime ts { get; set; }

        /// <summary>
        /// 是否预估
        /// </summary>
        public int is_forecast { get; set; }
    }
}
