﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 物流供应商往来统计报表
    /// </summary>
    public class dc_daily_logistics_supplier_transaction
    {
        public int id { get; set; }

        /// <summary>
        /// 统计日期
        /// </summary>
        public DateTime day { get; set; }

        /// <summary>
        /// 供应商id
        /// </summary>
        public int? supplierid { get; set; }

        /// <summary>
        /// 供应商名称
        /// </summary>
        public string suppliername { get; set; }

        /// <summary>
        /// 期初金额
        /// </summary>
        public decimal amount_start { get; set; }

        /// <summary>
        /// 发生额
        /// </summary>
        public decimal amount_happen { get; set; }

        /// <summary>
        /// 付款额
        /// </summary>
        public decimal amount_pay { get; set; }

        /// <summary>
        /// 收款额
        /// </summary>
        public decimal amount_receipt { get; set; }

        /// <summary>
        /// 其他金额（调整金额）
        /// </summary>
        public decimal amount_other { get; set; }

        /// <summary>
        /// 期末金额 = 期初+发生额-付款额+收款额+其他金额
        /// </summary>
        public decimal amount_end { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime createtime { get; set; }

        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime lastupdatetime { get; set; }

        /// <summary>
        /// 最后更新人id
        /// </summary>
        public int lastupdateuserid { get; set; }

        /// <summary>
        /// 最后更新人名称
        /// </summary>
        public string lastupdateusername { get; set; }
        
    }
}
