﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 百伦头程费信息, 是WMS根据线路估算而来 根据完成时间同步
    /// </summary>
    public class dc_base_cost_first_finish
    {
        /// <summary>
        /// 
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 物流单号,一个物流单可能多个调拨单
        /// </summary>
        public string channel_order_id { get; set; }

        /// <summary>
        /// 物流主键ID, 用来判断唯一
        /// </summary>
        public int channel_id { get; set; }

        /// <summary>
        /// 箱号
        /// </summary>
        public string box_id { get; set; }

        /// <summary>
        /// 调拨单号
        /// </summary>
        public string transfer_order_id { get; set; }

        /// <summary>
        /// 根据物流主键id分组的  头程费_RMB（总）
        /// </summary>
        public decimal cost_first { get; set; }

        /// <summary>
        /// 报关费
        /// </summary>
        public decimal cost_goods_clearance { get; set; }

        /// <summary>
        /// 关税预付
        /// </summary>
        public decimal cost_duty { get; set; }

        /// <summary>
        /// 清关费
        /// </summary>
        public decimal cost_customs_clearance { get; set; }

        /// <summary>
        /// 原始重量邮费
        /// </summary>
        public decimal cost_weight { get; set; }

        /// <summary>
        /// 燃油附加费
        /// </summary>
        public decimal cost_fuel { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 区域Id
        /// </summary>
        public int area_id { get; set; }

        /// <summary>
        /// 公司ID, 0和1是百伦
        /// </summary>
        public int company_id { get; set; }

        /// <summary>
        /// 百伦SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 数量
        /// </summary>
        public int quantity { get; set; }

        /// <summary>
        /// 单个SKU重量,需要按重量计算比例
        /// </summary>
        public decimal sku_weight { get; set; }

        /// <summary>
        /// SKU重量占比
        /// </summary>
        public decimal sku_weight_ratio { get; set; }

        /// <summary>
        /// SKU重量加权平均头程费用
        /// </summary>
        public decimal sku_cost_first { get; set; }

        /// <summary>
        /// 计算时    sku的实时库存
        /// </summary>
        public int sku_stock_quantity { get; set; }

        /// <summary>
        /// 计算前    sku平均头程费 dc_mid_cost_first.cost_first
        /// </summary>
        public decimal pre_avl_sku_cost_first { get; set; }

        /// <summary>
        /// 计算后    sku平均头程费 dc_mid_cost_first.cost_first
        /// </summary>
        public decimal after_avl_sku_cost_first { get; set; }

        /// <summary>
        /// 是否 需要计算平均头程费
        /// </summary>
        public int has_calculation { get; set; }

        /// <summary>
        /// 调拨单完成时间
        /// </summary>
        public DateTime operation_time { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime bj_create_time { get; set; }

        public decimal change_rate { get; set; }

        public int exception_type { get; set; }


        public string warehouse_name { get; set; }
    }
}
