﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Warehouse
{
    public class mWarehouseRedundancy
    {
        /// <summary>
        /// sku编码
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// sku仓库数量
        /// </summary>
        public int usable_stock { get; set; }

        /// <summary>
        /// sku中文标题
        /// </summary>
        public string sku_title_cn { get; set; }

        /// <summary>
        /// 采购价格
        /// </summary>
        public decimal unit_price { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 冗余数量
        /// </summary>
        public int? quantity { get; set; }

        /// <summary>
        /// 缺货数
        /// </summary>
        public int? quantity_out_stock { get; set; }

        /// <summary>
        /// 昨日销量
        /// </summary>
        public int? oneday_total_sales { get; set; }

        /// <summary>
        /// 近3天销量
        /// </summary>
        public int? threeday_total_sales { get; set; }

        /// <summary>
        /// 近7天销量
        /// </summary>
        public int? sevenday_total_sales { get; set; }

        /// <summary>
        /// 近14天销量
        /// </summary>
        public int? fourteenday_total_sales { get; set; }

        /// <summary>
        /// 近30天销量
        /// </summary>
        public int? thirtyday_total_sales { get; set; }

        /// <summary>
        /// 近3天日均销量
        /// </summary>
        public decimal? threeday_average_sales { get; set; }

        /// <summary>
        /// 近7天日均销量
        /// </summary>
        public decimal? sevenday_average_sales { get; set; }

        /// <summary>
        /// 近14天日均销量
        /// </summary>
        public decimal? fourteenday_average_sales { get; set; }

        /// <summary>
        /// 近30天日均销量
        /// </summary>
        public decimal? thirtyday_average_sales { get; set; }

        /// <summary>
        /// 采购在途数
        /// </summary>
        public int? quantity_purchase { get; set; }

        /// <summary>
        /// 调拨在途数
        /// </summary>
        public int? quantity_transfer { get; set; }
        
        /// <summary>
        /// 产品编码
        /// </summary>
        public string product_code { get; set; }

        /// <summary>
        /// 百伦分类id
        /// </summary>
        public int bailun_category_id { get; set; }

        /// <summary>
        /// 百伦分类名称
        /// </summary>
        public string bailun_category_name { get; set; }

        /// <summary>
        /// 监控状态，0：正在监控，1：停止监控
        /// </summary>
        public int? monitorstatus { get; set; }

        /// <summary>
        /// 侵权状态，1：已侵权，0：未侵权
        /// </summary>
        public int? tortstatus { get; set; }

    }
}
