﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.DailyPlatformAccountBalance.Models
{
    public class mAccountInfo
    {
        public int Id { get; set; }
        /// <summary>
        /// 销售帐号
        /// </summary>
        public string Account { get; set; }

        public int Plateform { get; set; }

        public string PlateformText { get; set; }

        //public List<mAccountBalance> BalanceDetail { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateName { get; set; }
        /// <summary>
        /// 更新人
        /// </summary>
        public string UpdateName { get; set; }
        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime UpdateTime { get; set; }

        /// <summary>
        /// 数据来源
        /// </summary>
        public string AccessMethod { get; set; }

        public List<AmountRMB> Currencymoney { get; set; }
    }


    public class AmountRMB
    {
        public int Id { get; set; }

        public int AccountId { get; set; }

        /// <summary>
        /// 币种
        /// </summary>
        public string Currency { get; set; }
        /// <summary>
        /// 币种兑换率
        /// </summary>
        public decimal CurrencyRate { get; set; }
        /// <summary>
        /// 兑换后的可用人民币=AvailableAmount*CurrencyRate
        /// </summary>
        public decimal AvailableCurrencyAmount { get; set; }
        /// <summary>
        /// 可用金额
        /// </summary>
        public decimal AvailableAmount { get; set; }
        /// <summary>
        /// 冻结金额
        /// </summary>
        public decimal FrozenMoney { get; set; }
        /// <summary>
        /// 兑换后的冻结人民币=FrozenMoney*CurrencyRate
        /// </summary>
        public decimal FrozenCurrencyAmount { get; set; }
        /// <summary>
        /// 合计总额=可用金额+冻结金额
        /// </summary>
        public decimal TotalAmount { get; set; }
        /// <summary>
        /// 兑换后的总额人民币=TotalAmount*CurrencyRate
        /// </summary>
        public decimal TotalCurrencyAmount { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreateTime { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateName { get; set; }
        /// <summary>
        /// 更新人
        /// </summary>
        public string UpdateName { get; set; }
        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime UpdateTime { get; set; }
    }


    public class mAccountBalance
    {
        /// <summary>
        /// 币种
        /// </summary>
        public string CurrencyType { get; set; }
        /// <summary>
        /// 币种兑换率
        /// </summary>
        public decimal CurrencyRate { get; set; }
        /// <summary>
        /// 兑换后的可用人民币=AvailableAmount*CurrencyRate
        /// </summary>
        public decimal AvailableCurrencyAmount { get; set; }
        /// <summary>
        /// 可用金额
        /// </summary>
        public decimal AvailableAmount { get; set; }
        /// <summary>
        /// 冻结金额
        /// </summary>
        public decimal FrozenMoney { get; set; }
        /// <summary>
        /// 兑换后的冻结人民币=FrozenMoney*CurrencyRate
        /// </summary>
        public decimal FrozenCurrencyAmount { get; set; }
        /// <summary>
        /// 合计总额=可用金额+冻结金额
        /// </summary>
        public decimal TotalAmount { get; set; }
        /// <summary>
        /// 兑换后的总额人民币=TotalAmount*CurrencyRate
        /// </summary>
        public decimal TotalCurrencyAmount { get; set; }
        

    }

    public class RequestResult
    {
        public int code { get; set; }

        public string msg { get; set; }

        public int count { get; set; }

        public List<mAccountInfo> data { get; set; }
    }
}
