﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Web;

namespace Bailun.DC.Models
{
    public class dc_balance_sheet
    {
        [Description("")]
        public int id { get; set; }

        /// <summary>
        /// 公司主体value
        /// </summary>
        [Description("")]
        public int company_value { get; set; }

        /// <summary>
        /// 公司名称
        /// </summary>
        [Description("")]
        public string company_name { get; set; }

        /// <summary>
        /// 货币资金
        /// </summary>
        [Description("货币资金")]
        public decimal monetary_fund { get; set; }

        /// <summary>
        /// 提现在途金额
        /// </summary>
        [Description("1.平台提现在途")]
        public decimal? withdraw_amount { get; set; }


        /// <summary>
        /// 第三方平台余额
        /// </summary>
        [Description("2.第三方平台余额")]
        public decimal? platform_balance { get; set; }

        /// <summary>
        /// 银行帐号余额
        /// </summary>
        [Description("3.银行帐号余额")]
        public decimal? bank_account_balance { get; set; }

        /// <summary>
        /// （流动资产）交易性金融资金
        /// </summary>
        [Description("交易性金融资金")]
        public decimal? fa_trading_finan_asset { get; set; }

        /// <summary>
        /// 应收票据
        /// </summary>
        [Description("应收票据")]
        public decimal? fa_bill_receivable { get; set; }

        /// <summary>
        /// 应收账款
        /// </summary>
        [Description("应收账款")]
        public decimal accounts_receivable { get; set; }

        /// <summary>
        /// 借支金额
        /// </summary>
        [Description("借支金额")]
        public decimal amount_borrowed { get; set; }

        /// <summary>
        /// 预付款项
        /// </summary>
        [Description("预付款项")]
        public decimal prepayment { get; set; }

        /// <summary>
        /// 成品供应商预付款项
        /// </summary>
        [Description("1.预付成品供应商")]
        public decimal? finished_prepayment { get; set; }

        /// <summary>
        /// 半成品供应商预付款项
        /// </summary>
        [Description("2.预付半成品供应商")]
        public decimal? semi_prepayment { get; set; }

        /// <summary>
        /// 物流供应商预付款项
        /// </summary>
        [Description("3.预付物流供应商")]
        public decimal? logistics_prepayment { get; set; }

        /// <summary>
        /// 应收利息
        /// </summary>
        [Description("应收利息")]
        public decimal? fa_interest_receivable { get; set; }

        /// <summary>
        /// 应收股利
        /// </summary>
        [Description("应收股利")]
        public decimal? fa_dividends_receivable { get; set; }

        /// <summary>
        /// 其他应收款
        /// </summary>
        [Description("其他应收款")]
        public decimal other_accounts_receivable { get; set; }

        /// <summary>
        /// 存货余额/库存金额
        /// </summary>
        [Description("存货")]
        public decimal inventory_amount { get; set; }

        /// <summary>
        /// FBA库存金额
        /// </summary>
        [Description("1.存货FBA仓在库")]
        public decimal? fba_inventory_amount { get; set; }

        /// <summary>
        /// 非FBA库存金额
        /// </summary>
        [Description("2.存货非FBA仓在库")]
        public decimal? not_fba_inventory_amount { get; set; }

        /// <summary>
        /// FBA在途金额
        /// </summary>
        [Description("3.存货FBA仓在途")]
        public decimal? fba_transfer_amount { get; set; }

        /// <summary>
        /// 非FBA在途金额
        /// </summary>
        [Description("4.存货非FBA仓在途")]
        public decimal? not_fba_transfer_amount { get; set; }
        
        /// <summary>
        /// 半成品在库金额
        /// </summary>
        [Description("5.存货半成品在库")]
        public decimal? semi_inventory_amount { get; set; }

        [Description("百伦半成品在库")]
        public decimal? semi_bailun_inventory_amount { get; set; }
        [Description("哈尼曼半成品在库")]
        public decimal? semi_hani_inventory_amount { get; set; }


        [Description("6.FBA在途(不包调拨计划)")]
        public decimal? fba_transfer_allot_amount { get; set; }

        [Description("7.非FBA在途金额(不包调拨计划)")]
        public decimal? not_fba_transfer_allot_amount { get; set; }

        [Description("8.FBA在途金额(调拨计划)")]
        public decimal? fba_transfer_plan_amount { get; set; }

        [Description("9.非FBA在途金额(调拨计划)")]
        public decimal? not_fba_transfer_plan_amount { get; set; }

        [Description("10.FBA在途金额(采购)")]
        public decimal? fba_purchase_amount { get; set; }

        [Description("11.非FBA在途金额(采购)")]
        public decimal? not_fba_purchase_amount { get; set; }

        /// <summary>
        /// 半成品在途金额
        /// </summary>
        public decimal? semi_transfer_amount { get; set; }

        [Description("百伦半成品在途")]
        public decimal? semi_bailun_transfer_amount { get; set; }
        [Description("哈尼曼半成品在途")]
        public decimal? semi_hani_transfer_amount { get; set; }

        /// <summary>
        /// 一年内到期的非流动资产
        /// </summary>
        [Description("一年内到期的非流动资产")]
        public decimal? fa_oneyear_noncurrent_assets { get; set; }

        /// <summary>
        /// 其他流动资产
        /// </summary>
        [Description("其他流动资产")]
        public decimal? fa_other_assets { get; set; }

        /// <summary>
        /// 流动资产合计
        /// </summary>
        [Description("流动资产合计")]
        public decimal? fa_count { get; set; }

        /// <summary>
        /// 可供出售金融资产
        /// </summary>
        [Description("可供出售金融资产")]
        public decimal? nca_avai_for_sale_fassets { get; set; }

        /// <summary>
        /// 持有至到期的投资
        /// </summary>
        [Description("持有至到期投资")]
        public decimal? nca_heldon_investment { get; set; }

        /// <summary>
        /// 长期应收款
        /// </summary>
        [Description("长期应收款")]
        public decimal? nca_longterm_receivable { get; set; }

        /// <summary>
        /// 长期股权投资
        /// </summary>
        [Description("长期股权投资")]
        public decimal? nca_longterm_equity_investment { get; set; }

        /// <summary>
        /// 投资性房地产
        /// </summary>
        [Description("投资性房地产")]
        public decimal? nca_investment_property { get; set; }

        /// <summary>
        /// 固定资产
        /// </summary>
        [Description("固定资产")]
        public decimal fixed_assets { get; set; }

        /// <summary>
        /// 在建工程
        /// </summary>
        [Description("在建工程")]
        public decimal? nca_construction_in_process { get; set; }

        /// <summary>
        /// 工程物资
        /// </summary>
        [Description("工程物资")]
        public decimal? nca_engineering_material { get; set; }

        /// <summary>
        /// 固定资产清理
        /// </summary>
        [Description("固定资产清理")]
        public decimal? nca_disposal_of_fixed_assets { get; set; }

        /// <summary>
        /// 生产性生物资产
        /// </summary>
        [Description("生产性生物资产")]
        public decimal? nca_productive_biological_asset { get; set; }

        /// <summary>
        /// 油气资产
        /// </summary>
        [Description("油气资产")]
        public decimal? nca_oil_and_gas_assets { get; set; }

        /// <summary>
        /// 无形资产
        /// </summary>
        [Description("无形资产")]
        public decimal? nca_intangible_assets { get; set; }

        /// <summary>
        /// 开发支出
        /// </summary>
        [Description("开发支出")]
        public decimal? nca_development_expenditure { get; set; }

        /// <summary>
        /// 商誉
        /// </summary>
        [Description("商誉")]
        public decimal? nca_goodwill { get; set; }

        /// <summary>
        /// 长期待摊费用
        /// </summary>
        [Description("长期待摊费用")]
        public decimal? nca_longterm_unamortized_expenses { get; set; }

        /// <summary>
        /// 递延所得税资产
        /// </summary>
        [Description("递延所得税资产")]
        public decimal? nca_deferred_tax_assets { get; set; }

        /// <summary>
        /// 其他非流动资产
        /// </summary>
        [Description("其他非流动资产")]
        public decimal? nca_other_assets { get; set; }

        /// <summary>
        /// 非流动资产合计
        /// </summary>
        [Description("非流动资产合计")]
        public decimal? nca_count { get; set; }

        /// <summary>
        /// 资产合计
        /// </summary>
        [Description("资产总计")]
        public decimal? count_assets { get; set; }
        
        /// <summary>
        /// 短期借款
        /// </summary>
        [Description("短期借款")]
        public decimal short_term_borrow { get; set; }

        /// <summary>
        /// 交易性金融负债
        /// </summary>
        [Description("交易性金融负债")]
        public decimal? cl_trading_financ_liabilities { get; set; }

        /// <summary>
        /// 应付票据
        /// </summary>
        [Description("应付票据")]
        public decimal? cl_notes_payable { get; set; }

        /// <summary>
        /// 应付账款
        /// </summary>
        [Description("应付账款")]
        public decimal accounts_payable { get; set; }

        /// <summary>
        /// 成品供应商应付账款
        /// </summary>
        [Description("1.成品供应商")]
        public decimal? finished_accounts_payable { get; set; }

        /// <summary>
        /// 半成品供应商应付账款
        /// </summary>
        [Description("2.应付半成品供应商")]
        public decimal? semi_accounts_payable { get; set; }

        /// <summary>
        /// 物流供应商应付账款
        /// </summary>
        [Description("3.应付物流供应商")]
        public decimal? logistics_accounts_payable { get; set; }


        /// <summary>
        /// 预收款项
        /// </summary>
        [Description("预收款项")]
        public decimal advance_received { get; set; }

        /// <summary>
        /// 应付职工薪酬
        /// </summary>
        [Description("应付职工薪酬")]
        public decimal payable_remuneration { get; set; }

        /// <summary>
        /// 应交税费
        /// </summary>
        [Description("应交税费")]
        public decimal taxes_payable { get; set; }

        /// <summary>
        /// 应付利息
        /// </summary>
        [Description("应付利息")]
        public decimal? cl_payable_interest { get; set; }

        /// <summary>
        /// 应付股利
        /// </summary>
        [Description("应付股利")]
        public decimal? cl_dividends_payable { get; set; }

        /// <summary>
        /// 其他应付款
        /// </summary>
        [Description("其他应付款")]
        public decimal other_accounts_payable { get; set; }

        /// <summary>
        /// 一年内到期的非流动负债
        /// </summary>
        [Description("一年内到期的非流动负债")]
        public decimal? cl_oneyear_noncurrent_liabilities { get; set; }

        /// <summary>
        /// 其他流动负债
        /// </summary>
        [Description("其他流动负债")]
        public decimal? cl_other_liabilities { get; set; }

        /// <summary>
        /// 流动负债合计
        /// </summary>
        [Description("流动负债合计")]
        public decimal? cl_count { get; set; }

        /// <summary>
        /// 长期借款
        /// </summary>
        [Description("长期借款")]
        public decimal? ncl_longterm_loan { get; set; }

        /// <summary>
        /// 应付债券
        /// </summary>
        [Description("应付债券")]
        public decimal? ncl_bonds_payable { get; set; }

        /// <summary>
        /// 长期应付款
        /// </summary>
        [Description("长期应付款")]
        public decimal long_term_accounts_payable { get; set; }
        

        /// <summary>
        /// 专项应付款
        /// </summary>
        [Description("专项应付款")]
        public decimal? ncl_special_payable { get; set; }

        /// <summary>
        /// 预计负债
        /// </summary>
        [Description("预计负债")]
        public decimal? ncl_anticipation_liabilities { get; set; }

        /// <summary>
        /// 递延所得税负债
        /// </summary>
        [Description("递延所得税负债")]
        public decimal? ncl_deferred_income_tax_liabilities { get; set; }

        /// <summary>
        /// 其他非流动负债
        /// </summary>
        [Description("其他非流动负债")]
        public decimal? ncl_other_liabilities { get; set; }

        /// <summary>
        /// 非流动负债合计
        /// </summary>
        [Description("非流动负债合计")]
        public decimal? ncl_count { get; set; }

        /// <summary>
        /// 负债合计
        /// </summary>
        [Description("负债合计")]
        public decimal? count_liabilities { get; set; }

        /// <summary>
        /// 实收资本
        /// </summary>
        [Description("实收资本")]
        public decimal? oe_paicl_up_capital { get; set; }

        /// <summary>
        /// 资本公积
        /// </summary>
        [Description("资本公积")]
        public decimal? oe_capital_reserve { get; set; }

        /// <summary>
        /// (减)库存额
        /// </summary>
        [Description("(减)库存额")]
        public decimal? oe_inventory_amount { get; set; }

        /// <summary>
        /// 盈余公积
        /// </summary>
        [Description("盈余公积")]
        public decimal? oe_surplus_public_accumulation { get; set; }

        /// <summary>
        /// 未分配利润
        /// </summary>
        [Description("未分配利润")]
        public decimal? oe_undistributed_profit { get; set; }

        /// <summary>
        /// 所有者权益合计
        /// </summary>
        [Description("所有者权益合计")]
        public decimal? oe_count { get; set; }

        /// <summary>
        /// 负债和所有者权益合计
        /// </summary>
        [Description("负债和所有者权益合计")]
        public decimal? count_liabilities_and_oe { get; set; }

        /// <summary>
        /// 统计时间
        /// </summary>
        [Description("")]
        public DateTime statistical_time { get; set; }

        /// <summary>
        /// 取数时间
        /// </summary>
        [Description("")]
        public DateTime update_time { get; set; }

        /// <summary>
        /// 是否标记
        /// </summary>
        public int ismark { get; set; }
    }
}