﻿//日期格式化
Date.prototype.format = function (format) {
    var o = {
        "M+": this.getMonth() + 1, //month 
        "d+": this.getDate(), //day 
        "h+": this.getHours(), //hour 
        "m+": this.getMinutes(), //minute 
        "s+": this.getSeconds(), //second 
        "q+": Math.floor((this.getMonth() + 3) / 3), //quarter 
        "S": this.getMilliseconds() //millisecond 
    }

    if (/(y+)/.test(format)) {
        format = format.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    }

    for (var k in o) {
        if (new RegExp("(" + k + ")").test(format)) {
            format = format.replace(RegExp.$1, RegExp.$1.length == 1 ? o[k] : ("00" + o[k]).substr(("" + o[k]).length));
        }
    }
    return format;
}

// 日期相等判断
Date.prototype.equals = function (date1, date2) {
    return date1 - date2 == 0;
}

//字符串日期格式化
String.prototype.formatDate = function (format) {
    return this ? eval(this.replace(/\/Date\((\d+)\)\//gi, "new Date($1)")).Format(format ? format : 'yyyy-MM-dd hh:mm:ss') : null;
}

//字符串格式化
String.prototype.format = function () {
    var values = arguments;
    return this.replace(/\{(\d+)\}/g, function (match, index) {
        if (values.length > index) {
            return values[index];
        } else {
            return "";
        }
    });
};

//数组去重
Array.prototype.distinct = function () {
    function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

    function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

    function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

    function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

    return _toConsumableArray(new Set(this));
}

//数组求和
Array.prototype.sum = function (f) {
    const arr = f ? this.map(f) : this;
    return arr.length && arr.reduce(function (result, item) {
        return result + item;
    });
}

//数组扁平化
Array.prototype.flatTemp = Array.prototype.flat;
Array.prototype.flat = function (depth) {
    return Array.flatTemp && Array.flatTemp(depth) || this.reduce(function (pre, cur) {
        return pre.concat(Array.isArray(cur) ? cur.flat() : cur);
    }, []);
}

//数组扁平化
Array.prototype.flatMapTemp = Array.prototype.flatMap;
Array.prototype.flatMap = function (f) {
    return Array.flatMapTemp && Array.flatMapTemp(f) || this.reduce(function (pre, cur) {
        return pre.concat(Array.isArray(f(cur)) ? f(cur).flat() : f(cur));
    }, []);
}

//数组分组
Array.prototype.group = function (f, groupName, groupListName) {
    const that = this;
    const arrDistinct = f instanceof Object ? this.map(f).map(function (l) {
        return JSON.stringify(l);
    }).distinct().map(function (l) {
        return JSON.parse(l);
    }) : this.map(f).distinct();
    const arr = [];
    arrDistinct.forEach(function (o, i, a) {
        if (groupName) {
            var _arr$push;

            function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

            function _instanceof(left, right) { if (right != null && typeof Symbol !== "undefined" && right[Symbol.hasInstance]) { return !!right[Symbol.hasInstance](left); } else { return left instanceof right; } }

            arr.push((_arr$push = {}, _defineProperty(_arr$push, groupName, o), _defineProperty(_arr$push, groupListName ? groupListName : "", that.filter(function (v) {
                return _instanceof(o, Object) ? JSON.stringify(Object.values(f(v))) == JSON.stringify(Object.values(o)) && JSON.stringify(Object.keys(f(v))) == JSON.stringify(Object.keys(o)) : f(v) == o;
            })), _arr$push));
        } else {
            var obj = {};
            obj[o] = that.filter(function (v) {
                return o instanceof Object ?
                    (JSON.stringify(Object.values(f(v))) == JSON.stringify(Object.values(o)) && JSON.stringify(Object.keys(f(v))) == JSON.stringify(Object.keys(o))) :
                    f(v) == o;
            });
            arr.push(obj);
        }
    });

    return arr;
}

//IE数组findIndex
if (!Array.prototype.findIndex) {
    Object.defineProperty(Array.prototype, 'findIndex', {
        value: function (predicate) {
            // 1. Let O be ? ToObject(this value).
            if (this == null) {
                throw new TypeError('"this" is null or not defined');
            }
            var o = Object(this);
            // 2. Let len be ? ToLength(? Get(O, "length")).
            var len = o.length >>> 0;
            // 3. If IsCallable(predicate) is false, throw a TypeError exception.
            if (typeof predicate !== 'function') {
                throw new TypeError('predicate must be a function');
            }
            // 4. If thisArg was supplied, let T be thisArg; else let T be undefined.
            var thisArg = arguments[1];
            // 5. Let k be 0.
            var k = 0;
            // 6. Repeat, while k < len
            while (k < len) {
                var kValue = o[k];
                if (predicate.call(thisArg, kValue, k, o)) {
                    return k;
                }
                k++;
            }
            // 7. Return -1.
            return -1;
        }
    });
}

if (!Array.prototype.find) {
    Array.prototype.find = function (callback) {
        return callback && (this.filter(callback) || [])[0];
    };
}

//对象转数组
Object.defineProperty(Object.prototype, 'toArray', {
    writable: false,
    enumerable: false,
    configurable: true,
    value: function () {
        var queen = [];
        var out = [];
        queen = queen.concat(this);
        while (queen.length) {
            var first = queen.shift();
            if (first.children) {
                queen = queen.concat(first.children)
                //delete first['children'];
            }

            out.push(first);
        }
        return out;
    }
})

Array.prototype.includes = function (search, start) {
    if (typeof start !== 'number') {
        start = 0;
    }

    if (start + search.length > this.length) {
        return false;
    } else {
        return this.indexOf(search, start) !== -1;
    }
};

function GUID() {
    this.date = new Date();

    /* 判断是否初始化过，如果初始化过以下代码，则以下代码将不再执行，实际中只执行一次 */
    if (typeof this.newGUID != 'function') {

        /* 生成GUID码 */
        GUID.prototype.newGUID = function () {
            this.date = new Date();
            var guidStr = '';
            sexadecimalDate = this.hexadecimal(this.getGUIDDate(), 16);
            sexadecimalTime = this.hexadecimal(this.getGUIDTime(), 16);
            for (var i = 0; i < 9; i++) {
                guidStr += Math.floor(Math.random() * 16).toString(16);
            }
            guidStr += sexadecimalDate;
            guidStr += sexadecimalTime;
            while (guidStr.length < 32) {
                guidStr += Math.floor(Math.random() * 16).toString(16);
            }
            return this.formatGUID(guidStr);
        }

        /*
         * 功能：获取当前日期的GUID格式，即8位数的日期：19700101
         * 返回值：返回GUID日期格式的字条串
         */
        GUID.prototype.getGUIDDate = function () {
            return this.date.getFullYear() + this.addZero(this.date.getMonth() + 1) + this.addZero(this.date.getDay());
        }

        /*
         * 功能：获取当前时间的GUID格式，即8位数的时间，包括毫秒，毫秒为2位数：12300933
         * 返回值：返回GUID日期格式的字条串
         */
        GUID.prototype.getGUIDTime = function () {
            return this.addZero(this.date.getHours()) + this.addZero(this.date.getMinutes()) + this.addZero(this.date.getSeconds()) + this.addZero(parseInt(this.date.getMilliseconds() / 10));
        }

        /*
        * 功能: 为一位数的正整数前面添加0，如果是可以转成非NaN数字的字符串也可以实现
         * 参数: 参数表示准备再前面添加0的数字或可以转换成数字的字符串
         * 返回值: 如果符合条件，返回添加0后的字条串类型，否则返回自身的字符串
         */
        GUID.prototype.addZero = function (num) {
            if (Number(num).toString() != 'NaN' && num >= 0 && num < 10) {
                return '0' + Math.floor(num);
            } else {
                return num.toString();
            }
        }

        /* 
         * 功能：将y进制的数值，转换为x进制的数值
         * 参数：第1个参数表示欲转换的数值；第2个参数表示欲转换的进制；第3个参数可选，表示当前的进制数，如不写则为10
         * 返回值：返回转换后的字符串
         */
        GUID.prototype.hexadecimal = function (num, x, y) {
            if (y != undefined) {
                return parseInt(num.toString(), y).toString(x);
            } else {
                return parseInt(num.toString()).toString(x);
            }
        }

        /*
         * 功能：格式化32位的字符串为GUID模式的字符串
         * 参数：第1个参数表示32位的字符串
         * 返回值：标准GUID格式的字符串
         */
        GUID.prototype.formatGUID = function (guidStr) {
            var str1 = guidStr.slice(0, 8) + '-',
                str2 = guidStr.slice(8, 12) + '-',
                str3 = guidStr.slice(12, 16) + '-',
                str4 = guidStr.slice(16, 20) + '-',
                str5 = guidStr.slice(20);
            return str1 + str2 + str3 + str4 + str5;
        }
    }
}