﻿Vue.component('el-form-control', {
    props: {
        item: {
            type: Object,
            default: {}
        },
        //绑定值
        value: {
            default: null
        },
        //数据源
        scope: {
            default: null
        },
        //是否禁用
        disabled: {
            default: null
        },
        //表单
        form: {
            default: null
        }
    },
    //双向绑定
    model: {
        prop: "value",
        event: "change"
    },
    //监听
    watch: {
        value: {
            handler(val) {
                if (this.item.type == 'number' && val == null) {
                    val = undefined;
                }
                if (val) {
                    if (this.item.type == 'select' && this.item.listOption && this.item.listOption.length) {
                        if (this.item.listOption[0].value.constructor == String && val.constructor == Number) {
                            val = val.toString();
                        } else if (this.item.listOption[0].value.constructor == Number && !isNaN(parseInt(val))) {
                            val = parseInt(val);
                        }
                    }
                    if (this.item.type == 'daterange' && val.constructor == Array && val.length > 1 && val[0].constructor == String && val[1].constructor == String) {
                        val = [new Date(val[0]), new Date(val[1])];
                    }
                }
                this.$set(this, "item_value", val);
            },
            deep: true,
            immediate: true
        },
        item_value: {
            handler(val) {
                this.$emit("change", val)
            },
            deep: true
        }
    },
    data() {
        return {
            //加载
            loading: false,
            //值
            item_value: null,
            //表单标题
            formTitle: null,
            //表单编码
            formCode: null
        }
    },
    created() {
    },
    mounted() {
        //设置默认值
        this.setDefaultValue()
    },
    methods: {
        //自定义JS
        javaScript(js, $event, item) {
            var form = this.form
            var scope = this.scope;
            if (js) {
                return eval(js)
            }
        },
        visibleChange(visible, item) {
            var that = this
            if (visible && item.api && (!item.listOption || item.listOption.length <= 1 || (that.form && item.prop && that.form[item.prop] && Array.isArray(that.form[item.prop]) && that.form[item.prop].length == item.listOption.length))) {
                that.$set(that, "loading", true)
                var params = {}
                if (item.params) {
                    var form = that.form
                    try {
                        Object.assign(params, eval("(" + item.params + ")"))
                    } catch (error) {
                        console.log(error)
                    }
                }
                //父级联动
                if (item.parentProp) {
                    if (that.form && that.form.listFilterControl && that.form.listFilterControl.length) {
                        var parentItem = that.form.listFilterControl.find(function (l) { return l.prop == item.parentProp });
                        if (parentItem && parentItem.value) {
                            params[item.parentProp] = parentItem.value;
                        } else {
                            delete params[item.parentProp];
                        }
                    }
                }
                var method = item.apiMethod && item.apiMethod.toLocaleLowerCase() == "post" ? item.apiMethod : 'get';
                that.$http({
                    method: method,
                    control: "select",
                    url: item.api,
                    params: method == "get" ? params : null,
                    body: method == "post" ? params : null,
                    emulateJSON: method == "post"
                }).then(function (response) {
                    var result = response.data;
                    if (response.status == 200 && result && (result.length || (result.data && result.data.length))) {
                        var listOptionValue = Array.isArray(result) ? result : (Array.isArray(result.data) ? result.data : result.data.list);
                        if (listOptionValue && listOptionValue.length && (listOptionValue[0].constructor === String || listOptionValue[0].constructor === Number)) {
                            listOptionValue = listOptionValue.map(function (item, index) {
                                return { value: item, display: item };
                            })
                        }
                        that.$set(item, "listOption", listOptionValue)
                        if (that.item.defaultValue != null) {
                            if (this.item.defaultValue.constructor == Number && that.item.value) {
                                that.$set(that, "item_value", listOptionValue[that.item.defaultValue >= 0 ? that.item.defaultValue : (listOptionValue.length + that.item.defaultValue)][that.item.value])
                            } else {
                                that.$set(that, "item_value", that.item.defaultValue)
                            }
                        } else if (that.form && item.prop && that.form[item.prop]) {
                            that.$set(that, "item_value", that.form[item.prop])
                        }
                    }
                    that.$set(that, "loading", false)
                }, function (error) {
                    this.$message(error.statusText || " 未知错误!");
                    that.$set(that, "loading", false)
                });
            }
        },
        //设置默认值
        setDefaultValue() {
            var that = this;
            if (that.item.type && that.item.defaultValue) {
                switch (this.item.type) {
                    //下拉选择
                    case 'select':
                        if (!this.item.code) {
                            if (!this.item.code && (this.item.defaultValue.constructor == Number || this.item.defaultValue.constructor == String)) {
                                this.visibleChange(true, this.item);
                            }
                        }
                        break;
                    //年月
                    case 'month':
                        var date = new Date();
                        switch (that.item.defaultValue) {
                            case "new Date()":
                            case "curr month()":
                                date = new Date(date.setDate(1));
                                break;
                            case "prev month()":
                                date = new Date(new Date(date.setMonth(date.getMonth() - 1)).setDate(1));
                                break;
                        }
                        that.$set(that, "item_value", date);
                        break;
                    //日期
                    case 'date':
                        var date = new Date();
                        switch (that.item.defaultValue) {
                            case "prev Date()":
                            case "prev date()":
                                date = new Date(date.setDate(date.getDate() - 1));
                                break;
                        }
                        that.$set(that, "item_value", date);
                        break;
                    case 'daterange':
                        var date = new Date();
                        switch (that.item.defaultValue) {
                            case "new Date()":
                                date = [new Date(), new Date()];
                                break;
                            case "curr day()":
                                date = [new Date(date.setDate(date.getDate() - date.getDay() + 1)), new Date(date.setDate(date.getDate() - date.getDay() + 7))];
                                break;
                            case "curr month()":
                                date = [new Date(date.setDate(1)), new Date(date.setMonth(date.getMonth() + 1) - (24 * 60 * 60 * 1000))];
                                break;
                            case "prev day()":
                                date = [new Date(date.setDate(date.getDate() - date.getDay() + 1 - 7)), new Date(date.setDate(date.getDate() - date.getDay() + 7))];
                                break;
                            case "prev month()":
                                date = [new Date(new Date(date.setMonth(date.getMonth() - 1)).setDate(1)), new Date(new Date(date.setMonth(date.getMonth() + 1)).setDate(1) - (24 * 60 * 60 * 1000))];
                                break;
                            default:
                                date = that.item.defaultValue;
                                break;
                        }
                        that.$set(that, "item_value", date);
                        break;
                    case 'input':
                    case 'textarea':
                        that.$set(that, "item_value", that.item.defaultValue);
                        break;
                }
            }
        },
        //弹出窗
        showDialog(title, form, code) {
        },
        //设置值
        setArrayValue: function (value) {
            var that = this;
            Vue.set(that, 'item_value', []);
            that.item_value.push(value);
        },
        //上传文件
        upLoad() {
            Vue.set(this.$root, "loading", true);
            this.$refs.upload.submit();
        },
        //清除文件
        clearFiles() {
            this.$refs.upload.clearFiles()
            this.$set(this, "item_value", {})
        },
        //添加文件事件
        onFileChange(file, listFile) {
            if (file.status == "ready") {
                var that = this
                if (this.item.accept.includes(file.name.substr(file.name.lastIndexOf(".")))) {
                    if (listFile.length > 1) {
                        listFile.splice(0, 1)
                    }
                    that.$set(that, "item_value", file)
                } else {
                    listFile.splice(listFile.length - 1, 1)
                    that.$message.error('上传文件只能是' + that.item.accept + '格式!')
                }
            }
        },
        //文件上传成功
        onSuccess(response, file, listFile) {
            var that = this;
            if (response.result) {
                listFile.splice(listFile.length - 1, 1)
                that.$emit("import", true, file)
                that.$nextTick(function () {
                    that.$set(that, "item_value", {})
                })
            } else {
                file.status = "ready"
                that.loading = false
                that.$emit("import", false, file, response.message || "上传文件失败!")
            }
            Vue.set(this.$root, "loading", false);
        },
        //文件上传失败
        onError(err, file, listFile) {
            file.status = "ready"
            this.loading = false
            this.$emit("import", false, file, err)
            Vue.set(this.$root, "loading", false);
        },
    },
    template: '#elFormControl'
});