﻿using Bailun.DC.SyncShopifyFee.Models;
using Dapper;
using Microsoft.Extensions.Hosting;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace Bailun.DC.SyncShopifyFee
{

    public class Services : BackgroundService
    {
        IDictionary<string, string> dicWebsiteUrl = new Dictionary<string, string> {
          {"scrm",  "http://scrm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog" }, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"au", "http://au.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"au2", "http://au2.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"de", "http://de.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"fr", "http://fr.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"my", "http://my.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"td", "http://td.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"uk", "http://uk.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100 
          {"us", "http://us.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"us2", "http://us2.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"us3", "http://us3.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
          {"us4", "http://us4.btm.bailuntec.com/ScrmApi/api/ApiGetAdFeeLog"}, //?btime=2021-10-01&etime=2021-10-03&page=1&rows=100
        };

        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            //每60分钟执行一次任务
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(60));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                Console.WriteLine("开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                Init();
                Console.WriteLine("任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }


        public Services()
        {
            Dapper.SimpleCRUD.SetDialect(SimpleCRUD.Dialect.MySQL);
        }

        public void Init(DateTime? btime = null, DateTime? etime = null)
        {
            foreach (KeyValuePair<string, string> websiteUrl in dicWebsiteUrl)
            {
                var page = 1;
                var pagesize = 1000;
                var count = 0;

                if (!btime.HasValue)
                {
                    btime = this.GetBtime(websiteUrl.Key);
                }
                if (!etime.HasValue)
                {
                    etime = DateTime.Today.AddDays(1);
                }

                while (page == 1 || (page > 1 && count > 0))
                {
                    try
                    {
                        var result = Common.HttpHelper.NetHelper.Request($"{websiteUrl.Value}?btime={btime.Value.ToString("yyyy-MM-dd HH:00:00")}&etime={etime.Value.ToString("yyyy-MM-dd")}&page={page}&rows={pagesize}");
                        if (!string.IsNullOrEmpty(result))
                        {
                            var json = JsonConvert.DeserializeObject<response_result>(result);
                            count = json.data.Count;
                            if (json.success && count > 0)
                            {
                                //保存数据
                                Save(websiteUrl.Key, json.data);
                            }
                            page++;
                        }
                    }
                    catch (Exception ex)
                    {
                        Console.WriteLine(ex.Message);
                        Thread.Sleep(60 * 1000);
                    }
                }
            }
        }

        private void Save(string website, IList<response_shopify_fee> list)
        {
            int updateCount = 0;
            int insertCount = 0;
            using (var db = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }
                foreach (var item in list)
                {
                    var m = JsonConvert.DeserializeObject<dc_base_finance_shopify_fee>(JsonConvert.SerializeObject(item));
                    m.gmt_modified = DateTime.Now;
                    m.website = website;
                    int count = db.Execute("update dc_base_finance_shopify_fee set website = @website, ad_id = @ad_id, ts = @ts, bdate = @bdate, edate = @edate, fee = @fee, account_currency = @account_currency, cny_exchange_rate = @cny_exchange_rate,gmt_modified = @gmt_modified where data_id=@data_id and website=@website", m);
                    if (count == 0)
                    {
                        m.gmt_create = DateTime.Now;
                        db.Insert(m);
                        insertCount++;
                    }
                    else
                    {
                        updateCount++;
                    }
                }
                Console.WriteLine($"同步{website}shopify广告费新增{insertCount}条数据,更新{updateCount}条数据");
            }
        }

        private DateTime GetBtime(string website)
        {
            DateTime btime = DateTime.Now.AddHours(-2);
            using (var db = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }
                string sql = "select DATE_FORMAT(max(ts),'%Y-%m-%d %H:00:00') from dc_base_finance_shopify_fee where website = @website";
                btime = db.QueryFirstOrDefault<DateTime?>(sql, new { website = website }) ?? DateTime.Now.AddHours(-2);
                Console.WriteLine($"同步{website}的shopify广告费开始时间为{ btime.ToString("yyyy-MM-dd HH:mm:ss")}");
            }

            return btime;
        }
    }
}
