﻿using Bailun.DC.SyncPickBillTime.Models;
using Dapper;
using Microsoft.Extensions.Hosting;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace Bailun.DC.SyncPickBillTime
{

    public class Services : BackgroundService
    {
#if DEBUG
        string url = "http://wms.bailuntec.com/api/services/app/LogisticsReconciliationService/GetBaseDataList";
#else
        string url = "http://wms-api.owms:5001/api/services/app/LogisticsReconciliationService/GetBaseDataList";
#endif

        private Timer _timer;

        public static bool IsWork = false;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            //每5分钟执行一次任务
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(5));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            if (!IsWork)
            {
                Console.WriteLine($"开始启动:{DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                IsWork = true;
                try
                {
                    Init();
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex?.InnerException?.Message ?? ex.Message);
                }
                Console.WriteLine($"任务运行完成:{ DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss")}");
                IsWork = false;
            }
        }

        public Services()
        {
            Dapper.SimpleCRUD.SetDialect(SimpleCRUD.Dialect.MySQL);
        }

        public void Init()
        {
            using (var db = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (db.State == System.Data.ConnectionState.Closed)
                {
                    db.Open();
                }
                string sql = $"select * from dc_base_oms_pick_variances where bill_time <= @bill_time and bill_cost <> @bill_cost";
                IList<dc_base_oms_pick_variances> list = db.Query<dc_base_oms_pick_variances>(sql, new { bill_time = DateTime.Parse("1991-01-01 00:00:00"), bill_cost = 0 }).ToList();
                if (list?.Count > 0)
                {
                    Console.WriteLine($"需要同步{list.Count}条数据");
                    RequestDto request = new RequestDto
                    {
                        pageCount = 1000,
                        pageIndex = 1,
                        allocatecargoOrderCode = string.Join(",", list.Select(l => l.pick_order_id)),
                        diffStateTypes = new int[] { 1, 2 }
                    };
                    ResponseDto response = default(ResponseDto);
                    while (request.pageIndex == 1 || (response != null && response.result != null && (response.result.totalPages > response.result.pageIndex)))
                    {
                        string data = JsonConvert.SerializeObject(request);
                        var result = Common.HttpHelper.NetHelper.HttpPostJson(url, data);
                        request.pageIndex++;
                        if (!string.IsNullOrEmpty(result))
                        {
                            response = JsonConvert.DeserializeObject<ResponseDto>(result);
                            if (request.pageIndex == 1)
                            {
                                Console.WriteLine($"总共同步{response?.result?.total ?? 0}条数据");
                            }
                            if (response != null && response.success && response.result?.result?.Count > 0)
                            {
                                //保存数据
                                Save(response.result.result);
                                Console.WriteLine($"已同步{((response.result.pageIndex - 1) * request.pageCount) + response.result.result.Count}条数据");
                            }
                        }
                    }

                }
            }
        }
        private void Save(IList<PickBillDto> list)
        {
            if (list?.Count > 0)
            {
                dc_base_oms_pick_variances[] listEngity = list.Select(l => new dc_base_oms_pick_variances() { pick_order_id = l.allocatecargoOrderCode, bill_time = l.merchantReconciliationTime ?? DateTime.Parse("1991-01-01 00:00:00"), gmt_modified = DateTime.Now }).ToArray();

                using (var db = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
                {
                    if (db.State == System.Data.ConnectionState.Closed)
                    {
                        db.Open();
                    }
                    int count = db.Execute("update dc_base_oms_pick_variances set bill_time = @bill_time, gmt_modified = @gmt_modified where pick_order_id=@pick_order_id", listEngity);
                }
            }
        }
    }
}
