﻿using Bailun.DC.Models.Stock;
using Bailun.DC.Services;
using Bailun.DC.SyncMonthStockWeighting.Model;
using Microsoft.Extensions.Hosting;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using static Bailun.DC.Common.HttpHelper;

namespace Bailun.DC.SyncMonthStockWeighting
{
    public class SyncWmsStockFlowServices : BackgroundService
    {
        private Timer _timer;
        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));

            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            var now = DateTime.Now;
            if (now.Day == 1 && now.Hour == 1 && now.Minute == 1)
            {
                SynchWmsData();
            }
        }

        private void SynchWmsData()
        {
            try
            {
                Console.WriteLine($"SynchWmsData--{DateTime.Now}");
                string url = "http://api.wms.bailuntec.com/api/services/app/ProductStockFlowService/GetProductStockFlowPages";
                var requestData = new WMSRequestDto
                {
                    Data = new ProductStockFlowPagesInputDto { OrderCreationTimes = new string[] { "2021-06-30", DateTime.Now.Date.ToString() }, Page = new Pagination { Rows = 50 } }
                };
                var inventoryServices = new InventoryServices();
                for (int i = 1; i < 1000000; i++)
                {
                    requestData.Data.Page.Page = i;
                    var str = NetHelper.HttpPostJson(url, Newtonsoft.Json.JsonConvert.SerializeObject(requestData));
                    if (string.IsNullOrWhiteSpace(str)) break;
                    var resopnse = Newtonsoft.Json.JsonConvert.DeserializeObject<WMSDataResponseDto>(str);
                    if (resopnse == null || resopnse.Data == null || resopnse.Data.Items.Count <= 0) return;
                    foreach (var item in resopnse.Data.Items)
                    {
                        var insertModel = new dc_base_wms_stock_flow(item);
                        var isSuccess = inventoryServices.InsertWmsStockFlow(insertModel);
                        if (!isSuccess) break;
                        Console.WriteLine($"{item.SysSerialNumber}--{DateTime.Now}");
                    }
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }
    }
}
