﻿using Bailun.DC.Common;
using Bailun.DC.Models.Report;
using Bailun.DC.Models.Voucher;
using Dapper;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Http;
using System.Text;
using System.Threading.Tasks;

namespace Bailun.DC.Services
{
    public class VoucherService
    {
        public List<VoucherTemplateEntity> GetVoucherListNew(DateTime month, string platform)
        {
            var end = month.AddMonths(1).Date;
            var sql = $@"select t2.datacenter_col as TitleName,t1.website as Site,sum(amountval) as Amount from order_fee_value_amazon t1
join order_fee_config t2 on t1.order_fee_config_id = t2.id
where datacenter_col!= '' and amountval!= 0
and t1.datatime >= @timeStrat
and t1.datatime < @timeEnd
group by t2.datacenter_col,t1.website";
            var para = new DynamicParameters();
            para.Add("timeStrat", month.Date);
            para.Add("timeEnd", end);
            var data = SimpleCRUD.Query<QueryDtos>(sql, para, GlobalConfig.ConnectionString_DW);
            //var TitleList = data.Select(x => x.TitleName).ToList();
            //var SiteList = data.Select(x => x.Site).ToList();
            var tempList = new List<VoucherTemplateEntity>();
            var voucherData = GetVoucherTemplate(platform);
            var rateData = GetFundExchangRate(month.ToString("yyyy-MM"));
            var voucherSite = voucherData.Select(x => x.站点).Distinct().ToList();
            var time = Convert.ToDateTime(month);
            var times = new DateTime(time.Year, time.Month, 01);
            foreach (var voucherSites in voucherSite)
            {
                var siteList = voucherData.Where(x => x.站点 == voucherSites);
                foreach (var siteLists in siteList)
                {
                    var temp = new VoucherTemplateEntity();
                    var rate = rateData.FirstOrDefault(x => x.currency == siteLists.币种名称) ?? new mFundExchangRate { exchange_rate = 1 };
                    var datas = data.Where(x => x.Site.ToUpper() == voucherSites.ToUpper());
                    temp = GetVoucherInfo(siteLists, rate.exchange_rate.Value, datas);
                    temp.会计年 = times.Year.ToString();
                    temp.会计期间 = times.Month.ToString();
                    var tt = times.AddDays(1 - times.Day).AddMonths(1).AddDays(-1);
                    temp.制单日期 = tt.ToString("yyyy.MM.dd");
                    temp.汇率 = rate.exchange_rate.ToString();
                    tempList.Add(temp);
                }
            }
            return tempList;
        }
        public VoucherTemplateEntity GetVoucherInfo(VoucherTemplateEntity voucherTemplate, decimal rate, IEnumerable<QueryDtos> data)
        {
            var amountData = new QueryDtos();
            switch (voucherTemplate.取值列)
            {
                case "FBA":
                    amountData = data.FirstOrDefault(x => x.TitleName == "佣金及平台费-亚马逊FBA") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币借方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.借方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                case "SELLER":
                    amountData = data.FirstOrDefault(x => x.TitleName == "佣金及平台费-亚马逊非FBA") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币借方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.借方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                case "广告费":
                    amountData = data.FirstOrDefault(x => x.TitleName == "广告及宣传费") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币借方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.借方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                case "物流费":
                    amountData = data.FirstOrDefault(x => x.TitleName == "尾程物流费-平台") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币借方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.借方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                case "仓储费":
                    amountData = data.FirstOrDefault(x => x.TitleName == "仓储费-平台") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币借方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.借方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                case "货运费":
                    amountData = data.FirstOrDefault(x => x.TitleName == "头程运输-平台") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币借方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.借方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                case "销售费用":
                    var amount = data.Where(m => m.TitleName != "营业外收入").Sum(x => x.Amount);
                    if (amount < 0)
                    {
                        amount = Math.Abs(amount);
                    }
                    voucherTemplate.原币贷方 = Math.Round(amount, 2).ToString();
                    voucherTemplate.贷方金额 = Math.Round((amount * rate), 2).ToString();
                    return voucherTemplate;
                case "应收":
                    amountData = data.FirstOrDefault(x => x.TitleName == "营业外收入") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币借方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.借方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                case "主营":
                    amountData = data.FirstOrDefault(x => x.TitleName == "营业外收入") ?? new QueryDtos { Amount = 0 };
                    if (amountData.Amount < 0)
                    {
                        amountData.Amount = Math.Abs(amountData.Amount);
                    }
                    voucherTemplate.原币贷方 = Math.Round(amountData.Amount, 2).ToString();
                    voucherTemplate.贷方金额 = Math.Round((amountData.Amount * rate), 2).ToString();
                    return voucherTemplate;
                default:
                    return voucherTemplate;
            }
        }
        /// <summary>
        /// 获取汇率
        /// </summary>
        /// <param name="month"></param>
        /// <returns></returns>
        public List<mFundExchangRate> GetFundExchangRate(string month)
        {
            var data = new List<mFundExchangRate>();
            var url = $"http://fund.bailuntec.com/api/GetExchangeRateNew?month={month}";
            using(var http = new HttpClient())
            {
                var resultStr = http.GetStringAsync(url).GetAwaiter().GetResult();
                data = JsonConvert.DeserializeObject<List<mFundExchangRate>>(resultStr);
            }
            return data;
        }
        /// <summary>
        /// 获取凭证模板
        /// </summary>
        /// <param name="platform"></param>
        /// <returns></returns>
        public List<VoucherTemplateEntity> GetVoucherTemplate(string platform)
        {
            var data = new List<VoucherTemplateEntity>();
            var url = $"http://fund.bailuntec.com/api/GetVoucherTemplate?platform={platform}";
            using (var http = new HttpClient())
            {
                var resultStr = http.GetStringAsync(url).GetAwaiter().GetResult();
                data = JsonConvert.DeserializeObject<List<VoucherTemplateEntity>>(resultStr);
            }
            return data;
        }
        #region 作废
        public string GetVoucherList(DateTime month, string platform)
        {
            var strat = new DateTime(month.Year, month.Month, 01).Date;
            var end = strat.AddMonths(1).Date;
            var sql = @"select s1.website,s1.jsondata,s1.datatime from flowing_sales s1 where s1.platform = @platform
and s1.datatime >= @timeStrat 
and s1.datatime < @timeEnd ";
            var para = new DynamicParameters();
            para.Add("platform", platform);
            para.Add("timeStrat", strat);
            para.Add("timeEnd", end);
            System.Diagnostics.Stopwatch watch = new System.Diagnostics.Stopwatch();
            watch.Reset();
            watch.Start();
            var data = SimpleCRUD.Query<(string site, string jsondata, DateTime date)>(sql, para, GlobalConfig.ConnectionString_DW);
            watch.Stop();
            Console.WriteLine(watch.ElapsedMilliseconds);
            var siteList = data.Select(x => x.site).Distinct().ToList();
            var listModel = new List<VoucherData>();
            int taskcount = 2;
            int step = 0;
            object asyncObj = new object();
            var taskList = new List<Task>();
            for (int i = 0; i < taskcount; i++)
            {
                taskList.Add(Task.Factory.StartNew((index) =>
                {
                    do
                    {
                        string mk = null;
                        lock (asyncObj)
                        {
                            mk = siteList.Skip(step++).Take(1).FirstOrDefault();
                        }
                        var mkdata = data.Where(x => x.site == mk).ToList();

                        var model = new VoucherData();
                        var list = new List<SiteTitleEntity>();
                        //mkdata.ForEach((da) =>
                        //{
                        //    var dic = JsonConvert.DeserializeObject<Dictionary<string, string>>(da.jsondata);
                        //    list.Add(JsonConvert.DeserializeObject<SiteTitleEntity>(CharacterReplace(dic)));
                        //});
                        mkdata.Select(x =>
                        {
                            var dic = JsonConvert.DeserializeObject<Dictionary<string, string>>(x.jsondata);
                            list.Add(JsonConvert.DeserializeObject<SiteTitleEntity>(CharacterReplace(dic)));
                            return x;
                        });
                        mk = mk.ToUpper();
                        switch (mk)
                        {
                            case "US":
                                listModel.Add(GetUsNew(list, mk));
                                break;
                            case "AU":
                                listModel.Add(GetAuNew(list, mk));
                                break;
                            case "UK":
                                listModel.Add(GetUkNew(list, mk));
                                break;
                            case "CA":
                                listModel.Add(GetCaNew(list, mk));
                                break;
                            case "ES":
                                listModel.Add(GetEsNew(list, mk));
                                break;
                            case "DE":
                                listModel.Add(GetDeNew(list, mk));
                                break;
                            case "IT":
                                listModel.Add(GetItNew(list, mk));
                                break;
                            case "FR":
                                listModel.Add(GetFrNew(list, mk));
                                break;
                            case "NL":
                                listModel.Add(GetNlNew(list, mk));
                                break;
                            case "JP":
                                listModel.Add(GetJpNew(list, mk));
                                break;
                            case "MX":
                                listModel.Add(GetMxNew(list, mk));
                                break;
                            case "SE":
                                listModel.Add(GetSeNew(list, mk));
                                break;
                        }
                    } while (step < siteList.Count());
                }, i));
            }
            Task.WaitAll(taskList.ToArray());



            RedisHelper.Add("SiteTest", siteList, new TimeSpan(1, 0, 0, 0));
            //var redis = RedisHelper.GetList<string>("SiteTest");
            return "";

        }
        /// <summary>
        /// 字符替换
        /// </summary>
        /// <param name="dic"></param>
        /// <returns></returns>
        public string CharacterReplace(Dictionary<string, string> dic)
        {
            var newdic = new Dictionary<string, string>();
            foreach (var dics in dic)
            {
                if (dics.Key.Contains("-"))
                {
                    newdic.Add(dics.Key.Replace("-", "_"), dics.Value);
                    continue;
                }
                else if (dics.Key.Contains("'"))
                {
                    newdic.Add(dics.Key.Replace("'", "_"), dics.Value);
                    continue;
                }
                else if (dics.Key.Contains("’"))
                {
                    newdic.Add(dics.Key.Replace("’", "_"), dics.Value);
                    continue;
                }
                newdic.Add(dics.Key.Replace(" ", "_"), dics.Value);
            }
            return JsonConvert.SerializeObject(newdic);
        }


        #region 计算各站点数据
        public static VoucherData GetUsNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.FirstJourneyFba = list.Where(x => x.type == "Service Fee"
            && (x.description == "FBA International Freight Duties and Taxes Charge"
            || x.description == "FBA International Freight Shipping Charge"
            || x.description == "FBA International Freight Shipping Charge Adjustments")).Sum(x => FilterDigitalNew(x.other, market));
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.fba_fees, market));

            model.yongjinAmazon = list.Where(x => x.fulfillment == "Amazon")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));

            model.yongjinSeller = list.Where(x => x.fulfillment == "Seller")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));
            model.yongjinSeller2 = list.Sum(x => FilterDigitalNew(x.selling_fees, market)) - model.yongjinSeller - model.yongjinAmazon;
            model.yongjinSeller3 = list.Where(x => x.type == "Lightning Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.yongjinSeller4 = list.Where(x => x.type == "")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.yongjinSeller5 = list.Where(x => x.type == "Shipping Services")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3
                + model.yongjinSeller4
                + model.yongjinSeller5;


            model.guanggaoDeal = list.Where(x => x.type == "Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.guanggaoService = list.Where(x => x.type == "Service Fee" && x.description == "Cost of Advertising")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.guanggaoService_Sub = list.Where(x => x.type == "Service Fee" && x.description == "Subscription")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.guanggaoTotal = model.guanggaoDeal
                + model.guanggaoService
                + model.guanggaoService_Sub;

            model.yingyewaiAdju = list.Where(x => x.type == "Adjustment")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiRefund = list.Where(x => x.type == "Refund")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiTotal = model.yingyewaiAdju + model.yingyewaiRefund;

            model.fbacangchu = list.Where(x => x.type == "FBA Inventory Fee")
                .Sum(x => FilterDigitalNew(x.other, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }

        public static VoucherData GetUkNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.FirstJourneyFba = list.Where(x => x.type == "Service Fee"
            && (x.description == "FBA International Freight Duties and Taxes Charge"
            || x.description == "FBA International Freight Shipping Charge"
            || x.description == "FBA International Freight Shipping Charge Adjustments")).Sum(x => FilterDigitalNew(x.other, market));

            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.fba_fees, market));

            model.yongjinAmazon = list.Where(x => x.fulfilment == "Amazon")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));


            model.guanggaoDeal = list.Where(x => x.type == "Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.guanggaoService = list.Where(x => x.type == "Service Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.guanggaoService_Sub = list.Where(x => x.type == "Service Fee"
            && (x.description == "Subscription"
            || x.description == "Cost of Advertising"))
                .Sum(x => FilterDigitalNew(x.other, market));
            model.guanggaoTotal = model.guanggaoDeal
                + model.guanggaoService
                + model.guanggaoService_Sub;

            model.yongjinSeller = list.Where(x => x.fulfilment == "Seller")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));
            model.yongjinSeller2 = list.Sum(x => FilterDigitalNew(x.selling_fees, market)) - model.yongjinSeller - model.yongjinAmazon;
            model.yongjinSeller3 = list.Where(x => x.type == "Lightning Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.yongjinSeller4 = list.Sum(x => FilterDigitalNew(x.other_transaction_fees, market))
                - model.guanggaoDeal
                - model.yongjinSeller3
                - model.guanggaoService;
            model.yongjinSeller5 = list.Where(x => x.type == "Shipping Services")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3
                + model.yongjinSeller4
                + model.yongjinSeller5;



            model.yingyewaiAdju = list.Where(x => x.type == "Adjustment")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiRefund = list.Where(x => x.type == "Refund")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiTotal = model.yingyewaiAdju + model.yingyewaiRefund;

            model.fbacangchu = list.Where(x => x.type == "FBA Inventory Fee")
                .Sum(x => FilterDigitalNew(x.other, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }
        public static VoucherData GetCaNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.FirstJourneyFba = list.Where(x => x.type == "Service Fee"
            && (x.description == "FBA International Freight Duties and Taxes Charge"
            || x.description == "FBA International Freight Shipping Charge"
            || x.description == "FBA International Freight Shipping Charge Adjustments")).Sum(x => FilterDigitalNew(x.other, market));

            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.fba_fees, market));

            model.guanggaoDeal = list.Where(x => x.type == "Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.guanggaoService = list.Where(x => x.type == "Service Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            //model.guanggaoService_Sub = list.Where(x => x.type == "Service Fee"
            //&& (x.description == "Subscription"
            //|| x.description == "Cost of Advertising"))
            //    .Sum(x => FilterDigitalNew(x.other, market));
            model.guanggaoTotal = model.guanggaoDeal
                + model.guanggaoService;

            model.yongjinAmazon = list.Where(x => x.fulfillment == "Amazon")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));

            model.yongjinSeller = list.Where(x => x.fulfillment == "Seller")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));
            model.yongjinSeller2 = list.Where(x => x.fulfillment == "")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));
            model.yongjinSeller3 = list.Where(x => x.type == "Lightning Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.yongjinSeller4 = list.Sum(x => FilterDigitalNew(x.other_transaction_fees, market))
                - model.guanggaoDeal
                - model.yongjinSeller3
                - model.guanggaoService;
            model.yongjinSeller5 = list.Where(x => x.type == "Shipping Services")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3
                + model.yongjinSeller4
                + model.yongjinSeller5;



            model.yingyewaiAdju = list.Where(x => x.type == "Adjustment")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiRefund = list.Where(x => x.type == "Refund")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiTotal = model.yingyewaiAdju + model.yingyewaiRefund;

            model.fbacangchu = list.Where(x => x.type == "FBA Inventory Fee")
                .Sum(x => FilterDigitalNew(x.other, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }

        public static VoucherData GetAuNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.FirstJourneyFba = list.Where(x => x.type == "Service Fee"
            && (x.description == "FBA International Freight Duties and Taxes Charge"
            || x.description == "FBA International Freight Shipping Charge"
            || x.description == "FBA International Freight Shipping Charge Adjustments")).Sum(x => FilterDigitalNew(x.other, market));

            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.fba_fees, market));

            model.guanggaoDeal = list.Where(x => x.type == "Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.guanggaoService = list.Where(x => x.type == "Service Fee"
            && x.description == "Cost of Advertising")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.guanggaoService_Sub = list.Where(x => x.type == "Service Fee"
            && x.description == "Subscription")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.guanggaoTotal = model.guanggaoDeal
                + model.guanggaoService;

            model.yongjinAmazon = list.Where(x => x.fulfillment == "Amazon")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));

            model.yongjinSeller = list.Where(x => x.fulfillment == "Seller")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));

            model.yongjinSeller2 = list.Where(x => x.fulfillment == "")
                .Sum(x => FilterDigitalNew(x.selling_fees, market));

            model.yongjinSeller3 = list.Where(x => x.type == "Lightning Deal Fee")
                .Sum(x => FilterDigitalNew(x.other_transaction_fees, market));
            model.yongjinSeller4 = list.Sum(x => FilterDigitalNew(x.other_transaction_fees, market))
                - model.guanggaoDeal
                - model.yongjinSeller3
                - model.guanggaoService;
            model.yongjinSeller5 = list.Where(x => x.type == "Shipping Services")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3
                + model.yongjinSeller4
                + model.yongjinSeller5;



            model.yingyewaiAdju = list.Where(x => x.type == "Adjustment")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiRefund = list.Where(x => x.type == "Refund")
                .Sum(x => FilterDigitalNew(x.other, market));
            model.yingyewaiTotal = model.yingyewaiAdju + model.yingyewaiRefund;

            model.fbacangchu = list.Where(x => x.type == "FBA Inventory Fee")
                .Sum(x => FilterDigitalNew(x.other, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }
        public static VoucherData GetEsNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.tarifas_de_Logística_de_Amazon, market));
            model.yongjinAmazon = list.Where(x => x.gestión_logística == "Amazon").Sum(x => FilterDigitalNew(x.tarifas_de_venta, market));
            model.yongjinSeller = list.Where(x => x.gestión_logística == "Vendedor").Sum(x => FilterDigitalNew(x.tarifas_de_venta, market));

            model.yongjinSeller2 = list.Sum(x => FilterDigitalNew(x.tarifas_de_venta, market)) - model.yongjinAmazon - model.yongjinSeller;
            model.yongjinSeller3 = list.Where(x => x.tipo == "Tarifa de Oferta flash")
                .Sum(x => FilterDigitalNew(x.tarifas_de_otras_transacciones, market));
            model.yongjinSeller4 = list.Where(x => x.tipo == "")
                .Sum(x => FilterDigitalNew(x.tarifas_de_otras_transacciones, market));
            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3
                + model.yongjinSeller4;
            model.guanggaoTotal = list.Where(x => x.tipo == "Tarifa de prestación de servicio")
                .Sum(x => FilterDigitalNew(x.tarifas_de_otras_transacciones, market));
            model.fbacangchu = list.Where(x => x.tipo == "Tarifas de inventario de Logística de Amazon")
                .Sum(x => FilterDigitalNew(x.otro, market));
            model.yingyewaiTotal = list.Where(x => x.tipo == "Ajuste")
                .Sum(x => FilterDigitalNew(x.otro, market))
                + list.Where(x => x.tipo == "Reembolso")
                .Sum(x => FilterDigitalNew(x.otro, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }
        public static VoucherData GetDeNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.Gebühren_zu_Versand_durch_Amazon, market));
            model.yongjinAmazon = list.Where(x => x.Versand == "Amazon").Sum(x => FilterDigitalNew(x.Verkaufsgebühren, market));
            model.yongjinSeller = list.Where(x => x.Versand == "Verkäufer").Sum(x => FilterDigitalNew(x.Verkaufsgebühren, market));

            model.guanggaoTotal = list.Where(x => x.Typ == "Servicegebühr")
                .Sum(x => FilterDigitalNew(x.Gesamt, market));

            model.yongjinSeller2 = list.Sum(x => FilterDigitalNew(x.Verkaufsgebühren, market)) - model.yongjinAmazon - model.yongjinSeller;
            model.yongjinSeller3 = list.Where(x => x.Typ == "Blitzangebotsgebühr")
                .Sum(x => FilterDigitalNew(x.Gesamt, market));
            model.yongjinSeller4 = list.Sum(x => FilterDigitalNew(x.Andere_Transaktionsgebühren, market))
                - model.guanggaoTotal
                - model.yongjinSeller2;
            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3
                + model.yongjinSeller4;
            model.fbacangchu = list.Where(x => x.Typ == "Versand durch Amazon Lagergebühr")
                .Sum(x => FilterDigitalNew(x.Andere, market));
            model.yingyewaiTotal = list.Where(x => x.Typ == "Anpassung")
                .Sum(x => FilterDigitalNew(x.Andere, market))
                + list.Where(x => x.Typ == "Erstattung")
                .Sum(x => FilterDigitalNew(x.Andere, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }
        public static VoucherData GetItNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.Costi_del_servizio_Logistica_di_Amazon, market));
            model.yongjinAmazon = list.Where(x => x.Gestione == "Amazon").Sum(x => FilterDigitalNew(x.Commissioni_di_vendita, market));
            model.yongjinSeller = list.Where(x => x.Gestione == "Venditore").Sum(x => FilterDigitalNew(x.Commissioni_di_vendita, market));

            model.guanggaoTotal = list.Where(x => x.Tipo == "Commissione di servizio")
                .Sum(x => FilterDigitalNew(x.Altri_costi_relativi_alle_transazioni, market));

            model.yongjinSeller2 = list.Sum(x => FilterDigitalNew(x.Commissioni_di_vendita, market)) - model.yongjinAmazon - model.yongjinSeller;
            model.yongjinSeller3 = list.Where(x => x.Tipo == "Tariffa dell’Offerta Lampo")
                .Sum(x => FilterDigitalNew(x.Altri_costi_relativi_alle_transazioni, market));

            model.yongjinSeller4 = list.Sum(x => FilterDigitalNew(x.Altri_costi_relativi_alle_transazioni, market))
                - model.guanggaoTotal
                - model.yongjinSeller2;
            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3
                + model.yongjinSeller4;
            model.fbacangchu = list.Where(x => x.Tipo == "Costo di stoccaggio Logistica di Amazon")
                .Sum(x => FilterDigitalNew(x.Altro, market));
            model.yingyewaiTotal = list.Where(x => x.Tipo == "Modifica")
                .Sum(x => FilterDigitalNew(x.Altro, market))
                + list.Where(x => x.Tipo == "Rimborso")
                .Sum(x => FilterDigitalNew(x.Altro, market))
                + list.Where(x => x.Tipo == "Saldo negativo")
                .Sum(x => FilterDigitalNew(x.Altro, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }
        public static VoucherData GetFrNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.Frais_Expédié_par_Amazon, market));
            model.yongjinAmazon = list.Where(x => x.traitement == "Amazon").Sum(x => FilterDigitalNew(x.frais_de_vente, market));
            model.yongjinSeller = list.Where(x => x.traitement == "Vendeur").Sum(x => FilterDigitalNew(x.frais_de_vente, market));

            model.guanggaoTotal = list.Where(x => x.type == "Frais de service")
                .Sum(x => FilterDigitalNew(x.autres_frais_de_transaction, market));

            model.yongjinSeller2 = list.Sum(x => FilterDigitalNew(x.frais_de_vente, market)) - model.yongjinAmazon - model.yongjinSeller;
            model.yongjinSeller3 = list.Sum(x => FilterDigitalNew(x.autres_frais_de_transaction, market))
                - model.guanggaoTotal;

            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2
                + model.yongjinSeller3;

            model.fbacangchu = list.Where(x => x.type == "Frais de stock Expédié par Amazon")
                .Sum(x => FilterDigitalNew(x.autre, market));

            model.yingyewaiTotal = list.Where(x => x.type == "Ajustement")
                .Sum(x => FilterDigitalNew(x.autre, market))
                + list.Where(x => x.type == "Remboursement")
                .Sum(x => FilterDigitalNew(x.autre, market))
                + list.Where(x => x.type == "Solde négatif")
                .Sum(x => FilterDigitalNew(x.autre, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu
                + model.FirstJourneyFba;
            model.Market = market;
            return model;
        }

        public static VoucherData GetSeNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.fba_avgifter, market));

            var fba = list.Where(x => x.leverans == "").Sum(x => FilterDigitalNew(x.försäljningsavgifter, market));
            model.yongjinAmazon = list.Where(x => x.leverans == "Amazon").Sum(x => FilterDigitalNew(x.försäljningsavgifter, market)) + fba;

            model.yongjinToTal = list.Sum(x => FilterDigitalNew(x.försäljningsavgifter, market)) - model.yongjinAmazon - fba;

            model.salseFee = model.TailCourseFba
                + model.yongjinToTal
                + model.yongjinAmazon;
            model.Market = market;
            return model;
        }
        public static VoucherData GetNlNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.fba_vergoedingen, market));
            model.yongjinAmazon = list.Where(x => x.fulfillment == "Amazon").Sum(x => FilterDigitalNew(x.verkoopkosten, market));
            model.yongjinSeller = list.Where(x => x.fulfillment == "Verkoper").Sum(x => FilterDigitalNew(x.verkoopkosten, market));

            model.guanggaoTotal = list.Where(x => x.type == "Frais de service")
                .Sum(x => FilterDigitalNew(x.autres_frais_de_transaction, market));

            model.yongjinSeller2 = list.Sum(x => FilterDigitalNew(x.verkoopkosten, market)) - model.yongjinAmazon - model.yongjinSeller;


            model.yongjinToTal = model.yongjinSeller
                + model.yongjinSeller2;

            model.yingyewaiTotal = list.Where(x => x.type == "Aanpassing")
                .Sum(x => FilterDigitalNew(x.overige, market));

            model.salseFee = model.yongjinAmazon
                + model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba;
            model.Market = market;
            return model;
        }
        public static VoucherData GetJpNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.FBA_手数料, market));
            model.yongjinSeller = list.Where(x => x.フルフィルメント == "出品者").Sum(x => FilterDigitalNew(x.frais_de_vente, market));

            model.guanggaoTotal = list.Where(x => x.トランザクションの種類 == "注文外料金")
                .Sum(x => FilterDigitalNew(x.その他, market));

            model.yongjinToTal = model.yongjinSeller;

            model.fbacangchu = list.Where(x => x.トランザクションの種類 == "FBA 在庫関連の手数料")
                .Sum(x => FilterDigitalNew(x.その他, market));


            model.salseFee = model.yongjinToTal
                + model.guanggaoTotal
                + model.TailCourseFba
                + model.fbacangchu;
            model.Market = market;
            return model;
        }
        public static VoucherData GetMxNew(List<SiteTitleEntity> list, string market)
        {
            var model = new VoucherData();
            model.TailCourseFba = list.Sum(x => FilterDigitalNew(x.tarifas_fba, market));
            model.yongjinAmazon = list.Where(x => x.cumplimiento == "Amazon").Sum(x => FilterDigitalNew(x.tarifas_de_venta, market));

            model.yongjinSeller = list.Sum(x => FilterDigitalNew(x.tarifas_de_venta, market)) - model.yongjinAmazon;

            model.yongjinToTal = model.yongjinSeller;

            model.salseFee = model.TailCourseFba
                + model.yongjinAmazon
                + model.yongjinToTal;
            model.Market = market;
            return model;
        }
        #endregion
        /// <summary>
        /// 处理各站点乱码数据
        /// </summary>
        /// <param name="str"></param>
        /// <param name="market"></param>
        /// <returns></returns>
        public static decimal FilterDigitalNew(string str, string market)
        {
            //无需处理
            if (market == "CA" || market == "MX" || market == "AU" || market == "JP")
            {
                return Convert.ToDecimal(str);
            }
            else if (market == "UK" || market == "US")
            {
                //存在-1,170.43格式
                if (str.Contains(",") && str.Contains("."))
                {
                    str = str.Replace(",", "");
                }
            }
            else if (market == "DE" || market == "FR" || market == "NL")
            {
                //替换“,”
                if (str.Contains(","))
                {
                    str = str.Replace(",", ".");
                }
            }
            else if (market == "ES")
            {
                //存在-1.349,62格式
                if (str.Contains(".") && str.Contains(","))
                {
                    str = str.Replace(".", "");
                    str = str.Replace(",", ".");
                }
                else
                {
                    str = str.Replace(",", ".");
                }
            }
            else if (market == "SE")
            {
                //存在−4 396,14格式
                if (str.Contains("−") || str.Contains(" "))
                {
                    var strs = str.ToString();
                    var space = strs.Replace(" ", "");
                    space = space.Replace("−", "-");
                    str = space.Replace(",", ".");
                }
                else
                {
                    str = str.Replace(",", ".");
                }
            }
            else if (market == "IT")
            {
                //存在-155.719,59格式
                if (str.Contains(".") && str.Contains(","))
                {
                    str = str.Replace(".", "");
                    str = str.Replace(",", ".");
                }
                else
                {
                    str = str.Replace(",", ".");
                }
            }
            return Convert.ToDecimal(str);
        }
        #endregion
    }
}
