﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Bailun.DC.Models.DataWareHouse;
using Bailun.DC.Common;
using Dapper;
using System.Linq;
using System.Data;
using Bailun.DC.Models.Component.DTO;

namespace Bailun.DC.Services.DataWareHouse
{
    public class PlatformOrderFeeServices
    {
        #region 配置保存

        //需要存的费用字段

        /// <summary>
        /// 保存需要解析的字段配置
        /// </summary>
        /// <param name="cols"></param>
        /// <returns></returns>
        public string SaveOrderFeeCol(List<order_fee_col> cols)
        {
            if (cols.Count == 0)
            {
                return "没有可保存的字段配置";
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                foreach (var item in cols)
                {
                    var m = cn.QueryFirstOrDefault<order_fee_col>($"select * from order_fee_col where platform='{item.platform}' and website='{item.website}'");

                    if (m == null)
                    {
                        cn.Insert(item);
                    }
                    else
                    {
                        m.cols = item.cols;
                        cn.Update(m);
                    }

                }

            }

            return "";
        }

        /// <summary>
        /// 保存平台+站点的不同费用类型的取值条件和会计科目
        /// </summary>
        /// <param name="configs"></param>
        /// <returns></returns>
        public string SaveOrderFeeConfig(List<order_fee_config> configs)
        {
            var listpw = configs.Select(a => new Tuple<string, string>(a.platform, a.website));
            listpw = listpw.Distinct();

            if (configs.Count == 0)
            {
                return "至少需要有一个配置。";
            }

            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                foreach (var item in listpw)
                {
                    cn.Execute($"update order_fee_config set delstatus=1 where platform='{item.Item1}' and website='{item.Item2}'");
                }

                foreach (var item in configs)
                {
                    cn.Insert(item);
                }

            }

            return "";
        }

        public string InsertOrderFeeConfig(List<order_fee_config> listconfigs)
        {
            try
            {
                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    foreach (var item in listconfigs)
                    {
                        cn.Insert(item);
                    }
                }

                return "";
            }
            catch (Exception ex)
            {
                return ex.Message;
            }
        }

        /// <summary>
        /// 获取费用解析财务流水配置
        /// </summary>
        /// <param name="datatype"></param>
        /// <returns></returns>
        public List<order_fee_config> ListOrderFeeConfig(int datatype)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                return cn.Query<order_fee_config>("select * from order_fee_config where datatype=" + datatype).ToList();

            }
        }

        /// <summary>
        /// 获取费用解析财务流水配置
        /// </summary>
        /// <param name="datatype"></param>
        /// <returns></returns>
        public List<order_fee_config> ListOrderFeeConfig()
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                return cn.Query<order_fee_config>("select * from order_fee_config").ToList();

            }
        }

        #endregion

        public List<order_fee_col> ListOrderFeeCol()
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                return cn.Query<order_fee_col>("select * from order_fee_col").ToList();

            }
        }

        /// <summary>
        /// 获取财务会计流水明细
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="orderno"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public List<order_fee_value_amazon> ListOrderFeeValue(int page, int pagesize, string platform, string website, DateTime? start, DateTime? end, string orderno, string month, ref int total, int? datatype, string datacenter_col)
        {
            var sql = $@"select t1.* from order_fee_value_amazon t1
                         join order_fee_config t2 on t1.order_fee_config_id=t2.id
                        ";
            var sqlparam = new DynamicParameters();

            if (!string.IsNullOrEmpty(datacenter_col))
            {
                sql += $" and t2.datacenter_col=@datacenter_col";
                sqlparam.Add("datacenter_col", datacenter_col);
            }

            sql += " where t1.amountval!=0 ";


            if (datatype.HasValue)
            {
                sql += " and t1.datatype=" + datatype.Value;
            }


            if (!string.IsNullOrEmpty(platform))
            {
                sql += " and t1.platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and t1.website=@website";
                sqlparam.Add("website", website);
            }

            //if(!string.IsNullOrEmpty(month))
            //{
            //    sql += " and t1.month=@month";
            //    sqlparam.Add("month", month);
            //}

            if (!string.IsNullOrEmpty(orderno))
            {
                sql += " and t1.orderno=@orderno";
                sqlparam.Add("orderno", orderno);
            }

            if (start.HasValue)
            {
                sql += $" and t1.datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }

            if (end.HasValue)
            {
                sql += $" and t1.datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += $" and t1.month=@month";
                sqlparam.Add("month", month);
            }



            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var list = new List<order_fee_value_amazon>();

                if (pagesize > 0)
                {
                    list = cn.Page<order_fee_value_amazon>(page, pagesize, sql, ref total, sqlparam).ToList();
                }
                else
                {
                    list = cn.Query<order_fee_value_amazon>(sql, sqlparam, null, true, 2 * 60).ToList();
                }

                var config = cn.Query<order_fee_config>($"select * from order_fee_config where id in ('{string.Join("','", list.Select(a => a.order_fee_config_id).Distinct().ToList())}')");
                foreach (var item in list)
                {
                    item.fee_config = config.Where(a => a.id == item.order_fee_config_id).FirstOrDefault();
                }

                return list;
            }
        }

        /// <summary>
        /// 获取财务会计流水明细汇总
        /// </summary>
        /// <param name="page"></param>
        /// <param name="pagesize"></param>
        /// <param name="platform"></param>
        /// <param name="website"></param>
        /// <param name="start"></param>
        /// <param name="end"></param>
        /// <param name="orderno"></param>
        /// <param name="total"></param>
        /// <returns></returns>
        public order_fee_value_amazon ListOrderFeeValueCount(string platform, string website, DateTime? start, DateTime? end, string orderno, string month, int? datatype, string datacenter_col)
        {
            var sql = $@"select sum(amountval) as amountval,sum(amountval_rmb) amountval_rmb from order_fee_value_amazon t1
                        join order_fee_config t2 on t1.order_fee_config_id=t2.id
                        ";
            var sqlparam = new DynamicParameters();

            if (!string.IsNullOrEmpty(datacenter_col))
            {
                sql += $" and t2.datacenter_col=@datacenter_col";
                sqlparam.Add("datacenter_col", datacenter_col);
            }

            sql += " where t1.amountval!=0 ";

            if (datatype.HasValue)
            {
                sql += " and t1.datatype=" + datatype.Value;
            }


            if (!string.IsNullOrEmpty(platform))
            {
                sql += " and t1.platform=@platform";
                sqlparam.Add("platform", platform);
            }

            if (!string.IsNullOrEmpty(website))
            {
                sql += " and t1.website=@website";
                sqlparam.Add("website", website);
            }

            //if(!string.IsNullOrEmpty(month))
            //{
            //    sql += " and t1.month=@month";
            //    sqlparam.Add("month", month);
            //}

            if (!string.IsNullOrEmpty(orderno))
            {
                sql += " and t1.orderno=@orderno";
                sqlparam.Add("orderno", orderno);
            }

            if (start.HasValue)
            {
                sql += $" and t1.datatime>='{start.Value.ToString("yyyy-MM-dd")}'";
            }

            if (end.HasValue)
            {
                sql += $" and t1.datatime<'{end.Value.AddDays(1).ToString("yyyy-MM-dd")}'";
            }

            if (!string.IsNullOrEmpty(month))
            {
                sql += $" and t1.month=@month";
                sqlparam.Add("month", month);
            }


            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                var obj = cn.QueryFirstOrDefault<order_fee_value_amazon>(sql, sqlparam);


                return obj;
            }
        }

        /// <summary>
        /// 保存财务会计流水数据
        /// </summary>
        /// <param name="list"></param>
        /// <returns></returns>
        public string SaveOrderFee(List<order_fee_value_amazon> list, int uid, string username)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_DW))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                using (var trans = cn.BeginTransaction())
                {
                    try
                    {
                        foreach (var item in list)
                        {
                            cn.Insert(item);
                        }

                        trans.Commit();
                        trans.Dispose();
                    }
                    catch (Exception ex)
                    {
                        trans.Dispose();

                        return ex.Message;

                    }

                }

            }

            return "";
        }

        public ResultDTO SaveFlowingSalesFee(flowing_sales_fee entity)
        {
            ResultDTO result = result = this.BeforeSaveFlowingSalesFee(entity);

            if (result.Result)
            {
                using (var db = new MySqlConnection(GlobalConfig.ConnectionString_DW))
                {
                    if (db.State == ConnectionState.Closed)
                    {
                        db.Open();
                    }
                    using (var trans = db.BeginTransaction())
                    {
                        int? resultCount = default(int?);
                        flowing_sales_fee oldEntity = default(flowing_sales_fee);
                        try
                        {
                            //更新
                            if (entity.id > 0)
                            {
                                oldEntity = db.Get<flowing_sales_fee>(entity.id);
                                if (oldEntity != null)
                                {
                                    entity.create_time = oldEntity.create_time;
                                    entity.update_time = DateTime.Now;
                                    resultCount = db.Update(entity);
                                }
                            }
                            //新增
                            else
                            {
                                entity.create_time = DateTime.Now;
                                entity.update_time = entity.create_time;
                                entity.id = (resultCount = db.Insert(entity)) ?? 0;
                            }
                            if (resultCount > 0)
                            {
                                if (oldEntity == null || (oldEntity.amount != entity.amount || oldEntity.currency != entity.currency || oldEntity.month != entity.month || oldEntity.platform != entity.platform || oldEntity.fee_type != entity.fee_type))
                                {
                                    result = this.ImportFlowingSalesFeeDetail(new[] { entity.id }, new List<flowing_sales_fee> { entity }, db);
                                }
                                if (result.Result)
                                {
                                    trans.Commit();
                                }
                                else
                                {
                                    trans.Rollback();
                                }
                            }
                            else
                            {
                                result.Result = false;
                                result.Message = "数据异常";
                            }
                        }
                        catch (Exception ex)
                        {
                            trans.Rollback();
                            result.Result = false;
                            result.Message = ex.Message;
                        }
                    }
                }
            }

            return result;
        }

        public ResultDTO SaveFlowingSalesFeeDetail(flowing_sales_fee_detail entity)
        {
            ResultDTO result = result = this.BeforeSaveFlowingSalesFeeDetail(entity);

            if (result.Result)
            {
                using (var db = new MySqlConnection(GlobalConfig.ConnectionString_DW))
                {
                    if (db.State == ConnectionState.Closed)
                    {
                        db.Open();
                    }
                    using (var trans = db.BeginTransaction())
                    {
                        int resultCount = 0;
                        try
                        {
                            string sql = "select * from exchange_rate_finance where month = @month and code in @code";
                            IList<exchange_rate_finance> listRate = db.Query<exchange_rate_finance>(sql, new { month = entity.date.ToString("yyyy-MM"), code = new string[] { "CNY", "USD" } }).ToList();
                            if (listRate?.Count > 0)
                            {
                                if (entity.currency.Equals("CNY", StringComparison.OrdinalIgnoreCase))
                                {
                                    entity.amount_cny = entity.amount;
                                }
                                else
                                {
                                    exchange_rate_finance rate_cny = listRate.FirstOrDefault(l => l.code.Equals(entity.currency, StringComparison.OrdinalIgnoreCase));
                                    if (rate_cny != null)
                                    {
                                        entity.amount_cny = Math.Round(entity.amount / rate_cny.exchange_rate, 2);
                                    }
                                }
                                if (entity.currency.Equals("USD", StringComparison.OrdinalIgnoreCase))
                                {
                                    entity.amount_usd = entity.amount;
                                }
                                else
                                {
                                    exchange_rate_finance rate_usd = listRate.FirstOrDefault(l => l.code.Equals("USD", StringComparison.OrdinalIgnoreCase));
                                    if (rate_usd != null)
                                    {
                                        entity.amount_usd = Math.Round(entity.amount_cny * rate_usd.exchange_rate, 2);
                                    }
                                }
                                //更新
                                if (entity.id > 0)
                                {
                                    entity.update_time = DateTime.Now;
                                    resultCount = db.Update(entity);
                                }
                                //新增
                                else
                                {
                                    entity.create_time = DateTime.Now;
                                    entity.update_time = entity.create_time;
                                    resultCount = db.Insert(entity) ?? 0;
                                }
                                if (resultCount > 0)
                                {
                                    trans.Commit();
                                }
                                else
                                {
                                    result.Result = false;
                                    result.Message = "数据异常";
                                }
                            }
                            else
                            {
                                result.Result = false;
                                result.Message = "没有汇率信息";
                            }

                        }
                        catch (Exception ex)
                        {
                            trans.Rollback();
                            result.Result = false;
                            result.Message = ex.Message;
                        }
                    }
                }
            }

            return result;
        }

        public ResultDTO ImportFlowingSalesFee(DataTable dt)
        {
            ResultDTO result = new ResultDTO();

            if (dt?.Rows?.Count > 0)
            {
                DateTime now = DateTime.Now;
                decimal amount = 0m;
                using (var db = new MySqlConnection(GlobalConfig.ConnectionString_DW))
                {
                    if (db.State == ConnectionState.Closed)
                    {
                        db.Open();
                    }
                    using (var trans = db.BeginTransaction())
                    {
                        try
                        {
                            IList<flowing_sales_fee> list = new List<flowing_sales_fee>();
                            for (int i = 0; i < dt.Rows.Count; i++)
                            {
                                DataRow row = dt.Rows[i];
                                if (!string.IsNullOrWhiteSpace(row["平台"]?.ToString()))
                                {
                                    flowing_sales_fee entity = new flowing_sales_fee();
                                    entity.platform = row["平台"].ToString();
                                    entity.account_name = row["账号"]?.ToString();
                                    entity.fee_type = row["费用类型"]?.ToString();
                                    entity.month = row["结算时间"]?.ToString()?.Replace("年", "-")?.Replace("月", string.Empty);
                                    entity.origin_order_id = row["订单号"]?.ToString();
                                    if (decimal.TryParse(row["金额"]?.ToString(), out amount))
                                    {
                                        entity.amount = amount;
                                    }
                                    entity.currency = row["币种"]?.ToString();
                                    entity.remark = row["备注"]?.ToString();
                                    entity.create_time = now;
                                    entity.update_time = now;
                                    if (!string.IsNullOrWhiteSpace(entity.fee_type) && !string.IsNullOrWhiteSpace(entity.month) && entity.amount != 0m && !string.IsNullOrWhiteSpace(entity.currency))
                                    {
                                        entity.id = db.Insert(entity) ?? 0;
                                        list.Add(entity);
                                    }
                                    else
                                    {
                                        result.Message = $"第{(i + 1)}行的{(!string.IsNullOrWhiteSpace(entity.fee_type) ? (!string.IsNullOrWhiteSpace(entity.month) ? (entity.amount != 0m ? "币种" : "金额") : "结算时间") : "费用类型")}不能为空{(entity.amount == 0m ? "或者为0" : string.Empty)}";
                                        return result;
                                    }
                                }
                            }
                            if (list.Count > 0)
                            {
                                result = this.ImportFlowingSalesFeeDetail(null, list, db);
                                if (result.Result)
                                {
                                    trans.Commit();
                                }
                            }
                        }
                        catch (Exception ex)
                        {
                            trans.Rollback();
                            result.Message = ex.Message;
                        }
                    }
                }
            }
            else
            {
                result.Message = "数据不能为空";
            }

            return result;
        }

        public ResultDTO ImportFlowingSalesFeeDetail(int[] feeId, IList<flowing_sales_fee> list = null, MySqlConnection db = null)
        {
            ResultDTO result = new ResultDTO();
            if (feeId?.Length > 0)
            {
                string sql = "select * from flowing_sales_fee where id in @fee_id";
                MySqlConnection dbDetail = db == null ? new MySqlConnection(GlobalConfig.ConnectionString_DW) : db;
                if (dbDetail.State == ConnectionState.Closed)
                {
                    dbDetail.Open();
                }
                if (list == null)
                {
                    list = dbDetail.Query<flowing_sales_fee>(sql, new { fee_id = feeId }).ToList();
                }
                if (list?.Count > 0)
                {
                    IList<flowing_sales_fee_detail> listDetail = new List<flowing_sales_fee_detail>();
                    sql = "select * from exchange_rate_finance where month in @month";
                    IList<exchange_rate_finance> listRate = dbDetail.Query<exchange_rate_finance>(sql, new { month = list.Select(l => l.month).Distinct() }).ToList();
                    if (listRate?.Count > 0)
                    {
                        DateTime now = DateTime.Now;
                        DateTime date = DateTime.MinValue;
                        foreach (flowing_sales_fee entity in list)
                        {
                            if (DateTime.TryParse(entity.month, out date))
                            {
                                DateTime monthTime = date;
                                int days = DateTime.DaysInMonth(monthTime.Year, monthTime.Month);
                                for (int day = 1; day <= days; day++)
                                {
                                    flowing_sales_fee_detail detailEntity = new flowing_sales_fee_detail()
                                    {
                                        fee_id = entity.id,
                                        platform = entity.platform,
                                        fee_type = entity.fee_type,
                                        date = new DateTime(monthTime.Year, monthTime.Month, day),
                                        amount = Math.Round(entity.amount / days, 2),
                                        currency = entity.currency,
                                        create_time = now,
                                        update_time = now
                                    };
                                    if (day == days)
                                    {
                                        detailEntity.amount = Math.Round(entity.amount - (Math.Round(entity.amount / days, 2) * (days - 1)), 2);
                                    }
                                    if (entity.currency.Equals("CNY", StringComparison.OrdinalIgnoreCase))
                                    {
                                        detailEntity.amount_cny = detailEntity.amount;
                                    }
                                    else
                                    {
                                        exchange_rate_finance rate_cny = listRate.FirstOrDefault(l => l.month == entity.month && l.code.Equals(entity.currency, StringComparison.OrdinalIgnoreCase));
                                        if (rate_cny != null)
                                        {
                                            detailEntity.amount_cny = Math.Round(detailEntity.amount / rate_cny.exchange_rate, 2);
                                        }
                                    }
                                    if (entity.currency.Equals("USD", StringComparison.OrdinalIgnoreCase))
                                    {
                                        detailEntity.amount_usd = detailEntity.amount;
                                    }
                                    else
                                    {
                                        exchange_rate_finance rate_usd = listRate.FirstOrDefault(l => l.month == entity.month && l.code.Equals("USD", StringComparison.OrdinalIgnoreCase));
                                        if (rate_usd != null)
                                        {
                                            detailEntity.amount_usd = Math.Round(detailEntity.amount_cny * rate_usd.exchange_rate, 2);
                                        }
                                    }
                                    listDetail.Add(detailEntity);
                                }
                            }
                        }
                        var trans = db == null ? dbDetail.BeginTransaction() : null;
                        try
                        {
                            sql = "delete from flowing_sales_fee_detail where fee_id in @fee_id";
                            int resultCount = dbDetail.Execute(sql, new { fee_id = feeId });
                            sql = "insert into flowing_sales_fee_detail(fee_id,platform,fee_type,date,amount,currency,amount_cny,amount_usd,delstatus,create_time,update_time)values(@fee_id,@platform,@fee_type,@date,@amount,@currency,@amount_cny,@amount_usd,@delstatus,@create_time,@update_time)";
                            resultCount = dbDetail.Execute(sql, listDetail.ToArray());
                            if (db == null)
                            {
                                trans.Commit();
                            }
                            result.Result = true;
                        }
                        catch (Exception ex)
                        {
                            if (db == null)
                            {
                                trans.Rollback();
                            }
                            result.Message = ex.Message;
                        }
                        finally
                        {
                            if (trans != null)
                            {
                                trans.Dispose();
                            }
                            if (db == null)
                            {
                                dbDetail.Close();
                                dbDetail.Dispose();
                            }
                        }
                    }
                    else
                    {
                        result.Message = "没有汇率信息";
                    }
                }
            }
            else
            {
                result.Message = "数据不能为空";
            }

            return result;
        }

        public ResultDTO DeleteFlowingSalesFee(int[] id)
        {
            ResultDTO result = this.BeforeDelete(id);

            if (result.Result)
            {
                string sql = "update flowing_sales_fee set delstatus = @delstatus, update_time = @update_time where id in @id";
                using (var db = new MySqlConnection(GlobalConfig.ConnectionString_DW))
                {
                    if (db.State == ConnectionState.Closed)
                    {
                        db.Open();
                    }
                    //开启事务
                    using (MySqlTransaction transaction = db.BeginTransaction())
                    {
                        try
                        {
                            int resultCount = db.Execute(sql, new { id = id, delstatus = 1, update_time = DateTime.Now });
                            if (resultCount > 0)
                            {
                                sql = "delete from flowing_sales_fee_detail where fee_id in @fee_id";
                                resultCount = db.Execute(sql, new { fee_id = id });
                                //提交事务
                                transaction.Commit();
                            }
                        }
                        catch (Exception ex)
                        {
                            //回滚事务
                            transaction.Rollback();
                            result.Message = ex.Message;
                            result.Result = false;
                        }
                    }
                }
            }

            return result;
        }

        public ResultDTO DeleteFlowingSalesFeeDetail(int[] id)
        {
            ResultDTO result = this.BeforeDelete(id);

            if (result.Result)
            {
                string sql = "delete from flowing_sales_fee_detail where id in @id";
                using (var db = new MySqlConnection(GlobalConfig.ConnectionString_DW))
                {
                    if (db.State == ConnectionState.Closed)
                    {
                        db.Open();
                    }
                    //开启事务
                    using (MySqlTransaction transaction = db.BeginTransaction())
                    {
                        try
                        {
                            int resultCount = db.Execute(sql, new { id = id, delstatus = 1, update_time = DateTime.Now });
                            transaction.Commit();
                        }
                        catch (Exception ex)
                        {
                            //回滚事务
                            transaction.Rollback();
                            result.Message = ex.Message;
                            result.Result = false;
                        }
                    }
                }
            }

            return result;
        }

        public ResultDTO SyncFlowingSalesFeeDetail(string platform, string month, string datacenterCol)
        {
            ResultDTO result = this.BeforeSyncFlowingSalesFeeDetail(platform, month, datacenterCol);

            if (result.Result)
            {
                using (var db = new MySqlConnection(GlobalConfig.ConnectionString_DW))
                {
                    if (db.State == ConnectionState.Closed)
                    {
                        db.Open();
                    }
                    string sql = "select * from exchange_rate_finance where month = @month and code in @code";
                    IList<exchange_rate_finance> listRate = db.Query<exchange_rate_finance>(sql, new { month = month, code = new string[] { "CNY", "USD" } }).ToList();
                    if (listRate?.Count > 0)
                    {
                        sql = $@"SELECT 
                                       id AS flowing_sales_id
                                      ,'{platform}' AS platform
                                      ,'{((new string[] { "佣金及平台费-亚马逊非FBA", "佣金及平台费-其他平台" }).Contains(datacenterCol) ? "平台费" : "FBA费")}' AS fee_type
                                      ,datatime AS date
                                      ,amountval * IF(platform = '亚马逊',-1,1) AS amount
                                      ,currency AS currency
                                      ,amountval_rmb * IF(platform = '亚马逊',-1,1) AS amount_cny
                                      ,0 AS amount_usd
                                      ,1 AS data_type
                                      ,now() AS create_time
                                      ,now() AS update_time
                                 FROM order_fee_value_amazon t1
                                 WHERE t1.`month` = @month
                                 AND t1.order_fee_config_id in (
		                             SELECT id FROM order_fee_config WHERE datacenter_col = @datacenterCol
                                 )
                                 AND platform = @platform";
                        if (datacenterCol == "佣金及平台费-其他平台")
                        {
                            sql += " AND amountval < 0 ";
                        }
                        else if (datacenterCol == "佣金及平台费-亚马逊非FBA")
                        {
                            sql += " AND amountval > 0 ";
                        }
                        IList<flowing_sales_fee_detail> list = db.Query<flowing_sales_fee_detail>(sql, new { platform = platform.Equals("Walmart", StringComparison.OrdinalIgnoreCase) ? "Walmart" : "亚马逊", month = month, datacenterCol = datacenterCol }).ToList();
                        if (list?.Count > 0)
                        {
                            int count = 0;
                            //开启事务
                            using (MySqlTransaction transaction = db.BeginTransaction())
                            {
                                try
                                {
                                    flowing_sales_fee entity = new flowing_sales_fee()
                                    {
                                        platform = platform,
                                        fee_type = (new string[] { "佣金及平台费-亚马逊非FBA", "佣金及平台费-其他平台" }).Contains(datacenterCol) ? "平台费" : "FBA费",
                                        month = month,
                                        amount = list.Sum(l => l.amount_cny),
                                        currency = "CNY",
                                        create_time = DateTime.Now,
                                        update_time = DateTime.Now,
                                        remark = datacenterCol == "仓储费-平台" ? "仓储费" : string.Empty
                                    };
                                    sql = $"update flowing_sales_fee set amount = @amount, currency = @currency,update_time = @update_time,remark = @remark where platform = @platform and fee_type = @fee_type and month = @month";
                                    count = db.Execute(sql, entity);
                                    if (count == 0)
                                    {
                                        entity.id = db.Insert(entity) ?? 0;
                                    }
                                    foreach (flowing_sales_fee_detail detailEntity in list)
                                    {
                                        detailEntity.fee_id = entity.id;
                                        if (detailEntity.amount_cny == 0)
                                        {
                                            if (detailEntity.currency.Equals("CNY", StringComparison.OrdinalIgnoreCase))
                                            {
                                                detailEntity.amount_cny = detailEntity.amount;
                                            }
                                            else
                                            {
                                                exchange_rate_finance rate_cny = listRate.FirstOrDefault(l => l.code.Equals(detailEntity.currency, StringComparison.OrdinalIgnoreCase));
                                                if (rate_cny != null)
                                                {
                                                    detailEntity.amount_cny = Math.Round(detailEntity.amount / rate_cny.exchange_rate, 2);
                                                }
                                            }
                                        }
                                        if (detailEntity.currency.Equals("USD", StringComparison.OrdinalIgnoreCase))
                                        {
                                            detailEntity.amount_usd = detailEntity.amount;
                                        }
                                        else
                                        {
                                            exchange_rate_finance rate_usd = listRate.FirstOrDefault(l => l.code.Equals("USD", StringComparison.OrdinalIgnoreCase));
                                            if (rate_usd != null)
                                            {
                                                detailEntity.amount_usd = Math.Round(detailEntity.amount_cny * rate_usd.exchange_rate, 2);
                                            }
                                        }
                                        sql = $"update flowing_sales_fee_detail set platform = @platform, date = @date,amount = @amount,currency = @currency,amount_cny = @amount_cny,amount_usd = @amount_usd,update_time = @update_time where flowing_sales_id = @flowing_sales_id and data_type = @data_type";
                                        count = db.Execute(sql, detailEntity);
                                        if (count == 0)
                                        {
                                            detailEntity.id = db.Insert(detailEntity) ?? 0;
                                        }
                                    }
                                    transaction.Commit();
                                }
                                catch (Exception ex)
                                {
                                    //回滚事务
                                    transaction.Rollback();
                                    result.Message = ex.Message;
                                    result.Result = false;
                                }
                            }
                        }
                        else
                        {
                            result.Message = "没有数据需要同步";
                            result.Result = false;
                        }
                    }
                    else
                    {
                        result.Message = "没有汇率信息";
                        result.Result = false;
                    }
                }
            }

            return result;
        }

        private ResultDTO BeforeSaveFlowingSalesFee(flowing_sales_fee entity)
        {
            ResultDTO result = new ResultDTO();
            if (entity == null)
            {
                result.Message = "数据不能为空";
            }
            else if (string.IsNullOrWhiteSpace(entity.platform))
            {
                result.Message = "平台不能为空";
            }
            else if (string.IsNullOrWhiteSpace(entity.fee_type))
            {
                result.Message = "费用类型不能为空";
            }
            else if (string.IsNullOrWhiteSpace(entity.month))
            {
                result.Message = "月份不能为空";
            }
            else if (entity.amount == 0m)
            {
                result.Message = "金额不能为空或为0";
            }
            else if (string.IsNullOrWhiteSpace(entity.currency))
            {
                result.Message = "币种不能为空";
            }
            else
            {
                result.Result = true;
            }
            return result;
        }

        private ResultDTO BeforeSaveFlowingSalesFeeDetail(flowing_sales_fee_detail entity)
        {
            ResultDTO result = new ResultDTO();
            if (entity == null)
            {
                result.Message = "数据不能为空";
            }
            else if (string.IsNullOrWhiteSpace(entity.platform))
            {
                result.Message = "平台不能为空";
            }
            else if (string.IsNullOrWhiteSpace(entity.fee_type))
            {
                result.Message = "费用类型不能为空";
            }
            else if (entity.date <= DateTime.Parse("1991-01-01"))
            {
                result.Message = "分摊日期不能为空";
            }
            else if (entity.amount == 0m)
            {
                result.Message = "金额不能为空或为0";
            }
            else if (string.IsNullOrWhiteSpace(entity.currency))
            {
                result.Message = "币种不能为空";
            }
            else
            {
                result.Result = true;
            }
            return result;
        }

        private ResultDTO BeforeDelete(int[] id)
        {
            ResultDTO result = new ResultDTO();
            if (id == null || id.Length == 0 || id.Contains(0))
            {
                result.Message = "ID不能为空";
            }
            else
            {
                result.Result = true;
            }
            return result;
        }

        private ResultDTO BeforeSyncFlowingSalesFeeDetail(string platform, string month, string datacenterCol)
        {
            ResultDTO result = new ResultDTO();

            if (string.IsNullOrWhiteSpace(platform))
            {
                result.Message = "平台不能为空";
            }
            else if (string.IsNullOrWhiteSpace(month))
            {
                result.Message = "年月";
            }
            else if (string.IsNullOrWhiteSpace(datacenterCol))
            {
                result.Message = "费用类型不能为空";
            }
            else if (!platform.Equals("Walmart", StringComparison.OrdinalIgnoreCase) && !platform.Equals("FBA", StringComparison.OrdinalIgnoreCase) && !platform.Equals("Amazon", StringComparison.OrdinalIgnoreCase))
            {
                result.Message = "平台不在同步范围";
            }
            else if (!(new string[] { "佣金及平台费-亚马逊非FBA", "仓储费-平台", "佣金及平台费-其他平台" }).Contains(datacenterCol))
            {
                result.Message = "费用类型不在同步范围";
            }
            else
            {
                result.Result = true;
            }

            return result;
        }

    }
}
