﻿using Bailun.DC.Models.Component.DTO;
using Dapper;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Linq;

namespace Bailun.DC.Services.Component
{
    /// <summary>
    /// 测试组件
    /// </summary>
    public class TestService : BaseService
    {
        /// <summary>
        /// 累计求和
        /// </summary>
        /// <param name="recalculate">重算金额</param>
        /// <returns>结果</returns>
        public ResultDTO CumulativeSummation(decimal? absValue = null)
        {
            ResultDTO result = new ResultDTO();
            if (absValue.HasValue)
            {
                using (var db = DB)
                {
                    if (db.State == ConnectionState.Closed)
                    {
                        db.Open();
                    }

                    string sql1 = $"select * from dc_test1";
                    string sql2 = $"select * from dc_test2";
                    decimal? value3 = null;
                    IList<dc_test1> list1 = db.Query<dc_test1>(sql1).ToList();
                    IList<dc_test2> list2 = db.Query<dc_test2>(sql2).ToList();
                    IList<dc_test3> list3 = new List<dc_test3>();
                    if (list1?.Count > 0)
                    {
                        for (int i = 0; i < list1.Count;)
                        {
                            dc_test1 item1 = list1[i];
                            for (int j = 0; j < list2.Count;)
                            {
                                dc_test2 item2 = list2[j];
                                if (!value3.HasValue || value3.Value > absValue)
                                {
                                    dc_test3 test3 = new dc_test3()
                                    {
                                        order_number1 = item1.order_number,
                                        value1 = item1.value,
                                    };
                                    test3.order_number2 = item2.order_number;
                                    test3.value2 = item2.value;
                                    test3.value3 = (value3 ?? item1.value) - item2.value;
                                    value3 = test3.value3;
                                    list3.Add(test3);
                                    list2.RemoveAt(j);
                                    if (value3.Value <= 0)
                                    {
                                        break;
                                    }
                                }
                                else if (value3 < (absValue * -1))
                                {
                                    dc_test3 test3 = new dc_test3()
                                    {
                                        order_number1 = item1.order_number,
                                        value1 = item1.value,
                                    };
                                    test3.order_number2 = item2.order_number;
                                    test3.value2 = item2.value;
                                    test3.value3 = value3 + item1.value;
                                    value3 = test3.value3;
                                    list3.Add(test3);
                                    break;
                                }
                                else
                                {
                                    value3 = null;
                                    break;
                                }
                            }
                            if (list2.Count == 0)
                            {
                                dc_test3 test3 = new dc_test3()
                                {
                                    order_number1 = item1.order_number,
                                    value1 = item1.value,
                                };
                                list3.Add(test3);
                            }
                            list1.RemoveAt(i);
                        }
                    }
                    if (list3?.Count > 0)
                    {
                        db.Execute("delete from dc_test3");
                        db.Execute("insert dc_test3(order_number1,order_number2,value1,value2,value3) values (@order_number1,@order_number2,@value1,@value2,@value3)", list3.ToArray());

                    }
                    result.Result = true;
                }
            }
            else
            {
                result.Message = "重算金额不能为空";
            }

            return result;
        }
    }

    public class dc_test1
    {
        [Description("ID")]
        public int id { get; set; }

        [Description("单号")]
        public string order_number { get; set; }


        [Description("值")]
        public decimal value { get; set; }

    }

    public class dc_test2
    {
        [Description("ID")]
        public int id { get; set; }

        [Description("单号")]
        public string order_number { get; set; }


        [Description("值")]
        public decimal value { get; set; }

    }

    public class dc_test3
    {
        [Description("ID")]
        public int id { get; set; }

        [Description("单号1")]
        public string order_number1 { get; set; }

        [Description("单号2")]
        public string order_number2 { get; set; }

        [Description("值1")]
        public decimal value1 { get; set; }

        [Description("值2")]
        public decimal value2 { get; set; }

        [Description("值3")]
        public decimal? value3 { get; set; }

    }
}
