﻿using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Models.Component.Entity;
using Bailun.DC.Models.Component.Enum;
using Dapper;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;

namespace Bailun.DC.Services.Component
{
    /// <summary>
    /// 查询组件
    /// </summary>
    public class TableService : BaseService
    {
        /// <summary>
        /// 获取查询组件
        /// </summary>
        /// <param name="code">编码</param>
        /// <param name="id">ID</param>
        /// <returns></returns>
        public TableDTO Get(string code = null, string id = null)
        {
            TableDTO dto = default(TableDTO);

            if (!string.IsNullOrWhiteSpace(code) || !string.IsNullOrWhiteSpace(id))
            {
                dc_component_table entity = default(dc_component_table);
                using (var db = DB)
                {
                    DynamicParameters sqlparam = new DynamicParameters();
                    sqlparam.Add("id", id);
                    sqlparam.Add("code", code);
                    entity = db.QueryFirstOrDefault<dc_component_table>("select * from dc_component_table where is_delete = 0 and (id = @id or code = @code)", sqlparam);
                    db.Close();
                }
                if (entity != null)
                {
                    dto = new TableDTO
                    {
                        Id = entity.id,
                        Code = entity.code,
                        Name = entity.name,
                        MenuCode = entity.menu_code,
                        Javascript = entity.javascript,
                        IsShowSearchButton = entity.is_show_search_button,
                        IsShowResetButton = entity.is_show_reset_button,
                        IsShowExportButton = entity.is_show_export_button,
                        IsShowOfflineExportButton = entity.is_show_offline_export_button,
                        IsShowImportButton = entity.is_show_import_button,
                        IsShowSequenceColumn = entity.is_show_sequence_column,
                        OperateControlsPosition = entity.operate_controls_position,
                        ImportApi = entity.import_api,
                        ColumnType = entity.column_type,
                        ColumnValue = entity.column_value,
                        DataType = entity.data_type,
                        DataValue = entity.data_value,
                        DataDB = entity.data_db,
                        DataSortSql = entity.data_sort_sql,
                        IsAutoSearch = entity.is_auto_search,
                        IsShowColumnSearch = entity.is_show_column_search,
                        SelectRowMethod = entity.select_row_method,
                        OperateColumnName = entity.operate_column_name,
                        OperateColumnWidth = entity.operate_column_width,
                        ListCrumb = !string.IsNullOrWhiteSpace(entity.crumbs) ? DeserializeCollection<string>(entity.crumbs) : null,
                        ListJavascriptSrc = !string.IsNullOrWhiteSpace(entity.javascript_src) ? DeserializeCollection<string>(entity.javascript_src) : null,
                        ListFilterControl = !string.IsNullOrWhiteSpace(entity.filter_controls) ? DeserializeCollection<dynamic>(entity.filter_controls) : null,
                        ListOperateControl = !string.IsNullOrWhiteSpace(entity.operate_controls) ? DeserializeCollection<dynamic>(entity.operate_controls) : null,
                        ListOperateColumnControl = !string.IsNullOrWhiteSpace(entity.operate_column_value) ? DeserializeCollection<dynamic>(entity.operate_column_value) : null,
                    };
                    //列
                    if (dto.ColumnType == ColumnTypeEnum.Config && !string.IsNullOrWhiteSpace(entity.column_value))
                    {
                        dto.ColumnValue = null;
                        dto.ListColumn = DeserializeCollection<dynamic>(entity.column_value);
                    }
                    if (dto.ListOperateControl?.Count() > 0)
                    {
                        //权限过虑按钮
                    }
                }
            }

            return dto;
        }

        public IList<dynamic> GetListColumn(QueryFilterDTO queryFilter = null, TableDTO entity = null)
        {
            IList<dynamic> list = default(IList<dynamic>);

            if (queryFilter != null && !string.IsNullOrWhiteSpace(queryFilter.Code))
            {
                if (entity == null)
                {
                    entity = this.Get(queryFilter.Code);
                }
                if (entity != null && (!string.IsNullOrWhiteSpace(entity.ColumnValue) || entity.ListColumn?.Count() > 0))
                {
                    switch (entity.ColumnType)
                    {
                        #region SQL
                        case ColumnTypeEnum.SqlFirst:
                        case ColumnTypeEnum.Sql:
                            DynamicParameters sqlparam = new DynamicParameters();
                            //过虑条件SQL
                            this.GetFilterSql(queryFilter, ref sqlparam);
                            //查询
                            using (MySqlConnection db = this.GetDbConnection(entity))
                            {
                                list = DB.Query<dynamic>(entity.ColumnValue, sqlparam).ToList();
                            }
                            break;
                        #endregion

                        #region 本地配置
                        case ColumnTypeEnum.Config:
                            list = !string.IsNullOrWhiteSpace(entity.ColumnValue) ? DeserializeCollection<dynamic>(entity.ColumnValue).ToList() : entity.ListColumn.ToList();
                            break;
                        #endregion 

                        #region 控制器函数/Webapi
                        case ColumnTypeEnum.Api:
                            /*
                            ValidateResult result = default(ValidateResult);
                            Uri uri = HttpContext.Current.Request.Url;
                            //请求头
                            IDictionary<string, string> headers = default(IDictionary<string, string>);
                            string queryString = this.GetQueryString(entity.ColumnMethod, null, null, null, this.RecordId);
                            string url = string.Empty;
                            if (entity.ColumnType == (int)ColumnTypeEnum.Controller)
                            {
                                headers = new Dictionary<string, string>()
                                {
                                    { "Cookie",$"{"AmwayWorkflowByOurway"}={HttpContext.Current.Request.Cookies["AmwayWorkflowByOurway"]?.Value}"}
                                };
                                if (!string.IsNullOrWhiteSpace(entity.ColumnValue))
                                {
                                    queryString = $"?{entity.ColumnValue.Trim().Replace("?", string.Empty)}{queryString.Replace("?", "&")}";
                                }
                                url = $"{"http"}://{uri.Host}/{ApplicationManager.SystemInfo.WebApplicationName}/{entity.ColumnController}/{entity.ColumnAction}{queryString}";
                            }
                            else if (!string.IsNullOrWhiteSpace(entity.ColumnValue))
                            {
                                if (!entity.ColumnValue.Contains("://"))
                                {
                                    url = $"{"http"}://{entity.ColumnValue.Trim()}{(entity.ColumnValue.Contains("?") ? queryString.Replace("?", "&") : queryString)}";
                                }
                                else
                                {
                                    url = $"{entity.ColumnValue.Trim()}{(entity.ColumnValue.Contains("?") ? queryString.Replace("?", "&") : queryString)}";
                                }
                            }
                            if (!string.IsNullOrWhiteSpace(ConfigurationManager.AppSettings["BaseWebHost"]) && !string.IsNullOrWhiteSpace(ConfigurationManager.AppSettings["BaseWebLocalHost"]))
                            {
                                url = url.Replace(ConfigurationManager.AppSettings["BaseWebHost"], ConfigurationManager.AppSettings["BaseWebLocalHost"]);
                            }
                            switch (entity.ColumnMethod)
                            {
                                case (int)MethodEnum.Get:
                                    result = this.HttpGet<ValidateResult>(url);
                                    break;
                                case (int)MethodEnum.Post:
                                    string postData = JsonConvert.SerializeObject(new QueryDTO { RecordId = this.RecordId });
                                    result = this.HttpPost<ValidateResult>(url, postData, headers);
                                    break;
                            }
                            if (result?.Result == true)
                            {
                                list = JsonConvert.DeserializeObject<IList<ColumnDTO>>(JsonConvert.SerializeObject(result.Data));
                            }
                            */
                            break;

                            #endregion
                    }

                    #region 报表表头下拉选项
                    /*
                    if (list?.Count > 0)
                    {
                        foreach (var item in collection)
                        {
                            if (item.Type.EqualIgnoreCase("SELECT") && (item.ListOption == null || item.ListOption.Count() == 0))
                            {
                                switch (entity.DataType)
                                {
                                    #region 控制器函数/Webapi

                                    case (int)DataTypeEnum.Controller:
                                    case (int)DataTypeEnum.Webapi:
                                        break;

                                    #endregion

                                    #region 数据库表或视图/SQL

                                    case (int)DataTypeEnum.Table:
                                    case (int)DataTypeEnum.Sql:
                                        DynamicParameters sqlparam = new DynamicParameters();  
                                        string sql = $"SELECT DISTINCT {item.Code} FROM {(entity.DataType == (int)DataTypeEnum.Table ? string.Format("[dbo].[{0}]", dataValueSql) : $"( {dataValueSql} )")} AS A";
                                        //查询SQL
                                        using (var db = DB)
                                        {
                                            if (db.State == System.Data.ConnectionState.Closed)
                                            {
                                                db.Open();
                                            }
                                            item.ListOption = DB.Query<ColumnDTO>(sql, sqlparam);
                                        }
                                        break;

                                    #endregion

                                    #region 动态SQL

                                    case (int)DataTypeEnum.DynamicSql:

                                        break;

                                    #endregion

                                    default:
                                        break;
                                }
                            }
                        } 
                    }
                    */
                    #endregion
                }
            }

            return list;
        }

        public PageListDTO GetListData(QueryFilterDTO queryFilter, TableDTO entity = null)
        {
            PageListDTO pageList = new PageListDTO();
            if (queryFilter != null && !string.IsNullOrWhiteSpace(queryFilter.Code))
            {
                if (entity == null)
                {
                    entity = this.Get(queryFilter.Code);
                }
                if (entity != null && (!string.IsNullOrWhiteSpace(entity.DataValue)))
                {
                    switch (entity.DataType)
                    {
                        #region Api
                        case DataTypeEnum.Api:
                            /*
                                //Uri uri = HttpContext.Current.Request.Url;
                                //ValidateResult result = default(ValidateResult);
                                ////请求头
                                //IDictionary<string, string> headers = default(IDictionary<string, string>);
                                //string queryString = this.GetQueryString(entity.DataMethod, query, startRecord, recordCount, this.RecordId);
                                //string url = string.Empty;
                                //if (entity.DataType == (int)DataTypeEnum.Controller)
                                //{
                                //    headers = new Dictionary<string, string>()
                                //    {
                                //        { "Cookie",$"{"AmwayWorkflowByOurway"}={HttpContext.Current.Request.Cookies["AmwayWorkflowByOurway"]?.Value}"}
                                //    };
                                //    if (!string.IsNullOrWhiteSpace(entity.DataValue))
                                //    {
                                //        queryString = $"?{entity.DataValue.Trim().Replace("?", string.Empty)}{queryString.Replace("?", "&")}";
                                //    }
                                //    url = $"{"http"}://{uri.Host}/{ApplicationManager.SystemInfo.WebApplicationName}/{entity.DataController}/{entity.DataAction}{queryString}";
                                //}
                                //else if (!string.IsNullOrWhiteSpace(entity.DataValue))
                                //{
                                //    if (!entity.DataValue.Contains("://"))
                                //    {
                                //        url = $"{"http"}://{entity.DataValue.Trim()}{(entity.DataValue.Contains("?") ? queryString.Replace("?", "&") : queryString)}";
                                //    }
                                //    else
                                //    {
                                //        url = $"{entity.DataValue.Trim()}{(entity.DataValue.Contains("?") ? queryString.Replace("?", "&") : queryString)}";
                                //    }
                                //}
                                //if (!string.IsNullOrWhiteSpace(ConfigurationManager.AppSettings["BaseWebHost"]) && !string.IsNullOrWhiteSpace(ConfigurationManager.AppSettings["BaseWebLocalHost"]))
                                //{
                                //    url = url.Replace(ConfigurationManager.AppSettings["BaseWebHost"], ConfigurationManager.AppSettings["BaseWebLocalHost"]);
                                //}
                                //switch (entity.DataMethod)
                                //{
                                //    case (int)MethodEnum.Get:
                                //        result = this.HttpGet<ValidateResult>(url, headers);
                                //        break;
                                //    case (int)MethodEnum.Post:
                                //        string postData = default(string);
                                //        if (query != null && (!string.IsNullOrWhiteSpace(query.RecordId) || (query.ListFilter != null && query.ListFilter.Count > 0)) || query.StartRecord >= 0 || query.RecordCount > 0)
                                //        {
                                //            postData = JsonConvert.SerializeObject(query);
                                //        }
                                //        result = this.HttpPost<ValidateResult>(url, postData, headers);
                                //        break;
                                //}
                                //if (result?.Result == true)
                                //{
                                //    pageList = JsonConvert.DeserializeObject<PageListDTO>(JsonConvert.SerializeObject(result.Data));
                                //}
                            */
                            break;
                        #endregion

                        #region 数据库表或视图/SQL
                        case DataTypeEnum.Table:
                        case DataTypeEnum.Sql:
                            (int, IDataReader) reader = this.GetListDataReader(queryFilter, entity);
                            using (reader.Item2)
                            {
                                pageList.TotalCount = reader.Item1;
                                if (pageList.TotalCount > 0)
                                {
                                    pageList.List.Load(reader.Item2);
                                }
                            }
                            MySqlConnection db = this.GetDbConnection(entity);
                            if (db.State == ConnectionState.Open)
                            {
                                db.Close();
                                db = null;
                            }
                            break;

                        #endregion

                        #region 动态SQL

                        case DataTypeEnum.DynamicSql:
                            /*
                                                    string sql = default(string);
                                                    uri = HttpContext.Current.Request.Url;
                                                    //请求头
                                                    headers = new Dictionary<string, string>()
                                                    {
                                                        { "Cookie",$"{"AmwayWorkflowByOurway"}={HttpContext.Current.Request.Cookies["AmwayWorkflowByOurway"]?.Value}"}
                                                    };
                                                    queryString = this.GetQueryString(entity.DataMethod, query, startRecord, recordCount, this.RecordId);
                                                    if (!string.IsNullOrWhiteSpace(entity.DataValue))
                                                    {
                                                        queryString = $"?{entity.DataValue.Trim().Replace("?", string.Empty)}{queryString.Replace("?", "&")}";
                                                    }
                                                    url = $"{"http"}://{uri.Host}/{ApplicationManager.SystemInfo.WebApplicationName}/{entity.DataController}/{entity.DataAction}{queryString}";
                                                    if (!string.IsNullOrWhiteSpace(ConfigurationManager.AppSettings["BaseWebHost"]) && !string.IsNullOrWhiteSpace(ConfigurationManager.AppSettings["BaseWebLocalHost"]))
                                                    {
                                                        url = url.Replace(ConfigurationManager.AppSettings["BaseWebHost"], ConfigurationManager.AppSettings["BaseWebLocalHost"]);
                                                    }
                                                    switch (entity.DataMethod)
                                                    {
                                                        case (int)MethodEnum.Get:
                                                            sql = this.HttpGet<string>(url, headers);
                                                            break;
                                                        case (int)MethodEnum.Post:
                                                            string postData = default(string);
                                                            if (query != null && (!string.IsNullOrWhiteSpace(query.RecordId) || (query.ListFilter != null && query.ListFilter.Count > 0)) || query.StartRecord >= 0 || query.RecordCount > 0)
                                                            {
                                                                postData = JsonConvert.SerializeObject(query);
                                                            }
                                                            sql = this.HttpPost<string>(url, postData, headers);
                                                            break;
                                                    }
                                                    if (!string.IsNullOrWhiteSpace(sql))
                                                    {
                                                        sqlParameter = new List<SqlParameter>();
                                                        startRecord = startRecord < 0 && query?.StartRecord > 0 ? query.StartRecord : (startRecord > 0 ? startRecord : 1);
                                                        recordCount = recordCount < 0 && query?.RecordCount > 0 ? query.RecordCount : (recordCount > 0 ? recordCount : null);
                                                        offset = (startRecord.Value - 1) * (recordCount ?? 0);
                                                        fetch = recordCount > 0 ? recordCount.Value : int.MaxValue;
                                                        whereSql = this.GetFilterSql(query, ref sqlParameter);
                                                        orderbySql = this.GetOrderBySql(query, code, entity.TableOrderBy);
                                                        fromSql = $"FROM ({sql}) AS A {whereSql}";
                                                        totalSql = $"SELECT COUNT(*) {fromSql}";
                                                        dataSql = $"SELECT A.* {fromSql} ORDER BY {orderbySql} OFFSET {offset} ROWS FETCH NEXT {fetch} ROWS ONLY";
                                                        using (var dbContext = this.DbContext)
                                                        {
                                                            pageList.TotalCount = dbContext.Database.SqlQuery<int>(totalSql, sqlParameter.Select(x => ((ICloneable)x).Clone()).ToArray()).FirstOrDefault();
                                                            if (pageList.TotalCount > 0)
                                                            {
                                                                pageList.List = dbContext.SqlQuery(dataSql, sqlParameter.ToArray());
                                                            }
                                                        }
                                                    }
                            */
                            break;
                        #endregion

                        #region 储存过程
                        case DataTypeEnum.ExecuteSql:
                            /*
                             startRecord = startRecord < 0 && query?.StartRecord > 0 ? query.StartRecord : (startRecord > 0 ? startRecord : 1);
                             recordCount = recordCount < 0 && query?.RecordCount > 0 ? query.RecordCount : (recordCount > 0 ? recordCount : null);
                             offset = (startRecord.Value - 1) * (recordCount ?? 0);
                             fetch = recordCount > 0 ? recordCount.Value : int.MaxValue;
                             //排序条件SQL
                             orderbySql = this.GetOrderBySql(query, code, entity.TableOrderBy);       
                             sqlParameter = new List<SqlParameter>();
                             //过虑条件SQL
                             whereSql = this.GetFilterSql(query, ref sqlParameter, "''' +", "+'''", "'");
                             sqlParameter.Add(new SqlParameter() { ParameterName = "@ORDER_BY", Value = orderbySql });
                             sqlParameter.Add(new SqlParameter() { ParameterName = "@OFFSET", Value = offset.ToString() });
                             sqlParameter.Add(new SqlParameter() { ParameterName = "@FETCH", Value = fetch.ToString() });
                             // sqlParameter.Add(new SqlParameter() { ParameterName = "@WHERE", Value = whereSql.Replace("WHERE", string.Empty) });

                             sql = entity.DataValue;
                             //替换SQL参数
                             //sql = Regex.Replace(sql, "@ORDER_BY", orderbySql, RegexOptions.IgnoreCase);
                             //sql = Regex.Replace(sql, "@OFFSET", offset.ToString(), RegexOptions.IgnoreCase);
                             //sql = Regex.Replace(sql, "@FETCH", fetch.ToString(), RegexOptions.IgnoreCase);
                             sql = Regex.Replace(sql, "@WHERE", whereSql.Replace("WHERE", string.Empty), RegexOptions.IgnoreCase);
                             using (var dbContext = this.DbContext)
                             {
                                 DataSet ds = dbContext.SqlQuery(sql, new string[] { "TableCount", "Table" }, sqlParameter.ToArray());
                                 pageList.TotalCount = ds?.Tables?[0]?.Rows?[0]?[0].ToInt(0) ?? 0;
                                 if (pageList.TotalCount > 0)
                                 {
                                     pageList.List = ds.Tables[1];
                                 }
                             }
                            */
                            break;
                        #endregion

                        #region 储存过程名称
                        case DataTypeEnum.ExecuteName:
                            /*
                            using (var dbContext = this.DbContext)
                            {
                                IList<string> listParameter = this.GetSpParameters(entity.DataValue);
                                if (listParameter == null || listParameter.Count == 0)
                                {
                                    sql = $"EXEC {entity.DataValue}";
                                }
                                else
                                {
                                    //过虑条件SQL
                                    whereSql = this.GetFilterSql(query);
                                    IDictionary<string, string> dic = new Dictionary<string, string>()
                                                                    {
                                                                        { "@ATTENDEESTABLENAME",laolaoView},
                                                                        { "@ONLINEBASEURL",onlineBaseURL},
                                                                        { "@RECORD_ID",recordId},
                                                                        { "@WHERE",whereSql.Replace("WHERE", string.Empty).Replace("'", "''")},
                                                                        { "@ORDER_BY",orderbySql},
                                                                        { "@OFFSET",offset.ToString()},
                                                                        { "@FETCH",fetch.ToString()}
                                                                    };
                                    sql = $"EXEC {entity.DataValue} {string.Join(",", listParameter.Join(dic, i => i.ToUpper(), o => o.Key, (i, o) => $"{i}='{o.Value}'"))}";
                                }
                                DataSet ds = dbContext.SqlQuery(sql, new string[] { "TableCount", "Table" });
                                pageList.TotalCount = ds?.Tables?[0]?.Rows?[0]?[0].ToInt(0) ?? 0;
                                if (pageList.TotalCount > 0)
                                {
                                    pageList.List = ds.Tables[1];
                                }
                            }
                            */
                            break;
                        #endregion

                        default:
                            break;
                    }
                }
            }

            return pageList;
        }

        public (string, byte[]) Export(QueryFilterDTO queryFilter, TableDTO entity = null)
        {
            byte[] b = default(byte[]);
            string name = default(string);
            int dataCount = default(int);
            if (queryFilter != null)
            {
                if (entity == null)
                {
                    entity = this.Get(queryFilter.Code);
                }
                if (entity != null)
                {
                    name = string.Join(string.Empty, entity.ListCrumb);
                    //列标题
                    IEnumerable<ColumnDTO> listColumn = JsonConvert.DeserializeObject<IList<ColumnDTO>>(JsonConvert.SerializeObject(this.GetListColumn(queryFilter, entity)))?.Where(l => l.IsExport == true || (l.IsExport == null && l.IsHide != true));
                    if (listColumn != null)
                    {
                        //数据类型
                        DataTypeEnum?[] dataTypes = { DataTypeEnum.Table, DataTypeEnum.Sql };
                        //全部数据导出
                        queryFilter.CurrentPage = null;
                        queryFilter.PageSize = null;
                        if (!string.IsNullOrWhiteSpace(entity.DataValue) && dataTypes.Contains(entity.DataType))
                        {
                            (int, IDataReader) reader = this.GetListDataReader(queryFilter, entity);
                            dataCount = reader.Item1;
                            using (reader.Item2)
                            {
                                if (dataCount > 0)
                                {
                                    b = DataReaderToExcel(listColumn, reader.Item2, reader.Item1);
                                }
                            }
                            MySqlConnection db = this.GetDbConnection(entity);
                            if (db.State == ConnectionState.Open)
                            {
                                db.Close();
                                db = null;
                            }
                        }
                        else
                        {
                            PageListDTO pageList = this.GetListData(queryFilter, entity);
                            if (listColumn?.Count() > 0)
                            {
                                b = DataTableToExcel(listColumn, pageList.List);
                            }
                        }
                    }
                }
            }
            if (b != null)
            {
                name = $"{(name ?? "Export")}_{DateTime.Now.ToString("yyyyMMddhhmm")}.{(dataCount <= 65535 ? "xls" : "xlsx")}";
            }

            return (name, b);
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="dto">报表组件对象</param>
        /// <returns>保存结果</returns>
        public ResultDTO Save(TableDTO dto)
        {
            ResultDTO result = this.BeforeSave(dto);

            if (result.Result)
            {
                dc_component_table entity = new dc_component_table()
                {
                    id = dto.Id,
                    code = dto.Code,
                    name = dto.Name,
                    menu_code = dto.MenuCode,
                    javascript = dto.Javascript,
                    is_show_search_button = dto.IsShowSearchButton ?? false,
                    is_show_reset_button = dto.IsShowResetButton ?? false,
                    is_show_export_button = dto.IsShowExportButton ?? false,
                    is_show_offline_export_button = dto.IsShowOfflineExportButton ?? false,
                    is_show_import_button = dto.IsShowImportButton ?? false,
                    is_show_sequence_column = dto.IsShowSequenceColumn ?? false,
                    is_show_column_search = dto.IsShowColumnSearch ?? false,
                    import_api = dto.ImportApi,
                    column_type = dto.ColumnType,
                    column_value = dto.ColumnType == ColumnTypeEnum.Config && dto.ListColumn?.Count() > 0 ? JsonConvert.SerializeObject(dto.ListColumn) : dto.ColumnValue,
                    data_type = dto.DataType,
                    data_value = dto.DataValue,
                    data_db = dto.DataDB,
                    data_sort_sql = dto.DataSortSql,
                    is_auto_search = dto.IsAutoSearch,
                    select_row_method = dto.SelectRowMethod,
                    operate_column_name = dto.OperateColumnName,
                    operate_column_width = dto.OperateColumnWidth,
                    operate_controls_position = dto.OperateControlsPosition,
                    gmt_modified = DateTime.Now,
                    crumbs = dto.ListCrumb.Count(l => !string.IsNullOrWhiteSpace(l) && !l.Equals("null", StringComparison.OrdinalIgnoreCase)) > 0 ? JsonConvert.SerializeObject(dto.ListCrumb) : null,
                    javascript_src = dto.ListJavascriptSrc?.Count(l => !string.IsNullOrWhiteSpace(l) && !l.Equals("null", StringComparison.OrdinalIgnoreCase)) > 0 ? JsonConvert.SerializeObject(dto.ListJavascriptSrc) : null,
                    filter_controls = dto.ListFilterControl?.Count(l => !string.IsNullOrWhiteSpace(l.ToString()) && !l.ToString().Equals("null", StringComparison.OrdinalIgnoreCase)) > 0 ? JsonConvert.SerializeObject(dto.ListFilterControl) : null,
                    operate_controls = dto.ListOperateControl?.Count(l => !string.IsNullOrWhiteSpace(l.ToString()) && !l.ToString().Equals("null", StringComparison.OrdinalIgnoreCase)) > 0 ? JsonConvert.SerializeObject(dto.ListOperateControl) : null,
                    operate_column_value = dto.ListOperateColumnControl?.Count(l => !string.IsNullOrWhiteSpace(l.ToString()) && !l.ToString().Equals("null", StringComparison.OrdinalIgnoreCase)) > 0 ? JsonConvert.SerializeObject(dto.ListOperateColumnControl) : null,
                };
                using (var db = DB)
                {
                    //开启事务
                    MySqlTransaction transaction = db.BeginTransaction();
                    try
                    {
                        int? resultCount = entity.id > 0 ? db.Update(entity) : db.Insert(entity);
                        if (resultCount == 0)
                        {
                            throw new Exception("保存失败");
                        }
                        else
                        {
                            //提交事务
                            transaction.Commit();
                            result.Message = "保存成功";
                        }
                    }
                    catch (Exception ex)
                    {
                        //回滚事务
                        transaction.Rollback();
                        result.Message = ex.Message;
                        result.Result = false;
                    }
                }
            }

            return result;
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="id">ID</param>
        /// <param name="is_delete">是否删除</param>
        /// <returns>保存结果</returns>
        public ResultDTO Save(int[] id, bool is_delete)
        {
            ResultDTO result = this.BeforeSave(id);

            if (result.Result)
            {
                string sql = "update dc_component_table set is_delete = @is_delete, gmt_modified = @gmt_modified where id in @id";
                using (var db = DB)
                {
                    //开启事务
                    MySqlTransaction transaction = db.BeginTransaction();
                    try
                    {
                        int resultCount = db.Execute(sql, new { id = id, is_delete = is_delete, gmt_modified = DateTime.Now });
                        if (resultCount == 0)
                        {
                            throw new Exception("保存失败");
                        }
                        else
                        {
                            //提交事务
                            transaction.Commit();
                            result.Message = "保存成功";
                        }
                    }
                    catch (Exception ex)
                    {
                        //回滚事务
                        transaction.Rollback();
                        result.Message = ex.Message;
                        result.Result = false;
                    }
                }
            }

            return result;
        }

        private string GetFilterSql(QueryFilterDTO queryFilter, ref DynamicParameters sqlparam, string sp = "", string sp2 = "", string sp3 = "")
        {
            StringBuilder sql = new StringBuilder("WHERE 1 = 1 ");
            if (queryFilter != null && (queryFilter.ListFilter != null && queryFilter.ListFilter.Count > 0))
            {
                foreach (FieldFilterDTO fieldFilter in queryFilter.ListFilter)
                {
                    if (!string.IsNullOrWhiteSpace(fieldFilter.Field) && !string.IsNullOrWhiteSpace(fieldFilter.Operator))
                    {
                        if (!string.IsNullOrWhiteSpace(fieldFilter.Value))
                        {
                            //去两边空格
                            fieldFilter.Value = fieldFilter.Value.Trim();
                            sql.Append("AND ");
                            //时间范围
                            if (fieldFilter.Operator.ToUpper().Equals("BETWEEN"))
                            {
                                DateTime dt1 = DateTime.MinValue;
                                DateTime dt2 = DateTime.MinValue;
                                string[] fieldValues = fieldFilter.Value.Split(new string[] { "," }, StringSplitOptions.RemoveEmptyEntries);
                                if (fieldValues.Length > 0 && DateTime.TryParse(fieldValues[0], out dt1))
                                {
                                    sql.Append($" ( `{fieldFilter.Field}` >= ");
                                    sql.Append($"{sp}@{fieldFilter.Field}1{sp2} ");
                                    sqlparam.Add($"@{fieldFilter.Field}1", dt1);
                                    if (fieldValues.Length > 1 && DateTime.TryParse(fieldValues[1], out dt2))
                                    {
                                        sql.Append($" AND `{fieldFilter.Field}` <{(dt2 != dt2.Date ? "=" : string.Empty)} ");
                                        sql.Append($"{sp}@{fieldFilter.Field}2{sp2} ");
                                        sqlparam.Add($"@{fieldFilter.Field}2", (dt2 == dt2.Date ? dt2.Date.AddDays(1).Date : dt2));
                                    }
                                    sql.Append($" ) ");
                                }
                                else if (fieldValues.Length > 1)
                                {
                                    sql.Append($"`{fieldFilter.Field}` BETWEEN ( ");
                                    sql.Append($"{sp}@{fieldFilter.Field}1{sp2} ,{sp}@{fieldFilter.Field}2{sp2} ");
                                    sql.Append($" ) ");
                                    sqlparam.Add($"@{fieldFilter.Field}1", fieldValues[0]);
                                    sqlparam.Add($"@{fieldFilter.Field}2", fieldValues[1]);
                                }
                            }
                            else
                            {
                                sql.Append($"`{fieldFilter.Field}` {fieldFilter.Operator.ToUpper()} ");
                                //模糊匹配
                                if (fieldFilter.Operator.ToUpper().Equals("LIKE"))
                                {
                                    sql.Append($"CONCAT('%',@{fieldFilter.Field},'%')");
                                    sqlparam.Add($"@{fieldFilter.Field}", fieldFilter.Value);
                                }
                                //其他操作符
                                else
                                {
                                    sql.Append($"{sp}@{fieldFilter.Field}{sp2} ");
                                    if (!fieldFilter.Operator.ToUpper().Equals("IN"))
                                    {
                                        sqlparam.Add($"@{fieldFilter.Field}", fieldFilter.Value);
                                    }
                                    else
                                    {
                                        sqlparam.Add($"@{fieldFilter.Field}", fieldFilter.Value.Split(",", StringSplitOptions.RemoveEmptyEntries));
                                    }
                                }
                            }
                        }
                        else if (fieldFilter.Operator.Trim().Equals("=") || fieldFilter.Operator.ToUpper().Trim().Equals("IS"))
                        {
                            sql.Append("AND ");
                            sql.Append($"( `{ fieldFilter.Field }` IS NULL OR { fieldFilter.Field } = '' ) ");
                        }
                        else if (fieldFilter.Operator.Trim().Equals("!=") || fieldFilter.Operator.ToUpper().Trim().Equals("<>"))
                        {
                            sql.Append("AND ");
                            sql.Append($"( `{ fieldFilter.Field }` IS NOT NULL AND { fieldFilter.Field } <> '' ) ");
                        }
                    }
                }
            }

            return sql.ToString();
        }

        private string GetOrderBySql(QueryFilterDTO queryFilter, TableDTO entity = null)
        {
            string sql = string.Empty;

            if (queryFilter?.ListOrder?.Where(l => l != null).Count() > 0)
            {
                sql = string.Join(",", queryFilter.ListOrder.Where(l => l != null && !string.IsNullOrWhiteSpace(l.Field) && !string.IsNullOrWhiteSpace(l.Operator)).Select(l => $"`{l.Field}` {l.Operator.ToUpper().Replace("ENDING", string.Empty)}"));
            }
            else if (entity != null)
            {
                if (!string.IsNullOrWhiteSpace(entity.DataSortSql))
                {
                    sql = entity.DataSortSql;
                }
                else
                {
                    IEnumerable<dynamic> listColumn = default(IList<dynamic>);
                    if (entity.ColumnType == ColumnTypeEnum.Config)
                    {
                        listColumn = entity.ListColumn;
                    }
                    else
                    {
                        listColumn = this.GetListColumn(queryFilter, entity);
                    }
                    if (listColumn?.Count() > 0 && listColumn.Any(l => !string.IsNullOrWhiteSpace(l.Code) && l.OrderSort > 0))
                    {
                        sql = string.Join(",", listColumn.Where(l => !string.IsNullOrWhiteSpace(l.Code) && l.OrderSort > 0).OrderBy(l => l.OrderSort).Select(l => $"`{l.Code}` {(l.Descending == true ? "desc" : "asc")}"));
                    }
                }
            }

            return sql;
        }

        private MySqlConnection GetDbConnection(TableDTO entity)
        {
            MySqlConnection db = default(MySqlConnection);
            switch (entity.DataDB)
            {
                case DBEnum.DataWareHouse:
                    db = DW_DB;
                    break;
                case DBEnum.Pro:
                    db = PRO_DB;
                    break;
                case DBEnum.Skums:
                    db = SKUMS;
                    break;
                case DBEnum.Fund:
                    db = FUND_DB;
                    break;
                case DBEnum.Fee:
                    db = FEE_DB;
                    break;
                default:
                    db = DB;
                    break;
            }
            return db;
        }

        private (int, IDataReader) GetListDataReader(QueryFilterDTO queryFilter, TableDTO entity)
        {
            (int, IDataReader) reader = (0, null);
            DynamicParameters sqlparam = new DynamicParameters();
            int fetch = (queryFilter.PageSize > 0 ? queryFilter.PageSize : int.MaxValue).Value;
            int offset = (((queryFilter.CurrentPage > 1 ? queryFilter.CurrentPage : 1) - 1) * fetch).Value;
            //查询字段
            string selectSql = "*";
            if (queryFilter?.ListField?.Count > 0)
            {
                selectSql = $"{(queryFilter.ListField.Any(l => l.Operator != null && l.Operator.Equals("DISTINCT", StringComparison.OrdinalIgnoreCase)) ? "DISTINCT" : string.Empty)} {string.Join(",", queryFilter.ListField.Select(l => l.Field))}";
            }
            //过虑条件SQL
            string whereSql = this.GetFilterSql(queryFilter, ref sqlparam);
            //排序条件SQL
            string orderbySql = this.GetOrderBySql(queryFilter, entity);
            //统计查询
            string totalSql = default(string);
            //数据查询
            string dataSql = default(string);
            switch (entity.DataType)
            {
                case DataTypeEnum.Table:
                    totalSql = $"SELECT COUNT({selectSql}) FROM `{entity.DataValue}` {whereSql}";
                    dataSql = $"SELECT {selectSql} FROM `{entity.DataValue}` {whereSql} {(!string.IsNullOrWhiteSpace(orderbySql) ? $"ORDER BY {orderbySql}" : string.Empty) } LIMIT {offset} , {fetch}";
                    break;
                default:
                    //默认参数
                    var setSql = string.Empty;
                    var paramIndex = entity.DataValue.IndexOf("@");
                    if (paramIndex >= 0)
                    {
                        foreach (Match item in Regex.Matches(entity.DataValue.Substring(paramIndex), @"@\w+[^\w]*"))
                        {
                            string paramName = item.Value.Substring(1, Regex.Match(item.Value.Substring(1), @"[^\w]*$").Index);
                            if (!sqlparam.ParameterNames.Contains(paramName))
                            {
                                if (entity.DataValue.Substring(0, paramIndex + item.Index).TrimEnd().EndsWith("in", StringComparison.OrdinalIgnoreCase))
                                {
                                    sqlparam.Add(paramName, new string[] { "" });
                                }
                                else
                                {
                                    sqlparam.Add(paramName, null);
                                }
                            }
                        }
                    }
                    totalSql = $"{setSql} SELECT COUNT({selectSql}) FROM ( {entity.DataValue} ) AS A {whereSql}";
                    dataSql = $"{setSql} SELECT {selectSql} FROM ( {entity.DataValue} ) AS A {whereSql} {(!string.IsNullOrWhiteSpace(orderbySql) ? $"ORDER BY {orderbySql}" : string.Empty) } LIMIT {offset} , {fetch}";
                    break;
            }
            MySqlConnection db = this.GetDbConnection(entity);
            int dataCount = db.QueryFirstOrDefault<int>(totalSql, sqlparam);
            reader = (dataCount, dataCount > 0 ? db.ExecuteReader(dataSql, sqlparam) : null);
            return reader;
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="dto">报表组件对象</param>
        /// <returns>保存结果</returns>
        private ResultDTO BeforeSave(TableDTO dto)
        {
            ResultDTO result = new ResultDTO();

            if (dto == null)
            {
                result.Message = "参数有误";
            }
            else if (string.IsNullOrWhiteSpace(dto.Code))
            {
                result.Message = "编码不能为空";
            }
            else if (string.IsNullOrWhiteSpace(dto.Name))
            {
                result.Message = "名称不能为空";
            }
            else if (DB.QueryFirstOrDefault<int>($"select count(id) from dc_component_table where code = @code {(dto.Id > 0 ? "and id <> @id" : string.Empty)}", new { id = dto.Id, code = dto.Code }) > 0)
            {
                result.Message = "编码重复";
            }
            else
            {
                result.Result = true;
            }

            return result;
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="id">ID</param>
        /// <returns>保存结果</returns>
        private ResultDTO BeforeSave(int[] id)
        {
            ResultDTO result = new ResultDTO();
            if (id == null || id.Length == 0 || id.Contains(0))
            {
                result.Message = "ID不能为空";
            }
            else
            {
                result.Result = true;
            }
            return result;
        }
    }
}
