﻿using Bailun.DC.Common;
using Bailun.DC.Models.Component.DTO;
using Bailun.DC.Models.Component.Entity;
using Bailun.DC.Models.Component.Enum;
using Dapper;
using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Qiniu.Http;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Bailun.DC.Services.Component
{
    /// <summary>
    /// 查询组件
    /// </summary>
    public class OfflineDownloadService : BaseService
    {

        public ResultDTO Export(OfflineQueryFilterDTO queryFilter, string cookies)
        {
            ResultDTO<int?> result = default(ResultDTO<int?>);
            TableService service = new TableService();
            TableDTO entity = service.Get(queryFilter.Code);
            if (entity != null)
            {
                string name = !string.IsNullOrWhiteSpace(queryFilter.Name) ? queryFilter.Name.Trim() : $"{string.Join(string.Empty, entity.ListCrumb)}_{DateTime.Now.ToString("yyyyMMddhhmm")}";
                result = this.Save(queryFilter, name, cookies);
                if (result?.Result == true)
                {
                    Task task = Task.Factory.StartNew(() =>
                    {
                        var exportResult = service.Export(queryFilter);
                        if (exportResult.Item2 != null && exportResult.Item2?.Length > 0)
                        {
                            string suffix = exportResult.Item1.Substring(exportResult.Item1.IndexOf("."));
                            var accesskey = NewConfigHelper.GetByName("QiNiu:AccessKey");
                            var secretkey = NewConfigHelper.GetByName("QiNiu:SecretKey");
                            var qiuniu = new QiNiuHelper(accesskey, secretkey);
                            HttpResult httpResult = qiuniu.UploadStream(exportResult.Item2, $"{name}{suffix}");
                            if (httpResult.Code == 200)
                            {
                                this.Save(result.Data.Value, suffix, $"http://dcfile.blsct.com/{name}{suffix}", OfflineDownloadStatusEnum.Complete, null);
                            }
                            else
                            {
                                this.Save(result.Data.Value, suffix, $"http://dcfile.blsct.com/{name}{suffix}", OfflineDownloadStatusEnum.Fail, $"{httpResult.RefText}_{httpResult.Text}");
                            }
                        }
                        else
                        {
                            this.Save(result.Data.Value, null, null, OfflineDownloadStatusEnum.Fail, "无数据导出");
                        }
                    });
                }
            }
            else
            {
                result = new ResultDTO<int?>() { Message = "参数异常" };
            }

            return result;
        }

        public ResultDTO ReExport(int[] id, string cookies = null)
        {
            ResultDTO result = this.BeforeSave(id);
            if (result.Result)
            {
                using (var db = DB)
                {
                    string sql = "select * from dc_component_offline_download where id in @id";
                    IList<dc_component_offline_download> list = db.Query<dc_component_offline_download>(sql, new { id = id }).ToList();
                    if (list?.Count > 0)
                    {
                        list.ForEach((l, i) =>
                        {
                            OfflineQueryFilterDTO queryFilter = new OfflineQueryFilterDTO()
                            {
                                Id = l.id,
                                Code = l.code,
                                Name = l.name,
                                ListFilter = JsonConvert.DeserializeObject<IList<FieldFilterDTO>>(l.filter)
                            };
                            this.Export(queryFilter, cookies);
                        });
                    }
                }
            }
            else
            {
                result = new ResultDTO<int?>() { Message = "参数异常" };
            }

            return result;
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="dto">报表组件对象</param>
        /// <returns>保存结果</returns>
        public ResultDTO<int?> Save(OfflineQueryFilterDTO queryFilter, string name, string cookies)
        {
            ResultDTO<int?> result = this.BeforeSave(queryFilter, cookies);

            if (result.Result)
            {
                dc_component_offline_download entity = new dc_component_offline_download()
                {
                    id = queryFilter.Id ?? 0,
                    code = queryFilter.Code,
                    name = name,
                    gmt_create_time = DateTime.Now,
                    gmt_modified_time = DateTime.Now,
                    status = OfflineDownloadStatusEnum.Executing,
                    filter = JsonConvert.SerializeObject(queryFilter.ListFilter)
                };
                JObject json = default(JObject);
                if (!string.IsNullOrWhiteSpace(cookies))
                {
                    var user = HttpHelper.NetHelper.Request("http://sso.bailuntec.com/GetUserResource", new string[] { "Authorization" }, new string[] { cookies });
                    json = JObject.Parse(user);
                }
                if (json != null && json["statusCode"].ToString() == "200" && json["result"]["success"].ToString().ToLower() == "true")
                {
                    entity.gmt_create_userid = int.TryParse(json["result"]["OaUserId"].ToString(), out int userid) ? userid : 0;
                    entity.gmt_create_username = json["result"]["Account"].ToString() ?? "系统";
                }
                else
                {
                    entity.gmt_create_userid = 0;
                    entity.gmt_create_username = "系统";
                }
                using (var db = DB)
                {
                    //开启事务
                    MySqlTransaction transaction = db.BeginTransaction();
                    try
                    {
                        result.Data = entity.id > 0 ? (db.Update(entity) > 0 ? entity.id : 0) : db.Insert(entity);
                        result.Result = result.Data > 0;
                        if (result.Result)
                        {
                            //提交事务
                            transaction.Commit();
                            result.Message = "保存成功";
                        }
                        else
                        {
                            //回滚事务
                            transaction.Rollback();
                            result.Message = "保存失败";
                        }
                    }
                    catch (Exception ex)
                    {
                        //回滚事务
                        transaction.Rollback();
                        result.Message = ex.Message;
                        result.Result = false;
                    }
                }
            }

            return result;
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="id">ID</param>
        /// <param name="is_delete">是否删除</param>
        /// <returns>保存结果</returns>
        public ResultDTO Save(int[] id, bool is_delete)
        {
            ResultDTO result = this.BeforeSave(id);

            if (result.Result)
            {
                string sql = "update dc_component_offline_download set is_delete = @is_delete, gmt_modified_time = @gmt_modified_time where id in @id";
                using (var db = DB)
                {
                    //开启事务
                    MySqlTransaction transaction = db.BeginTransaction();
                    try
                    {
                        int resultCount = db.Execute(sql, new { id = id, is_delete = is_delete, gmt_modified_time = DateTime.Now });
                        if (resultCount == 0)
                        {
                            throw new Exception("保存失败");
                        }
                        else
                        {
                            //提交事务
                            transaction.Commit();
                            result.Message = "保存成功";
                        }
                    }
                    catch (Exception ex)
                    {
                        //回滚事务
                        transaction.Rollback();
                        result.Message = ex.Message;
                        result.Result = false;
                    }
                }
            }

            return result;
        }

        /// <summary>
        /// 保存
        /// </summary>
        /// <param name="id">ID</param>
        /// <param name="suffix">后缀</param>
        /// <param name="url">地址</param>
        /// <param name="status">状态</param>
        /// <param name="message">信息</param>
        /// <returns>保存结果</returns>
        public ResultDTO Save(int id, string suffix, string url, OfflineDownloadStatusEnum status, string message)
        {
            ResultDTO result = this.BeforeSave(new int[] { id });

            if (result.Result)
            {
                string sql = "update dc_component_offline_download set suffix = @suffix, url = @url, status = @status,message = @message, gmt_modified_time = @gmt_modified_time where id = @id";
                using (var db = DB)
                {
                    //开启事务
                    MySqlTransaction transaction = db.BeginTransaction();
                    try
                    {
                        int resultCount = db.Execute(sql, new { id = id, suffix = suffix, url = url, status = status, message = message, gmt_modified_time = DateTime.Now });
                        if (resultCount == 0)
                        {
                            result.Message = "保存失败";
                            result.Result = false;
                        }
                        else
                        {
                            //提交事务
                            transaction.Commit();
                            result.Message = "保存成功";
                        }
                    }
                    catch (Exception ex)
                    {
                        //回滚事务
                        transaction.Rollback();
                        result.Message = ex.Message;
                        result.Result = false;
                    }
                }
            }

            return result;
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="dto">报表组件对象</param>
        /// <returns>保存结果</returns>
        private ResultDTO<int?> BeforeSave(OfflineQueryFilterDTO queryFilter, string cookies)
        {
            ResultDTO<int?> result = new ResultDTO<int?>();

            if (queryFilter == null)
            {
                result.Message = "参数有误";
            }
            else if (string.IsNullOrWhiteSpace(queryFilter.Code))
            {
                result.Message = "编码不能为空";
            }
            else
            {
                result.Result = true;
            }

            return result;
        }

        /// <summary>
        /// 保存报表组件
        /// </summary>
        /// <param name="id">ID</param>
        /// <returns>保存结果</returns>
        private ResultDTO BeforeSave(int[] id)
        {
            ResultDTO result = new ResultDTO();
            if (id == null || id.Length == 0 || id.Contains(0))
            {
                result.Message = "ID不能为空";
            }
            else
            {
                result.Result = true;
            }
            return result;
        }
    }
}
