﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    public class dc_base_finance_fee
    {
        /// <summary>
        /// 费用单表 id
        /// </summary>
        public int id { get; set; }


        /// <summary>
        /// 计划编号
        /// </summary>
        public string cost_plan_no { get; set; }


        /// <summary>
        /// 费用单编号
        /// </summary>
        public string cost_no { get; set; }


        /// <summary>
        /// 付款理由
        /// </summary>
        public string cost_reason { get; set; }


        /// <summary>
        /// 费用类 1付款  2收款  3借支/借还
        /// </summary>
        public int? cost_form { get; set; }


        /// <summary>
        /// 主体编号
        /// </summary>
        public string company_no { get; set; }


        /// <summary>
        /// 主体名称
        /// </summary>
        public string company_name { get; set; }


        /// <summary>
        /// 大类编号
        /// </summary>
        public string type_no { get; set; }


        /// <summary>
        /// 大类标题
        /// </summary>
        public string type_name { get; set; }


        /// <summary>
        /// 小类编号
        /// </summary>
        public string kind_no { get; set; }


        /// <summary>
        /// 小类标题
        /// </summary>
        public string kind_name { get; set; }


        /// <summary>
        /// 创建人 id
        /// </summary>
        public int? create_userid { get; set; }


        /// <summary>
        /// 创建人编号
        /// </summary>
        public string create_usercode { get; set; }


        /// <summary>
        /// 创建人名称
        /// </summary>
        public string create_username { get; set; }


        /// <summary>
        /// 费用单备注
        /// </summary>
        public string cost_remark { get; set; }


        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime? create_time { get; set; }


        /// <summary>
        /// 费用单状态 0 待提交 1待审核 2待出纳付款 3被驳回 4已支付 5已作废
        /// </summary>
        public int? cost_status { get; set; }


        /// <summary>
        /// 文件地址
        /// </summary>
        public string file_path { get; set; }


        /// <summary>
        /// 补充材料地址
        /// </summary>
        public string mor_file_path { get; set; }


        /// <summary>
        /// 费用总金额
        /// </summary>
        public decimal? amount { get; set; }


        /// <summary>
        /// 收款/付款银行（或支付宝）
        /// </summary>
        public string bank_name { get; set; }


        /// <summary>
        /// 收款/付款账号
        /// </summary>
        public string bank_card { get; set; }


        /// <summary>
        /// 收款/付款人（创建人）
        /// </summary>
        public string bank_card_user { get; set; }


        /// <summary>
        /// 收款/付款单位
        /// </summary>
        public string bank_company { get; set; }


        /// <summary>
        /// 补充信息
        /// </summary>
        public string mor_remark { get; set; }


        /// <summary>
        /// 关联子单
        /// </summary>
        public string son_cost_no { get; set; }


        /// <summary>
        /// 关联父单
        /// </summary>
        public string sup_cost_no { get; set; }


        /// <summary>
        /// 1 借支 2 借还
        /// </summary>
        public int? is_lend { get; set; }


        /// <summary>
        /// 借支单已还金额
        /// </summary>
        public decimal? had_pay { get; set; }


        /// <summary>
        /// 借支单状态 1 未还 2 部分还款  3 待补差额  4 结清
        /// </summary>
        public int? lend_status { get; set; }


        /// <summary>
        /// 借支单补偿金额
        /// </summary>
        public decimal? compensate { get; set; }


        /// <summary>
        /// 借还单冲销金额
        /// </summary>
        public decimal? counteract { get; set; }


        /// <summary>
        /// 借还单余额
        /// </summary>
        public decimal? lend_balance { get; set; }


        /// <summary>
        /// 驳回理由
        /// </summary>
        public string reject_reason { get; set; }


        /// <summary>
        /// 币种
        /// </summary>
        public string dic { get; set; }


        /// <summary>
        /// 借还单冲销金额 ( 支付币种 )
        /// </summary>
        public decimal? pay_counteract { get; set; }


        /// <summary>
        /// 借还单余额 （ 支付币种 ）
        /// </summary>
        public decimal? pay_lend_balance { get; set; }


        /// <summary>
        /// 计划金额 （ 支付币种 ）
        /// </summary>
        public decimal? pay_plan_amount { get; set; }


        /// <summary>
        /// 支付币种
        /// </summary>
        public string pay_dic { get; set; }


        /// <summary>
        /// 汇率
        /// </summary>
        public decimal? pay_cur { get; set; }


        /// <summary>
        /// 0 不抵扣个税  1 抵扣个税
        /// </summary>
        public int? is_tax { get; set; }


        /// <summary>
        /// 出纳系统 detailKey
        /// </summary>
        public string detail_key { get; set; }


        /// <summary>
        /// 支付者用户id
        /// </summary>
        public int? pay_user_id { get; set; }


        /// <summary>
        /// 支付时间
        /// </summary>
        public DateTime? pay_time { get; set; }


        /// <summary>
        /// 人民币总金额
        /// </summary>
        public decimal? amount_rmb { get; set; }


        /// <summary>
        /// xx货币转人民币汇率
        /// </summary>
        public decimal? to_rmb_rate { get; set; }


        /// <summary>
        /// 
        /// </summary>
        public int? sub_logistics_supplier_id { get; set; }


        /// <summary>
        /// 
        /// </summary>
        public int? logistics_supplier_id { get; set; }


        /// <summary>
        /// 科目编号
        /// </summary>
        public string subject_code { get; set; }


        /// <summary>
        /// 公司主体value
        /// </summary>
        public int? company_value { get; set; }


        /// <summary>
        /// 财务审核时间
        /// </summary>
        public DateTime? audit_time { get; set; }


        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime? last_modify_date { get; set; }


        /// <summary>
        /// 数据中心创建时间
        /// </summary>
        public DateTime bj_create { get; set; }


        /// <summary>
        /// 
        /// </summary>
        public DateTime bj_modified { get; set; }

        public string project_type { get; set; }

        public string customer_num { get; set; }

        public string accounting_subject_name { get; set; }

        /// <summary>
        /// 是否管理成本
        /// </summary>
        public int? is_manage_cost { get; set; }

        /// <summary>
        /// 部门名称
        /// </summary>
        public string department_name { get; set; }

        /// <summary>
        /// 所属项目
        /// </summary>
        public string project { get; set; }

        /// <summary>
        /// 所属账期
        /// </summary>
        public DateTime? project_date { get; set; }
    }
}
