﻿using Bailun.DC.Models.Dtos.Stock;
using System;
using System.ComponentModel;

namespace Bailun.DC.Models.Stock
{
    /// <summary>
    /// wms库存流水记录
    /// </summary>
    public class dc_base_wms_stock_flow
    {
        public dc_base_wms_stock_flow()
        {

        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="productStockFlow"></param>
        public dc_base_wms_stock_flow(ProductStockFlowApiResponseDto productStockFlow)
        {
            sys_serial_number = productStockFlow.SysSerialNumber;
            bailun_sku = productStockFlow.Sku;
            change_quantity = productStockFlow.ChangeQuantity;
            warehouse_code = productStockFlow.WarehouseCode;
            warehouse_name = productStockFlow.WarehouseName;
            third_sys_order_no = productStockFlow.ThirdSysOrderNo;
            third_sys_order_type = productStockFlow.ThirdSysOrderType;
            system_source = productStockFlow.SystemSource;
            target_ware_no = productStockFlow.TargetWareNo;
            target_ware_name = productStockFlow.TargetWareName;
            availabel_stock = productStockFlow.AvailabelStock;
            on_hand_stock = productStockFlow.OnHandStock;
            in_bound_stock = productStockFlow.InboundStock;
            order_creation_time = productStockFlow.OrderCreationTime;
            create_user_name = productStockFlow.CreateUserName;
            wms_creation_time = productStockFlow.CreationTime;
            create_time = DateTime.Now;
        }

        /// <summary>
        /// id
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 系统交易单号
        /// </summary>
        public string sys_serial_number { get; set; }

        /// <summary>
        /// 百伦SKU
        /// </summary>
        public string bailun_sku { get; set; }

        /// <summary>
        /// 变更数量
        /// </summary>
        public int change_quantity { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 第三方单号类型
        /// </summary>
        public string third_sys_order_no { get; set; }

        /// <summary>
        /// 第三方单号类型
        /// </summary>
        public ThirdSysOrderType third_sys_order_type { get; set; }

        /// <summary>
        /// 数据来源
        /// </summary>
        public StockFlowSystemSource system_source { get; set; }

        /// <summary>
        /// 目的仓库编码
        /// </summary>
        public string target_ware_no { get; set; }

        /// <summary>
        /// 目的仓库名称
        /// </summary>
        public string target_ware_name { get; set; }

        /// <summary>
        /// 可用库存
        /// </summary>
        public int availabel_stock { get; set; }

        /// <summary>
        /// 现有库存量
        /// </summary>
        public int on_hand_stock { get; set; }

        /// <summary>
        /// 在途库存数
        /// </summary>
        public int in_bound_stock { get; set; }

        /// <summary>
        /// 第三方单号创建时间
        /// </summary>
        public DateTime order_creation_time { get; set; }

        /// <summary>
        /// 创建人姓名
        /// </summary>
        public string create_user_name { get; set; }

        /// <summary>
        /// wms库存流水创建时间
        /// </summary>
        public DateTime wms_creation_time { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime create_time { get; set; }

    }

    /// <summary>
    /// 库存交易流水第三方单号类型
    /// </summary>
    public enum ThirdSysOrderType
    {
        /// <summary>
        /// FBA调拨单出库
        /// </summary>
        [Description("FBA调拨单出库")]
        AllotFbaOut = 1,
        /// <summary>
        /// FBA调拨单入库
        /// </summary>
        [Description("FBA调拨单入库")]
        AllotFbaPut = 2,
        /// <summary>
        /// 普通调拨单出库
        /// </summary>
        [Description("普通调拨单出库")]
        AllotOrdinaryOut = 3,
        /// <summary>
        /// 普通调拨单入库
        /// </summary>
        [Description("普通调拨单入库")]
        AllotOrdinaryPut = 4,
        /// <summary>
        /// 调拨单退货
        /// </summary>
        [Description("调拨单退货")]
        AllotIntercept = 5,
        /// <summary>
        ///采购入库
        /// </summary>
        [Description("采购入库")]
        Purchase = 6,
        /// <summary>
        /// OMS配货单
        /// </summary>
        [Description("OMS配货单")]
        OMS = 7,
        /// <summary>
        /// 盘亏
        /// </summary>
        [Description("盘亏")]
        InventoryLoss = 8,
        /// <summary>
        /// 盘盈
        /// </summary>
        [Description("盘盈")]
        InventorySurplus = 9,
        /// <summary>
        /// OMS退货单
        /// </summary>
        [Description("OMS退货单")]
        OMSReturnOrder = 10,
        /// <summary>
        /// WFS调拨单出库
        /// </summary>
        [Description("WFS调拨单出库")]
        AllotWfsOut = 11,
        /// <summary>
        /// WFS调拨单入库
        /// </summary>
        [Description("WFS调拨单入库")]
        AllotWfsPut = 12,
    }

    /// <summary>
    /// 库存流水数据来源系统
    /// </summary>
    public enum StockFlowSystemSource
    {
        /// <summary>
        /// 调拨系统
        /// </summary>
        [Description("调拨系统")]
        Allot = 1,
        /// <summary>
        /// OMS系统
        /// </summary>
        [Description("OMS系统")]
        OMS = 2,
        [Description("采购系统")]
        Purchase = 3,
        /// <summary>
        /// WMS系统
        /// </summary>
        [Description("WMS系统")]
        WMS = 4
    }
}
