﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Report
{
    /// <summary>
    /// 平台的凭证对应配置
    /// </summary>
    public class mPlatformAccountingSetting
    {
        /// <summary>
        /// 平台类型
        /// </summary>
        public string platform_type { get; set; }

        /// <summary>
        /// 凭证ID
        /// </summary>
        public string cert_id { get; set; }

        /// <summary>
        /// 制单人
        /// </summary>
        public string creator { get; set; }

        /// <summary>
        /// 科目编码
        /// </summary>
        public string subject_no { get; set; }

        /// <summary>
        /// 客户编码
        /// </summary>
        public string customer_no { get; set; }

        /// <summary>
        /// 站点
        /// </summary>
        public string website { get; set; }


        /// <summary>
        /// 币种
        /// </summary>
        public string currency { get; set; }

        /// <summary>
        /// 币种名称
        /// </summary>
        public string currencyname { get; set; }

        public string text { get; set; }

        /// <summary>
        /// 项目编码
        /// </summary>
        public string projectno { get; set; }
    }

    
    /// <summary>
    /// 财务分类科目编码对应配置
    /// </summary>
    public class mFinanceCategorySubjectNo
    {
        /// <summary>
        /// 财务分类名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 科目编码
        /// </summary>
        public string subject_no { get; set; }
    }

    /// <summary>
    /// 获取资金系统每月的汇率
    /// </summary>
    public class mFundExchangRate
    {
        public string currency { get; set; }

        public decimal? exchange_rate { get; set; }
    }

    public class FundExchangRate_Response
    {
        public int code { get; set; }

        public string msg { get; set; }

        public int count { get; set; }

        public List<mFundExchangRate> data { get; set; }
    }
}
