﻿using System.ComponentModel;

namespace Bailun.DC.Models.Component.Enum
{
    /// <summary>
    /// 状态：0：未执行, 1：执行中, 2：完成, 3：失败
    /// </summary>
    public enum OfflineDownloadStatusEnum
    {
        /// <summary>
        /// 未执行
        /// </summary>
        [Description("未执行")]
        UnExecuted = 0,
        /// <summary>
        /// 执行中
        /// </summary>
        [Description("执行中")]
        Executing = 1,
        /// <summary>
        /// 完成
        /// </summary>
        [Description("完成")]
        Complete = 2,
        /// <summary>
        /// 失败
        /// </summary>
        [Description("失败")]
        Fail = 3,
    }
}
