﻿using Bailun.DC.Models.Component.Enum;
using Dapper;
using System;

namespace Bailun.DC.Models.Component.Entity
{
    /// <summary>
    /// 字典组件
    /// </summary>
    public class dc_component_dictionary
    {
        /// <summary>
        /// ID
        /// </summary>
        public int id { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string name { get; set; }

        /// <summary>
        /// 编码
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 分类：1：数据源
        /// </summary>
        public DictionaryCategoryEnum? category { get; set; }

        /// <summary>
        /// 类型：1：SQL 2:配置
        /// </summary>
        public DictionaryTypeEnum? type { get; set; }

        /// <summary>
        /// 方法：get;post;
        /// </summary>
        public string method { get; set; }

        /// <summary>
        /// 值
        /// </summary>
        public string value { get; set; }

        /// <summary>
        /// 数据库：1: 数据中心， 2: 交易流水
        /// </summary>
        public DBEnum? data_db { get; set; }

        /// <summary>
        /// 是否删除: 1:是; 0:否
        /// </summary>
        [IgnoreUpdate]
        public bool is_delete { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        [IgnoreUpdate]
        public DateTime gmt_create { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime gmt_modified { get; set; }
    }
}
