﻿using System.Collections.Generic;

namespace Bailun.DC.Models.Component.DTO
{
    /// <summary>
    /// 查询条件
    /// </summary>
    public class QueryFilterDTO
    {
        /// <summary>
        /// 编码
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 当前页
        /// </summary>
        public int? CurrentPage { get; set; }

        /// <summary>
        /// 每页数量
        /// </summary>
        public int? PageSize { get; set; }

        /// <summary>
        /// 字段过虑条件
        /// </summary>
        public IList<FieldFilterDTO> ListFilter { get; set; }

        /// <summary>
        /// 字段排序
        /// </summary>
        public IList<FieldOrderDTO> ListOrder { get; set; }

        /// <summary>
        /// 查询字段
        /// </summary>
        public IList<FieldOrderDTO> ListField { get; set; }
    }

    /// <summary>
    /// 离线查询条件
    /// </summary>
    public class OfflineQueryFilterDTO : QueryFilterDTO
    {
        /// <summary>
        /// ID
        /// </summary>
        public int? Id { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }
    }
}