﻿using System.Collections.Generic;

namespace Bailun.DC.Models.Component.DTO
{
    public class FormDTO
    {
        /// <summary>
        /// Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 编码
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// 宽度
        /// </summary>
        public int? Width { get; set; }

        /// <summary>
        /// 标签宽度
        /// </summary>
        public int? LabelWidth { get; set; }

        /// <summary>
        /// 是否显示边框
        /// </summary>
        public bool? IsShowBorder { get; set; }

        /// <summary>
        /// 是否显示保存按钮 (默认:是)
        /// </summary>
        public bool? IsShowSaveButton { get; set; }

        /// <summary>
        /// 保存按钮文本 (默认:保存)
        /// </summary>
        public string SaveButtonText { get; set; }

        /// <summary>
        /// 是否显示取消按钮 (默认:是)
        /// </summary>
        public bool? IsShowCancelButton { get; set; }

        /// <summary>
        /// 取消按钮文本 (默认:保存)
        /// </summary>
        public string CancelButtonText { get; set; }

        /// <summary>
        /// flex布局下的水平排列方式：(默认center)
        /// </summary>
        public string Justify { get; set; }

        /// <summary>
        /// 提交时验证表单：(默认验证)
        /// </summary>
        public bool? IsValidate { get; set; }

        /// <summary>
        /// 是否可以移动：(默认可以)
        /// </summary>
        public bool? IsDrag { get; set; }

        /// <summary>
        /// 保存脚本
        /// </summary>
        public string SaveScript { get; set; }

        /// <summary>
        /// 自定义脚本
        /// </summary>
        public string javascript { get; set; }

        /// <summary>
        /// 操作列值
        /// </summary>
        public IEnumerable<dynamic> ListFormItem { get; set; }

        /// <summary>
        /// 操作列值
        /// </summary>
        public IEnumerable<dynamic> ListControl { get; set; }

        /// <summary>
        /// Scripts引用
        /// </summary>
        public IEnumerable<string> ListJavascriptSrc { get; set; }
    }
}
