﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Common.Page
{
    /// <summary>
    /// 分页返回值
    /// </summary>
    /// <typeparam name="TData"></typeparam>
    public class PageResult<TData> where TData : IList
    {
        /// <summary>
        /// 每页行数
        /// </summary>
        public int Rows
        {
            get
            {
                if (Data != null)
                {
                    return Data.Count;
                }

                return 0;
            }
        }
        public bool IsSuccess
        {
            get;
            set;
        } = true;

        public TData Data
        {
            get;
            set;
        }
        public int PageIndex
        {
            get;
            set;
        }
        public long Total
        {
            get;
            set;
        }

        public long TotalPage
        {
            get
            {
                if (Total > 0)
                {
                    return (Total % Rows == 0L) ? (Total / Rows) : (Total / Rows + 1);
                }

                return 0L;
            }
        }

        /// <summary>
        /// 构造返回值
        /// </summary>
        /// <param name="pageIndex">当前页</param>
        /// <param name="records">总条数</param>
        /// <param name="data">分页数据</param>
        /// <returns></returns>
        public PageResult<TData> ToPageResult(int pageIndex, long records, TData data)
        {
            return new PageResult<TData>
            {
                Data = data,
                PageIndex = pageIndex,
                Total = records,
            };
        }
    }
}
