﻿using System;
using System.Collections.Generic;
using System.Text;
using MySql.Data.MySqlClient;
using Dapper;
using Bailun.DC.Models;
using Bailun.DC.Common;
using System.Threading;
using Microsoft.Extensions.Hosting;
using System.Threading.Tasks;
using System.Linq;
using Bailun.DC.Services.WebApiService;

namespace Bailun.DC.ExportTask
{
    public class Services : BackgroundService
    {

        private Timer _timer;
        private bool Run;//等待上一个任务执行完成才能执行新的任务

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            if (!Run)
            {
                try
                {
                    Run = true;
                    new FinanceService().SyncExprotTask();
                }
                catch (Exception ex)
                {
                    Console.WriteLine($"同步月销售利润错误，堆栈信息：{ex.Message}");
                }
                finally
                {
                    Run = false;
                }
            }
        }
    }
}
