﻿using Microsoft.Extensions.Hosting;
using MySql.Data.MySqlClient;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Dapper;

namespace Bailun.DC.DailyPurchaseOnWay
{
    public class Services : BackgroundService
    {
        private Timer _timer;

        protected override Task ExecuteAsync(CancellationToken stoppingToken)
        {
            _timer = new Timer(DoWork, null, TimeSpan.Zero, TimeSpan.FromMinutes(1));
            return Task.CompletedTask;
        }

        private void DoWork(object state)
        {
            try
            {
                var now = DateTime.Now;

                if (now.Hour == 23 && now.Minute == 59)  //凌晨23：59分启动
                {
                    Console.WriteLine("开始启动 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                    var start = DateTime.Parse(now.ToShortDateString());

                    Init(start);

                    Console.WriteLine("任务运行完成 " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        public void Init(DateTime day)
        {
            using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
            {
                if (cn.State == System.Data.ConnectionState.Closed)
                {
                    cn.Open();
                }

                cn.Execute("delete from dc_daily_purchase_detail_onway where day='" + day.ToString("yyyy-MM-dd") + "'");

                var sql = $@"insert dc_daily_purchase_detail_onway(purchase_id, bailun_sku, warehouse_from_code, warehouse_from_name, create_time, quantity_purchase, quantity_inbound,
                          status, createusername, isaims, day)
                          select t1.purchase_id,t1.bailun_sku,t1.warehouse_from_code,t1.warehouse_from_name,t1.create_time,t1.quantity_purchase,t1.quantity_inbound,t1.`status`,t1.createusername,t1.isaims,'{day.ToString("yyyy-MM-dd")}' from dc_base_purchase_details t1 where t1.`status`>=0 and t1.quantity_inbound<t1.quantity_purchase and t1.`status`!=4";

                cn.Execute(sql);

                var count = cn.QueryFirstOrDefault<int?>("select count(id) from dc_daily_purchase_detail_onway where day='" + day.ToString("yyyy-MM-dd") + "'");
                Console.WriteLine("采购单SKU在途数量：" + (count ?? 0));

            }
        }

        public void temp(DateTime day)
        {
            try
            {
                var sql = $@"insert into dc_mid_skuwarehouse_sales_2019
                        select * from dc_mid_skuwarehouse_sales where day>='{day.ToString("yyyy-MM-dd")}' and day<'{day.AddDays(1).ToString("yyyy-MM-dd")}';";

                using (var cn = new MySqlConnection(Common.GlobalConfig.ConnectionString_Data))
                {
                    if (cn.State == System.Data.ConnectionState.Closed)
                    {
                        cn.Open();
                    }

                    var result = 0;//cn.Execute(sql);

                    //Console.WriteLine(day.ToString("yyyy-MM-dd") + " 受影响行数：" + result+"  -- "+DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));

                    //删除旧表
                    result = cn.Execute($"delete from dc_mid_skuwarehouse_sales where day='{day.ToString("yyyy-MM-dd")}'",null,null,6*60);
                    Console.WriteLine(day.ToString("yyyy-MM-dd") + " 受影响行数：" + result + "  -- " + DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"));
                }
            }
            catch (Exception ex)
            {
                temp(day);
            }

            

        }

    }
}
