﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// 月度利润报表
    /// </summary>
    public class dc_month_sale_profit
    {
        /// <summary>
		/// auto_increment
        /// </summary>		
        public int id { get; set; }

        /// <summary>
        /// 年月
        /// </summary>		
        public string month { get; set; }

        /// <summary>
        /// 销售额
        /// </summary>		
        public decimal amount_sale { get; set; }

        /// <summary>
        /// 成本
        /// </summary>		
        public decimal cost_sale { get; set; }

        /// <summary>
        /// 成本（导入）
        /// </summary>
        public decimal cost_sale_ { get; set; }

        /// <summary>
        /// 平台扣费及退款
        /// </summary>		
        public decimal pt_count { get; set; }

        /// <summary>
        /// 平台费
        /// </summary>		
        public decimal pt_platformfee { get; set; }

        /// <summary>
        /// Ebay刊登费
        /// </summary>		
        public decimal pt_ebay_postingfee { get; set; }

        /// <summary>
        /// Paypal费用
        /// </summary>		
        public decimal pt_paypal_fee { get; set; }

        /// <summary>
        /// 平台的物流费
        /// </summary>		
        public decimal pt_platform_logistics_fee { get; set; }

        /// <summary>
        /// 平台的物流费（导入）
        /// </summary>
        public decimal pt_platform_logistics_fee_ { get; set; }

        /// <summary>
        /// 广告及宣传费-订阅费
        /// </summary>		
        public decimal pt_platform_ad_subscribe_fee { get; set; }

        /// <summary>
        /// 广告及宣传费-订阅费（导入）
        /// </summary>
        public decimal pt_platform_ad_subscribe_fee_ { get; set; }

        /// <summary>
        /// 平台的仓储费
        /// </summary>		
        public decimal pt_platform_storage_fee { get; set; }

        /// <summary>
        /// 退款
        /// </summary>		
        public decimal pt_refund_amount { get; set; }

        /// <summary>
        /// 回款
        /// </summary>		
        public decimal pt_incoming { get; set; }

        /// <summary>
        /// 物流仓储费用
        /// </summary>		
        public decimal ls_count { get; set; }

        /// <summary>
        /// 头程运输
        /// </summary>		
        public decimal ls_head_cost { get; set; }

        /// <summary>
        /// 头程运输（导入）
        /// </summary>
        public decimal ls_head_cost_ { get; set; }

        /// <summary>
        /// 尾程运输
        /// </summary>		
        public decimal ls_tail_cost { get; set; }

        /// <summary>
        /// 尾程运输（导入）
        /// </summary>
        public decimal ls_tail_cost_ { get; set; }


        /// <summary>
        /// 海外仓仓储费
        /// </summary>		
        public decimal ls_oversea_storage { get; set; }

        /// <summary>
        /// 平台操作费
        /// </summary>		
        public decimal ls_platform_operation_fee { get; set; }

        /// <summary>
        /// 销售费用合计
        /// </summary>		
        public decimal sale_fee_count { get; set; }

        /// <summary>
        /// 销售利润
        /// </summary>		
        public decimal sale_profit { get; set; }

        /// <summary>
        /// 销售毛利率
        /// </summary>		
        public decimal sale_profit_rate { get; set; }

        /// <summary>
        /// 销售相关管理成本
        /// </summary>		
        public decimal sale_manager_cost { get; set; }

        /// <summary>
        /// 处理费
        /// </summary>		
        public decimal handlingcharges { get; set; }

        /// <summary>
        /// 直接支付的与销售平台相关费用
        /// </summary>		
        public decimal payfor_platform_related_fee { get; set; }

        /// <summary>
        /// 直接管理成本
        /// </summary>		
        public decimal direct_manager_cost { get; set; }

        /// <summary>
        /// 管理成本-香港百伦（不含直接支付的与销售平台相关的费用）
        /// </summary>		
        public decimal manager_cost_hkbailun { get; set; }

        /// <summary>
        /// 管理成本-广州百伦
        /// </summary>		
        public decimal manager_cost_gzbailun { get; set; }

        /// <summary>
        /// 管理成本-美甲店
        /// </summary>
        public decimal manager_cost_meijiadian { get; set; }

        /// <summary>
        /// 管理成本-成品仓（不含直接支付的与销售平台相关的费用）
        /// </summary>		
        public decimal manager_cost_finish_wh { get; set; }

        /// <summary>
        /// 财务费用
        /// </summary>		
        public decimal finance_fee { get; set; }

        /// <summary>
        /// 管理成本合计
        /// </summary>		
        public decimal manager_cost_count { get; set; }

        /// <summary>
        /// 营业利润
        /// </summary>		
        public decimal business_profit { get; set; }

        /// <summary>
        /// 营业毛利率
        /// </summary>		
        public decimal business_profit_rate { get; set; }

        /// <summary>
        /// 加：其他收入
        /// </summary>		
        public decimal other_incoming { get; set; }

        /// <summary>
        /// 加：营业外收入
        /// </summary>		
        public decimal nonbusiness_income { get; set; }

        /// <summary>
        /// 减：营业外支出
        /// </summary>		
        public decimal nonbusiness_pay { get; set; }

        /// <summary>
        /// 实际利润
        /// </summary>		
        public decimal actual_profit { get; set; }

        /// <summary>
        /// 分红
        /// </summary>		
        public decimal participation_in_profit { get; set; }

        /// <summary>
        /// 利润结余
        /// </summary>		
        public decimal balance_of_profit { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>		
        public DateTime createtime { get; set; }

        /// <summary>
        /// 更新时间
        /// </summary>		
        public DateTime lastupdatetime { get; set; }

        /// <summary>
        /// 最后更新人id
        /// </summary>		
        public int lastupdateuserid { get; set; }

        /// <summary>
        /// 最后更新人
        /// </summary>		
        public string lastupdateusername { get; set; }

    }
}
