﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models
{
    /// <summary>
    /// wish 广告费
    /// </summary>
    public class dc_base_finance_wish
    {
        /// <summary>
		/// 
        /// </summary>		
        public int id { get; set; }

        /// <summary>
        /// 广告系列id
        /// </summary>		
        public string campaign_id { get; set; }

        /// <summary>
        /// 广告系列的名称
        /// </summary>		
        public string campaign_name { get; set; }

        /// <summary>
        /// 其他转人民币汇率
        /// </summary>		
        public decimal other_to_cny_exchange_rate { get; set; }

        /// <summary>
        /// 其他转美元汇率
        /// </summary>		
        public decimal other_to_usd_exchange_rate { get; set; }

        /// <summary>
        /// 广告系列预算
        /// </summary>		
        public decimal campaign_max_budget { get; set; }

        /// <summary>
        /// 为true表示是一个自动广告系列
        /// </summary>		
        public int is_automated_campaign { get; set; }

        /// <summary>
        /// 为true则广告系列结束后自动续订
        /// </summary>		
        public int auto_renew { get; set; }

        /// <summary>
        /// 预算金额
        /// </summary>		
        public decimal scheduled_add_budget_amount { get; set; }

        /// <summary>
        /// 总展示次数
        /// </summary>		
        public int total_impressions { get; set; }

        /// <summary>
        /// 开始时间
        /// </summary>		
        public DateTime start_time { get; set; }

        /// <summary>
        /// 总销售量
        /// </summary>		
        public int sales { get; set; }

        /// <summary>
        /// 付费展示的总费用
        /// </summary>		
        public decimal total_impression_fees_charged { get; set; }

        /// <summary>
        /// 为true表示预算会定期自动添加到此广告系列
        /// </summary>		
        public int scheduled_add_budget_enabled { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public string merchant_id { get; set; }

        /// <summary>
        /// 印象费用细分
        /// </summary>		
        public string impression_fees_breakdown { get; set; }

        /// <summary>
        /// 广告状态
        /// </summary>		
        public string campaign_state { get; set; }

        /// <summary>
        /// 是否可编辑
        /// </summary>		
        public int can_edit { get; set; }

        /// <summary>
        /// 0-1之间的比率代表折扣
        /// </summary>		
        public decimal discount_ratio { get; set; }

        /// <summary>
        /// 为true表示此广告系列是Simple Boost广告系列
        /// </summary>		
        public int is_simple_boost { get; set; }

        /// <summary>
        /// 此广告系列的总费用 美元
        /// </summary>		
        public decimal total_campaign_spend { get; set; }

        /// <summary>
        /// 0-6，表示星期几的预算会自动添加到此广告系列中
        /// </summary>		
        public string scheduled_add_budget_days { get; set; }

        /// <summary>
        /// 广告系列的最后更新时间
        /// </summary>		
        public DateTime last_updated_time { get; set; }

        /// <summary>
        /// 结束时间
        /// </summary>		
        public DateTime end_time { get; set; }

        /// <summary>
        /// 注册费用
        /// </summary>		
        public decimal total_enrollment_fees_charged { get; set; }

        /// <summary>
        /// 总gmv
        /// </summary>		
        public decimal gmv { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public int account_id { get; set; }


        /// <summary>
        /// 帐号名称
        /// </summary>
        public string account_name { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public int company_id { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public DateTime gmt_create_time { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public DateTime gmt_modify_time { get; set; }

        /// <summary>
        /// 数据中心统计时间
        /// </summary>		
        public DateTime record_time { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public decimal daily_campaign_max_budget { get; set; }

        /// <summary>
        /// 每日广告产生的费用
        /// </summary>		
        public decimal daily_total_campaign_spend { get; set; }

        public decimal daily_total_campaign_spend_rmb { get; set; }

        /// <summary>
        /// 
        /// </summary>		
        public decimal daily_gmv { get; set; }

    }
}
