﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.Models.Stock
{
    public class mLogicWarehouse
    {
        public string hq_type { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouse_code { get; set; }

        /// <summary>
        /// 仓库名称
        /// </summary>
        public string warehouse_name { get; set; }

        /// <summary>
        /// 可用库存
        /// </summary>
        public int usable_stock { get; set; }

        /// <summary>
        /// 可用库存金额
        /// </summary>
        public decimal amount_stock { get; set; }

        /// <summary>
        /// 采购在途数
        /// </summary>
        public int? quantity_purchase { get; set; }

        /// <summary>
        /// 采购在途金额
        /// </summary>
        public decimal? purchase_amount { get; set; }

        /// <summary>
        /// 调拨在途数
        /// </summary>
        public int? quantity_transfer { get; set; }

        /// <summary>
        /// 调拨在途金额
        /// </summary>
        public decimal? amount_transit { get; set; }

        /// <summary>
        /// 未发货数
        /// </summary>
        public int? noshippingcount { get; set; }

        /// <summary>
        /// 缺货数
        /// </summary>
        public int? nostockcount { get; set; }

        /// <summary>
        /// 昨日销量
        /// </summary>
        public int? oneday_total_sales { get; set; }

        /// <summary>
        /// 昨日销售额
        /// </summary>
        public decimal? amount_onedaysale { get; set; }

        /// <summary>
        /// 过去7天销量
        /// </summary>
        public int? sevenday_total_sales { get; set; }

        /// <summary>
        /// 过去14天销量
        /// </summary>
        public int? fourteenday_total_sales { get; set; }

        /// <summary>
        /// 过去30天销量
        /// </summary>
        public int? thirtyday_total_sales { get; set; }

        /// <summary>
        /// 调出在途数
        /// </summary>
        public int? quantity_tuneout_onway { get; set; }

        /// <summary>
        /// 30天内调出数量
        /// </summary>
        public int? quantity_tuneout_30days { get; set; }

        /// <summary>
        /// 30天内调入数量
        /// </summary>
        public int? quantity_tunein_30days { get; set; }

        /// <summary>
        /// 30天现金流收入
        /// </summary>
        public decimal? cash_in_30days { get; set; }

        /// <summary>
        /// 30天现金流支出
        /// </summary>
        public decimal? cash_out_30days { get; set; }

        /// <summary>
        /// 30天现金流净值，收入-支出
        /// </summary>
        public decimal? cash_net { get; set; }

        /// <summary>
        /// 动销率，动销率=过去一个月卖出的SKU/SKU的库存金额
        /// </summary>
        public decimal? pin_rate_stock { get; set; }
    }
}
