﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.DC.AllotOrderDetail.Models
{
    public class AllotInfo
    {
        /// <summary>
        /// 调拨单id
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// 调拨单号
        /// </summary>
        public string Code { get; set; }
        /// <summary>
        /// 计划单号
        /// </summary>
        public string ScheduleCode { get; set; }
        /// <summary>
        /// ShipmentId
        /// </summary>
        public string ShipmentId { get; set; }
        /// <summary>
        /// 调拨单状态
        /// </summary>
        public int StateId { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public int AllocateCargoState { get; set; }
        
        /// <summary>
        /// 
        /// </summary>
        public string ShipmentStatus { get; set; }
        /// <summary>
        /// 发货仓库名称
        /// </summary>
        public string SourceWareName { get; set; }
        /// <summary>
        /// 起始仓库编码
        /// </summary>
        public string SourceWareNo { get; set; }
        /// <summary>
        /// 目的仓库编码
        /// </summary>
        public string TargetWareNo { get; set; }
        /// <summary>
        /// 目的仓名称
        /// </summary>
        public string TargetWareName { get; set; }
        /// <summary>
        /// 发货要求
        /// </summary>
        public string SendRequire { get; set; }
        /// <summary>
        /// 创建人
        /// </summary>
        public string CreateUserName { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreationTime { get; set; }
        /// <summary>
        /// 商品类型
        /// </summary>
        public string ProductType { get; set; }
        /// <summary>
        /// 调拨类型
        /// </summary>
        public int ScheduleType { get; set; }

        /// <summary>
        /// 调拨类型(1-fba调拨单，2-普通调拨单)
        /// </summary>
        public int TransferType { get; set; }

        /// <summary>
        /// 采购单号
        /// </summary>
        public string PurchaseCode { get; set; }
        /// <summary>
        /// 目的仓地址
        /// </summary>
        public string TargetWareAddress { get; set; }
        /// <summary>
        /// 特殊问题
        /// </summary>
        public string SpecialProblem { get; set; }
        /// <summary>
        /// 预计到货时间
        /// </summary>
        public DateTime ExpectArrivalTime { get; set; }
        /// <summary>
        /// 运输方式
        /// </summary>
        public string TransportType { get; set; }

        /// <summary>
        /// 是否锁仓
        /// </summary>
        public bool IsLockedPosition { get; set; }

        /// <summary>
        /// 入库单号
        /// </summary>
        public string ReceiptNo { get; set; }


        /// <summary>
        /// 物流编码
        /// </summary>
        public string LogisticsCode { get; set; }

        /// <summary>
        /// 物流名称
        /// </summary>
        public string LogisticsName { get; set; }

        /// <summary>
        /// 打包要求
        /// </summary>
        public string PackRequirements { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public List<AllotOrderProductItemOutputDto> AllotOrderProducts { get; set; }

        /// <summary>
        /// 最后更新时间戳
        /// </summary>
        public DateTime TimeStamp { get; set; }

        /// <summary>
        /// 是否异常
        /// </summary>
        public bool IsException { get; set; }

        /// <summary>
        /// 是否已删除
        /// </summary>
        public bool IsDeleted { get; set; }


        /// <summary>
        /// 调拨单预估费用
        /// </summary>
        public decimal EstimatedCost { get; set; }

        /// <summary>
        /// 跟踪号
        /// </summary>
        public List<string> TrackingNo { get; set; }

        /// <summary>
        /// 渠道名称
        /// </summary>
        public List<string> ChannelName { get; set; }

        /// <summary>
        /// 完成时间
        /// </summary>
        public DateTime? CompletionDate { get; set; }

    }

    public class AllotOrderProductItemOutputDto
    {
        /// <summary>
        /// 商品名称
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// 产品库sku
        /// </summary>
        public string Sku { get; set; }

        /// <summary>
        /// 发货总数
        /// </summary>
        public int DeliveryCount { get; set; }

        /// <summary>
        /// 入库总数
        /// </summary>
        public int StorageCount { get; set; }
    }

    public class Result_Allot
    {
        public bool isSuccess { get; set; }

        public Result_Allot_data data {get;set;}    

        public string message { get; set; }

        public int code { get; set; }

        public string errorData { get; set; }
    }

    public class Result_Allot_data
    {
        public List<AllotInfo> items { get; set; }

        public Result_Allot_page pageItem { get; set; }
    }

    public class Result_Allot_page {
        public int total { get; set; }

        public int currentPage { get; set; }

        public int pageSize { get; set; }
    }
}
