﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.OMSApi.Models;
using Bailun.ServiceFabric.Authorize;
using Bailun.ServiceFabric.Core.Extension.HttpContext;
using Bailun.ServiceFabric.Core.Extension;
using Bailun.ServiceFabric.Extension;
using Bailun.OMSApi.Models.PutIn;
using System.Data;

namespace Bailun.OMSApi.Areas.PutIn.Controllers
{
    
    [Area("PutIn")]
    public class HomeController : Controller
    {
        /// <summary>
        /// 获取入库单列表
        /// </summary>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="page">分页信息</param>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult ListPutIn([FromBody] search_PutIn m)
        {
            var companyid = HttpContextHelper.Current?.User?.GetCompanyId();
            
            var result = new Services.PutIn.PutInServices().ListPutin(m, int.Parse(companyid));

            return Json(new {
                list = result,
                total = m.total,
                page = m.pageindex,
                pagesize = m.pagesize,
                pagecount = (m.total/m.pagesize)+(m.total%m.pagesize==0?0:1),
            });
        }

        /// <summary>
        /// 新增入库单
        /// </summary>
        /// <param name="m"></param>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public JsonResult AddPutin([FromBody]mPutIn_Input m)
        {
            var companyid = HttpContextHelper.Current.User.GetCompanyId();
            var userid = HttpContextHelper.Current.User.GetUid();

            var result = new Services.PutIn.PutInServices().AddPutIn(m,userid,int.Parse(companyid));

            return Json(new {
                success = string.IsNullOrEmpty(result),
                msg = result,
            });
        }


        /// <summary>
        /// 批量导入sku
        /// </summary>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Ignore)]
        public JsonResult UploadSku(Microsoft.AspNetCore.Http.IFormFile file)
        {
            if (file == null)
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件！"
                });
            }

            //var file = files[0];
            Dictionary<string, DataTable> dic = Code.NpolHelper.ExcelToDataTable(file.OpenReadStream(), file.FileName, true);
            if (dic.Count > 0)
            {
                var tb = dic.FirstOrDefault();
                var list = new List<Tuple<string,int>>();

                for (var i = 0; i < tb.Value.Rows.Count; i++)
                {
                    var row = tb.Value.Rows[i];

                    try
                    {
                        var sku = row["sku"].ToString();
                        var count = int.Parse(row["数量"].ToString());

                        list.Add(new Tuple<string, int>(sku, count));
                    }
                    catch (Exception ex)
                    {
                        return Json(new
                        {
                            success = false,
                            msg = "导入失败，异常信息：" + ex.Message
                        });
                    }
                }

                if (list.Count == 0)
                {
                    return Json(new
                    {
                        success = false,
                        msg = "表格没有数据。",
                    });

                }
                
                return Json(new
                {
                    success = true,
                    msg = "",
                    list = list.Select(a=>new {
                        sku = a.Item1,
                        count = a.Item2
                    }),
                });
            }
            else
            {
                return Json(new
                {
                    success = false,
                    msg = "请上传文件"
                });
            }
        }
        
    }
}