﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Bailun.OMSApi.Models.PutIn;
using Bailun.ServiceFabric.Authorize;
using Bailun.ServiceFabric.Core.Extension;
using Bailun.ServiceFabric.Core.Extension.HttpContext;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;

namespace Bailun.OMSApi.Areas.Common.Controllers
{
    [BailunAuthentication(LoginMode.Enforce)]
    [Area("Common")]
    public class HomeController : Controller
    {

        public HomeController()
        {

        }

        public IActionResult Index()
        {
            return View();
        }

        /// <summary>
        /// 仓库列表
        /// </summary>
        /// <returns></returns>
        [HttpPost]
        public JsonResult ListWarehouse()
        {
            var companyid = HttpContextHelper.Current.User.GetCompanyId();

            var param = new {
                TenantId = companyid
            };

            var result = Bailun.OMSApi.Common.HttpHelper.NetHelper.HttpPostJson(OMSApi.Common.GlobalConfig.wmsapiurl2 + "api/WareHouse/GetWareHouse",JsonConvert.SerializeObject(param));

            if (string.IsNullOrEmpty(result))
            {
                return Json(new {
                    success = false,
                    msg = "获取仓库列表接口出现异常"
                });
            }

            try
            {
                var list = new List<Models.Common.mWarehouse>();
                var obj = JsonConvert.DeserializeObject<Models.Common.requestWarehouse>(result);
                if (obj.data != null && obj.data.Count>0)
                {
                    list = obj.data;

                    return Json(new
                    {
                        success = true,
                        list = list.Select(a => new { a.Code, a.Name }).Distinct(),
                        msg = "",
                    });
                }

                return Json(new
                {
                    success = false,
                    msg = "没有获取到仓库列表数据",
                });

            }
            catch (Exception ex)
            {
                return Json(new {
                    success = false,
                    msg = "获取仓库列表出现异常，异常信息：" + ex.Message
                });
            }

        }

    }
}