﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Bailun.OMSApi.Models;
using Bailun.ServiceFabric.Authorize;
using Bailun.ServiceFabric.Core.Extension.HttpContext;
using Bailun.ServiceFabric.Core.Extension;
using Bailun.ServiceFabric.Extension;

namespace Bailun.OMSApi.Areas.PutIn.Controllers
{
    [Area("PutIn")]
    public class HomeController : Controller
    {
        /// <summary>
        /// 获取入库单列表
        /// </summary>
        /// <param name="warehousecode">仓库编码</param>
        /// <param name="page">分页信息</param>
        /// <returns></returns>
        [BailunAuthentication(LoginMode.Enforce)]
        [HttpPost]
        public async Task<JsonResult> ListPutIn(string warehousecode,Page page)
        {
            var companyid = HttpContextHelper.Current?.User?.GetCompanyId();


            var result = await new Services.PutIn.PutInServices().ListPutin(warehousecode,page,int.Parse(companyid));

            return Json(new {
                list = result,
                total = page.total,
                page = page.pageindex,
                pagesize = page.pagesize
            });

        }




    }
}