﻿using Bailun.OMSApi.Common;
using Bailun.OMSApi.Models;
using Bailun.OMSApi.Models.PutIn;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Bailun.OMSApi.Services.PutIn
{
    public class PutInServices
    {
        /// <summary>
        /// 获取入库单列表
        /// </summary>
        /// <param name="warehouse">仓库编码</param>
        /// <param name="page">分页信息</param>
        /// <param name="companyid">公司id</param>
        /// <param name="total">符合条件的记录数</param>
        /// <returns></returns>
        public async Task<List<mPutIn>> ListPutin(string warehouse, Page page, int companyid)
        {
            var url = "http://api.wms.bailuntec.com/api/services/app/StorageOrderService/SearchStorageOrderByPage";

            var param = new
            {
                Data = new
                {
                    Search = new
                    {
                        WarehouseCode = warehouse,
                    },
                    Page = new
                    {
                        page = page.pageindex,
                        rows = page.pagesize,
                    }
                }
            };

            var result = HttpHelper.NetHelper.HttpPostJson(url, JsonConvert.SerializeObject(param));

            if (!string.IsNullOrEmpty(result))
            {
                var obj = JsonConvert.DeserializeObject<CommonRequestPage<mPutIn>>(result);

                page.total = obj.data.pageItem.total;
                return obj.data.items;
            }


            return null;
        }







    }
}
