﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.OMSApi.Models.PutIn
{
    public class mPutIn
    {
        public int id { get; set; }

        /// <summary>
        /// 入库单号
        /// </summary>
        public string code { get; set; }

        /// <summary>
        /// 仓库入库单号
        /// </summary>
        public string externalCode { get; set; }

        /// <summary>
        /// 百伦第三方单号
        /// </summary>
        public string thirdCode { get; set; }

        /// <summary>
        /// 标识
        /// </summary>
        public string flag { get; set; }

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string warehouseCode { get; set; }

        /// <summary>
        /// 仓库信息
        /// </summary>
        public mWarehouse warehouse { get; set; }

        /// <summary>
        /// 状态
        /// </summary>
        public string state { get; set; }

        /// <summary>
        /// 报溢单号
        /// </summary>
        public string gainOrderCode { get; set; }

        /// <summary>
        /// 报损单号
        /// </summary>
        public string lossOrderCode { get; set; }

        /// <summary>
        /// 描述
        /// </summary>
        public string remark { get; set; }

        /// <summary>
        /// 通知状态
        /// </summary>
        public bool informedState { get; set; }

        /// <summary>
        /// sku明细
        /// </summary>
        public List<mPutInDetail> details { get; set; }

        /// <summary>
        /// 最后更新时间
        /// </summary>
        public DateTime lastModificationTime { get; set; }

        /// <summary>
        /// 最后更信人
        /// </summary>
        public int? lastModifierUserId { get; set; }

        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime creationTime { get; set; }

        /// <summary>
        /// 创建人
        /// </summary>
        public int creatorUserId { get; set; }


    }

    public class mWarehouse
    {
        public string code { get; set; }

        public string name { get; set; }
        
    }

    public class mPutInDetail
    {
        public string sku { get; set; }

        public int forecastQuantity { get; set; }

        public int confirmQuantity { get; set; }
    }
}
