﻿using Bailun.OMSApi.Common;
using Bailun.OMSApi.Models;
using Bailun.OMSApi.Models.PutIn;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Linq;

namespace Bailun.OMSApi.Services.PutIn
{
    public class PutInServices
    {
        /// <summary>
        /// 获取入库单列表
        /// </summary>
        /// <param name="warehouse">仓库编码</param>
        /// <param name="page">分页信息</param>
        /// <param name="companyid">公司id</param>
        /// <param name="total">符合条件的记录数</param>
        /// <returns></returns>
        public List<mPutIn> ListPutin(search_PutIn m, int companyid)
        {
            var url = Common.GlobalConfig.wmsapiurl+"api/services/app/StorageOrderService/SearchStorageOrderByPage";

            var param = new
            {
                Data = new
                {
                    Search = new
                    {
                        WarehouseCode = m.warehousecode,
                        TenantId = companyid,
                    },
                    Page = new
                    {
                        page = m.pageindex,
                        rows = m.pagesize,
                    }
                }
            };

            var result = HttpHelper.NetHelper.HttpPostJson(url, JsonConvert.SerializeObject(param));

            if (!string.IsNullOrEmpty(result))
            {
                var obj = JsonConvert.DeserializeObject<CommonRequestPage<mPutIn>>(result);

                m.total = obj.data.pageItem.total;
                return obj.data.items;
            }


            return null;
        }

        /// <summary>
        /// 新增入库单
        /// </summary>
        /// <param name="m"></param>
        /// <param name="userid">当前用户id</param>
        /// <param name="companyid">公司id</param>
        /// <returns></returns>
        public string AddPutIn(mPutIn_Input m,int userid,int companyid)
        {
            var listNoCount = m.listsku.Where(a => a.count <= 0).ToList();
            if (listNoCount.Count>0)
            {
                return "Sku:"+string.Join(",",listNoCount.Select(a=>a.sku))+" 的入库数量必须大于0！";
            }

            var countNoSku = m.listsku.Where(a => string.IsNullOrWhiteSpace(a.sku)).Count();
            if (countNoSku > 0)
            {
                return "Sku编码不能为空！";
            }

            //检测sku是否可用
            try
            {
                var skuurl = Common.GlobalConfig.skumsurl+"api/sku/productsku/checkskubycompanyasync";

                var obj = m.listsku.Select(a => new {
                    Sku=a.sku,
                    CompanyId = companyid
                });

                var checkSku = HttpHelper.NetHelper.HttpPostJson(skuurl, JsonConvert.SerializeObject(obj));
                if (!string.IsNullOrEmpty(checkSku))
                {
                    var result_CheckSku = JsonConvert.DeserializeObject<request_Sku>(checkSku);
                    if (!result_CheckSku.result.isSucceeded)
                    {
                        return result_CheckSku.result.message;
                    }
                    else if (result_CheckSku.result.data.Where(a => !a.exists).Count() > 0)
                    {
                        return "Sku【" + string.Join(",", result_CheckSku.result.data.Where(a => !a.exists).Select(p => p.sku)) + "】不存在。";
                    }
                    else if(result_CheckSku.statusCode!=200)
                    {
                        return result_CheckSku.message;
                    }
                }
            }
            catch (Exception ex)
            {
                return "检测Sku是否存在时出现异常，错误信息："+ex.Message;
            }


            try
            {
                var url = Common.GlobalConfig.wmsapiurl+"api/services/app/StorageOrderService/Forecast";


                //入库单号
                var no = "P" + (int)((DateTime.Now-TimeZoneInfo.ConvertTimeToUtc(new System.DateTime(1970,1,1))).TotalSeconds);

                var obj = new mStockInForecastInput()
                {
                    CreatorUserId = userid,
                    ExternalCode = no,
                    Flag = no,
                    Remark = "OMS入库单",
                    WarehouseCode = m.warehousecode,
                    TenantId = companyid,
                    Details = m.listsku.Select(a => new mStockInForecastOutput_Details
                    {
                        ForecastQuantity = a.count,
                        Sku = a.sku
                    }).ToList()
                };

                var param = "{ data:" + JsonConvert.SerializeObject(obj) + " }";

                var result = HttpHelper.NetHelper.HttpPostJson(url, param);

                if (!string.IsNullOrEmpty(result))
                {
                    mStockInForecastOutput o = JsonConvert.DeserializeObject<mStockInForecastOutput>(result);
                    if (!o.isSuccess)
                    {
                        return o.message;
                    }
                    else
                    {
                        return "";
                    }
                }

                return "上传WMS出现异常，请重试！";
            }
            catch (Exception ex)
            {

                return "出现系统错误，错误信息：" + ex.Message;
            }
            
        }
        
    }
}
