﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Bailun.OMSApi.Models.PutIn
{
    public class mStockInForecastInput
    {
        /// <summary>
        /// 第三方单号 string [Required][StringLength(50)]
        /// </summary>
        public string ExternalCode { get; set; }

        /// <summary>
        /// 采购单号
        /// </summary>
        public string Flag { get; set; }

        /// <summary>
        /// 仓库编码 string [Required][StringLength(50)]
        /// </summary>
        public string WarehouseCode { get; set; }

        /// <summary>
        /// 备注 string
        /// </summary>
        public string Remark { get; set; }

        /// <summary>
        /// 创建人 int [Required]
        /// </summary>
        public int CreatorUserId { get; set; }

        /// <summary>
        /// Sku 详情
        /// </summary>
        public List<mStockInForecastOutput_Details> Details { get; set; }

        /// <summary>
        /// 公司id
        /// </summary>
        public int TenantId { get; set; }

    }

    public class mStockInForecastOutput_Details
    {
        /// <summary>
        /// Sku string [Required][StringLength(50)]
        /// </summary>
        public string Sku { get; set; }

        /// <summary>
        /// 预报数量 int [Required]
        /// </summary>
        public int ForecastQuantity { get; set; }
    }

    public class mStockInForecastOutput
    {
        /// <summary>
        /// 是否成功
        /// </summary>
        public bool isSuccess { get; set; }
        /// <summary>
        /// 入库单号
        /// </summary>
        public string data { get; set; }

        public string message { get; set; }
    }

    /// <summary>
    /// 推送产品信息
    /// </summary>
    public class mPushProductInfoToWmsInput
    {

        /// <summary>
        /// 仓库编码
        /// </summary>
        public string WarehouseCode { get; set; }

        /// <summary>
        /// sku编码
        /// </summary>
        public List<string> Skus { get; set; }
    }
}
