const plugin = require('tailwindcss/plugin')

module.exports = {
  mode: 'jit',
  purge: {
    enabled: true,
    content: ['**/!(tailwind).liquid', 'assets/*.js'],
    // https://purgecss.com/configuration.html
    options: {}
  },
  prefix: 'tw-',
  theme: {
    screens: {
      md: { 'max': '959.98px' },
      lg: '960px'
    },
    extend: {
      colors: {
        "toast-normal-color": "rgba(0,86,132,1)",
        "toast-warning-color": "rgba(160,101,8,1)",
        "toast-success-color": "rgba(26,109,63,1)",
        "toast-error-color": "rgba(240,92,93,1)",
        "body-color": "var(--color-body-text)",
        "body-bg": "var(--color-body-bg)",
        "price-color": "var(--color-price-text)",
        "save-color": "var(--color-save-text)",
        "primary-btn-color": "var(--color-primary-btn-text)",
        "primary-btn": "var(--color-primary-btn-bg)",
        "sale-tag-color": "var(--color-sale-tag-text)",
        "sale-tag-bg": "var(--color-sale-tag-bg)",
        "cart-dot-color": "var(--color-cart-dot-text)",
        "header-color": "var(--color-header-text)",
        "footer-color": "var(--color-footer-text)",
        "scheme-1-color": "var(--color-scheme-1-text)",
        "scheme-2-color": "var(--color-scheme-2-text)",
        "scheme-3-color": "var(--color-scheme-3-text)",
        "body-alpha-80": "var(--color-body-8)",
        "body-alpha-70": "var(--color-body-7)",
        "body-alpha-60": "var(--color-body-6)",
        "body-alpha-50": "var(--color-body-5)",
        "warning": "var(--color-warning)",
        "placeholder-color": "var(--color-placeholder)",
        "countdown-bg": "var(--color-countdown-bg)",
        "countdown-time-text": "var(--color-countdown-time-text)"
      },
      backgroundColor: {
        "toast-normal": "rgba(214,247,250,1)",
        "toast-warning": "rgba(255,251,218,1)",
        "toast-success": "rgba(209,245,237,1)",
        "toast-error": "rgba(252,225,225,1)",
        "body": "var(--color-body-bg)",
        "primary-btn": "var(--color-primary-btn-bg)",
        "primary-btn-light": "var(--color-primary-btn-light)",
        "sale-tag": "var(--color-sale-tag-bg)",
        "cart-dot": "var(--color-cart-dot-bg)",
        "image": "var(--color-image-bg)",
        "header-search": "var(--color-header-search)",
        "header": "var(--color-header-bg)",
        "footer": "var(--color-footer-bg)",
        "scheme-1": "var(--color-scheme-1-bg)",
        "scheme-2": "var(--color-scheme-2-bg)",
        "scheme-3": "var(--color-scheme-3-bg)",
        "darken": "var(--color-darken)",
        "svg": "#e1e1e1",
        "tips-warning": "#fff6f6",
        "light-gray": "#f8f8f8",
      },
      borderColor: {
        "line": "var(--color-borders)",
        "footer": "var(--color-footer-border)",
        "body": "var(--color-body-text)",
        "header": "var( --color-header-border)",
        "tips-warning": "#d95d57",
      },
      borderRadius: {
        "global": "var(--global-border-radius)",
        "btn": "var(--global-border-radius-btn)",
        "btn-fixed": "var(--global-fixed-border-radius-btn)"
      },
      fill: {
        "svg": "#999999",
      },
      boxShadow: {
        collection: "0 3px 10px rgb(0 0 0 / 10%)",
        comment: "0 5px 19px 4px rgba(0, 0, 0, 0.07)",
        filter: "0 10px 20px rgb(0 0 0 / 15%)",
        message: "1px 4px 30px rgb(0 0 0 / 15%)",
        drawer: "0px 4px 8px 1px rgba(0,0,0,0.10)",
        zoomIcon: "0px 3px 6px 0px rgba(0,0,0,0.15)",
        toast: "0 2px 10px 1px rgba(0, 0, 0, 0.1), 0 0 4px 1px rgba(0, 0, 0, 0.04)"
      },
      gap: {
      },
      gridTemplateColumns: {},
      maxWidth: {
        page: "var(--layout-width)",
      },
      minWidth: {
        5: '1.25rem'
      },
      width: {
        100: "25rem",
      },
      spacing: {
        10: '2.5rem',
        11: '2.75rem',
        12: '3rem',
        13: '3.25rem',
        14: '3.5rem',
        15: '3.75rem',
        16: '4rem',
        17: "4.25rem",
        18: '4.5rem',
        20: '5rem',
        25: '6.25rem',
        30: '7.5rem',
        31: '7.75rem',
        40: '10rem',
        50: '12.5rem',
        "full": '100%'
      },
      fontSize: {
        "title-font-size": "var(--type-title-font-size)",
        "body-font-size": "var(--type-body-font-size)",
        "nav-font-size": "var(--type-nav-font-size)",
        "0": "0px",
        5: "1.25rem",
        6: "1.5rem"
      },
      lineHeight: {
        "title": "var(--type-title-line-height)",
        "body": "var(--type-body-line-height)",
        1.1: "1.1",
        1.2: "1.2",
        1.3: "1.3",
        1.4: "1.4",
        1.5: "1.5",
        1.6: "1.6",
      },
      letterSpacing: {
        "title": "var(--type-title-spacing)",
        "body": "var(--type-body-spacing)",
        "nav": "var(--type-nav-spacing)",
      },
      zIndex: {
        'dropdown': '1000',
        'sticky': '1020',
        'fixed': '1030',
        'modal-backdrop': '1040',
        'modal': '1050',
        'popover': '1060',
        'tooltip': '1070'
      },
      opacity: {
        "65": "0.65"
      }
    },
  },
  plugins: [
    // 支持边框某侧不同颜色
    // https://github.com/tailwindlabs/tailwindcss/pull/560
    /*({ addUtilities, e, theme, variants }) => {
      const colors = flattenColorPalette(theme('borderColor'));
      delete colors['default'];
      const colorMap = Object.keys(colors)
        .map(color => ({
          [`.border-t-${color}`]: { borderTopColor: colors[color] },
          [`.border-r-${color}`]: { borderRightColor: colors[color] },
          [`.border-b-${color}`]: { borderBottomColor: colors[color] },
          [`.border-l-${color}`]: { borderLeftColor: colors[color] },
        }));
      const utilities = Object.assign({}, ...colorMap);
      addUtilities(utilities, variants('borderColor'));
    },*/
    // 支持 empty:tw-hidden
    plugin(({ addVariant, prefix, e }) => {
      addVariant('empty', ({ modifySelectors, separator }) => {
        modifySelectors(({ className }) => {
          return `.empty${e(separator)}${prefix(className)}:empty`
        })
      })
    }),
    require('@tailwindcss/line-clamp')
  ],
  corePlugins: {
    preflight: false,
    container: false,
  }
}
