$(function () {
  var ready = {
    youtube: !!window.YT,
    vimeo: !!window.Vimeo
  };

  var load = function (videoType, callback) {
    var config = {
      youtube: {
        js: '//www.youtube.com/iframe_api',
        name: 'YT'
      },
      vimeo: {
        js: '//player.vimeo.com/api/player.js',
        name: 'Vimeo'
      }
    }
    $.getScript(config[videoType].js, function () {
      var timer = setInterval(function () {
        if (window[config[videoType].name] && window[config[videoType].name].Player) {
          clearInterval(timer);
          ready[videoType] = true;
          callback.call();
        }
      }, 100);
    });
  }

  var play = function (params) {
    var player = null
    if (!ready[params.videoType]) { // not ready
      load(params.videoType, play.bind(this, params));
      return
    }
    switch (params.videoType) {
      case 'youtube':
        player = new YT.Player(params.divId, {
          width: 1280,
          height: 720,
          playerVars: {
            autohide: 0,
            branding: 0,
            cc_load_policy: 0,
            controls: 0,
            fs: 0,
            iv_load_policy: 3,
            modestbranding: 1,
            playsinline: 1,
            quality: 'hd720',
            rel: 0,
            showinfo: 0,
            playlist: params.videoId,
            loop: 1,
            wmode: 'opaque',
            mute: 1
          },
          events: {
            onReady: function (evt) {
              player.playVideo()
              buttonListener(params.sectionId)
            },
            onStateChange: function (evt) {
              evt.data == 1
                && ($('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="pause"]').removeClass('tw-hidden'))
                && ($('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="play"]').addClass('tw-hidden'))
              evt.data == 2
                && ($('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="play"]').removeClass('tw-hidden'))
                && ($('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="pause"]').addClass('tw-hidden'))
            }
          },
          type: 'youtube',
          videoId: params.videoId
        })
        break;
      case 'vimeo':
        player = new Vimeo.Player(params.divId, {
          byline: false,
          controls: false,
          title: false,
          portrait: false,
          loop: true,
          type: 'vimeo',
          id: params.videoId,
          transparent: false
        });
        player.setVolume(0);
        player.on("loaded", function(){
          player.play()
          buttonListener(params.sectionId)
        });
        player.on('play', function () {
          $('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="pause"]').removeClass('tw-hidden')
          $('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="play"]').addClass('tw-hidden')
        });
        player.on("pause", function(){
          $('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="play"]').removeClass('tw-hidden')
          $('[data-section-id="' + params.sectionId + '"] .control_btn[data-type="pause"]').addClass('tw-hidden')
        });
    }
    $(document).on('video.action', function (event, data) {
      if (data.sectionId == params.sectionId) {
        switch(data.action) {
          case 'play':
            params.videoType == 'youtube'
              ? (player.playVideo())
              : (player.play())
            break;
          case 'pause':
            params.videoType == 'youtube'
              ? (player.pauseVideo())
              : (player.pause())
            break;
          case 'mute':
            params.videoType == 'youtube'
              ? (player.unMute())
              : (player.setVolume(1))
            $('[data-section-id="' + data.sectionId + '"] .control_btn[data-control-type="voice"]').toggleClass('tw-hidden')
            break;
          case 'voice':
            params.videoType == 'youtube'
              ? (player.mute())
              : (player.setVolume(0))
            $('[data-section-id="' + data.sectionId + '"] .control_btn[data-control-type="voice"]').toggleClass('tw-hidden')
            break;
          }
      }
    })
    function buttonListener (id) { // 监听播放/禁音按钮，通过事件响应
      $('[data-section-id="' + id + '"] .control_btn[data-type="pause"], [data-section-id="' + params.sectionId + '"] .control_btn[data-type="mute"]').removeClass('tw-hidden')
      $('[data-section-id="' + id + '"] .control_btn').off('click.action').on('click.action', function(){
        $(document).trigger('video.action', {
          action: $(this).data('type'),
          sectionId: id,
        })
      })
    }
  }

  $.fn.playVideo = function (sectionId) {
    var videoType = $(this).data('video-type');
    var videoId = $(this).data('video-id');
    var divId = $(this).attr('id');
    if (!videoType || !videoId) return;
    play({
      videoType: videoType,
      videoId: videoId,
      divId: divId,
      sectionId: sectionId
    });
    window.videoType = videoType;
  }
});