﻿using Abp.Domain.Entities;
using Abp.Extensions;
using Newtonsoft.Json;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace Bailun.Discuz.Domain.Account
{
    public class LazadaAccountPublishConfig : Entity<long>
    {
        [Column("account_id")] public long AccountId { get; set; }

        [Column("account_name")] public string AccountName { get; set; }

        [Column("market")] public string Market { get; set; }

        [Column("account_type")] public AccountType? AccountType { get; set; }

        [Column("online_count")] public int? OnlineCount { get; set; }

        [Column("publishable_category_json")] public string PublishableCategoryJson { get; set; }

        public IEnumerable<KeyValuePair<long, string>> PublishableCategories
        {
            get
            {
                if (PublishableCategoryJson.IsNullOrEmpty())
                {
                    return new List<KeyValuePair<long, string>>();
                }

                return JsonConvert.DeserializeObject<List<KeyValuePair<long, string>>>(PublishableCategoryJson);
            }
        }

        [Column("unpublishable_category_json")]
        public string UnpublishableCategoryJson { get; set; }

        public IEnumerable<KeyValuePair<long, string>> UnpublishableCategories
        {
            get
            {
                if (UnpublishableCategoryJson.IsNullOrEmpty())
                {
                    return new List<KeyValuePair<long, string>>();
                }

                return JsonConvert.DeserializeObject<List<KeyValuePair<long, string>>>(UnpublishableCategoryJson);
            }
        }
    }
}
