using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using Abp.Extensions;
using Abp.Logging;
using Newtonsoft.Json;
using Qiniu.Http;
using Qiniu.Storage;
using Qiniu.Util;
using HttpResult = Qiniu.Http.HttpResult;
using Bailun.ServiceFabric.Extension;

namespace Bailun.Discuz.Application.Helper
{
    /// <summary>
    /// 七牛云辅助类
    /// </summary>
    public class QiNiuHelper
    {
        public static  string AccessKey = ConfigManagerConf.GetValue("QiNiu:AccessKey");
        public static  string SecretKey = ConfigManagerConf.GetValue("QiNiu:SecretKey");

        public static  string PicServerUrl = ConfigManagerConf.GetValue("QiNiu:CdnUrl");

        public static  string ProxyUrl = ConfigManagerConf.GetValue("QiNiu:ProxyUrl");
        /// <summary>
        /// 刊登cdn地址
        /// </summary>
        //public static readonly string SkumsCdnUrl = ConfigManagerConf.GetValue("QiNiu:SkumsCdnUrl");
        public static  string SkumsCdnUrl = ConfigManagerConf.GetValue("QiNiu:ProductsCdnUrl");
        /// <summary>
        /// 七牛存储节点
        /// </summary>
        //private static readonly string Bucket = "bailun-Skums-img";
        private static  string Bucket = ConfigManagerConf.GetValue("QiNiu:Bucket");

        /// <summary>
        /// 七牛图片输出cdn
        /// </summary>
        private static List<string> ImgoutputCDNs = new List<string>();

        /// <summary>
        /// 获取七牛云图片输出cdn
        /// </summary>
        /// <returns></returns>
        public static List<string> GetImgoutputCDNs()
        {
            if (ImgoutputCDNs != null && ImgoutputCDNs.Count > 0) return ImgoutputCDNs;
            for (int i = 0; i < 12; i++)
            {
                var cdn = ConfigManagerConf.GetValue("QiNiu:ImgCDNs:" + i);
                ImgoutputCDNs.Add(cdn);
            }
            return ImgoutputCDNs;
        }

        #region 上传文件
        /// <summary>
        /// 上传文件
        /// </summary>
        /// <param name="saveFile"></param>
        /// <param name="content"></param>
        /// <returns></returns>
        public static async Task<HttpResult> UploadStreamAsync(string saveFile, byte[] content, string mimeType = "")
        {
            AccessKey = "QSvtvN4Ons1CiNzaMGqx8XmDaiM1L0ZqSwJ2YoTn";
            SecretKey = "yagRd-cBOVhkRGGT-o_reMqNVjI8_k7YwoTXkhrm";
            PicServerUrl = "http://img.blsct.com";
            //ProxyUrl = "http://172.106.221.14:8513";
            /// <summary>
            /// 刊登cdn地址
            /// </summary>
            //public static readonly string SkumsCdnUrl = ConfigManagerConf.GetValue("QiNiu:SkumsCdnUrl");
            SkumsCdnUrl = "https://img.blsct.com";
            /// <summary>
            /// 七牛存储节点
            /// </summary>
            //private static readonly string Bucket = "bailun-Skums-img";
            Bucket = "bailun-publish-img";
            Mac mac = new Mac(AccessKey, SecretKey);

            // 设置上传策略，详见：https://developer.qiniu.com/kodo/manual/1206/put-policy
            PutPolicy putPolicy = new PutPolicy();
            putPolicy.Scope = Bucket + ":" + saveFile;  //覆盖式更新
            if (!mimeType.IsNullOrEmpty())
            {
                putPolicy.MimeLimit = mimeType;

            }
            // putPolicy.SetExpires(3600);
            string token = Auth.CreateUploadToken(mac, putPolicy.ToJsonString());
            Qiniu.Storage.Config config = new Qiniu.Storage.Config();
            // 设置上传区域
            config.Zone = Zone.ZoneCnSouth;
            // 设置 http 或者 https 上传
            //config.UseHttps = true;
            //config.UseCdnDomains = true;
            //config.ChunkSize = ChunkUnit.U512K;
            FormUploader target = new FormUploader(config);
            var result = await target.UploadStream(new MemoryStream(content), saveFile, token, null);
            return result;
        }
        /// <summary>
        /// 查找文件路径
        /// </summary>
        /// <param name="saveFile"></param>
        /// <returns></returns>
        public static string CreateProductsUrl(string saveFile)
        {
            string url = "";
            try
            {
                url = DownloadManager.CreatePublishUrl(PicServerUrl, saveFile);
            }
            catch (Exception ex)
            {
                string error = ex.ToString();
            }
            return url;
        }
        public static async Task<HttpResult> UploadBigStreamAsync(string saveFile, string localFile, string mimeType = "")
        {
            Mac mac = new Mac(AccessKey, SecretKey);

            // 设置上传策略，详见：https://developer.qiniu.com/kodo/manual/1206/put-policy
            PutPolicy putPolicy = new PutPolicy();
            putPolicy.Scope = Bucket + ":" + saveFile;  //覆盖式更新
            if (!mimeType.IsNullOrEmpty())
            {
                putPolicy.MimeLimit = mimeType;

            }
            // putPolicy.SetExpires(3600);
            string token = Auth.CreateUploadToken(mac, putPolicy.ToJsonString());
            Config config = new Config
            {
                Zone = Zone.ZoneCnSouth,
                ChunkSize = ChunkUnit.U1024K
            };
            // 包含两个参数，并且都有默认值
            // 参数1(bool): uploadFromCDN是否从CDN加速上传，默认否
            // 参数2(enum): chunkUnit上传分片大小，可选值128KB,256KB,512KB,1024KB,2048KB,4096KB
            ResumableUploader ru = new ResumableUploader(config);
            UploadProgressHandler upph = new UploadProgressHandler(ResumableUploader.DefaultUploadProgressHandler);
            var putExtra = new PutExtra
            {
                ProgressHandler = upph,
                MaxRetryTimes = 10,
            };
            // ResumableUploader.UploadFile有多种形式，您可以根据需要来选择
            //
            // 最简模式，使用默认recordFile和默认uploadProgressHandler
            // UploadFile(localFile,saveKey,token)
            // 
            // 基本模式，使用默认uploadProgressHandler
            // UploadFile(localFile,saveKey,token,recordFile)
            //
            // 一般模式，使用自定义进度处理(可以监视上传进度)
            // UploadFile(localFile,saveKey,token,recordFile,uploadProgressHandler)
            //
            // 高级模式，包含上传控制(可控制暂停/继续 或者强制终止)
            // UploadFile(localFile,saveKey,token,recordFile,uploadProgressHandler,uploadController)
            // 
            // 支持自定义参数
            //var extra = new System.Collections.Generic.Dictionary<string, string>();
            //extra.Add("FileType", "UploadFromLocal");
            //extra.Add("YourKey", "YourValue");
            //uploadFile(...,extra,...)
            //UploadController upctl = new UploadController();
            var result = await ru.UploadFile(localFile, saveFile, token, putExtra);

            return result;
        }

        public static async Task<HttpResult> UploadBigStreamAsync(string saveFile, byte[] content, string mimeType = "")
        {
            Mac mac = new Mac(AccessKey, SecretKey);

            // 设置上传策略，详见：https://developer.qiniu.com/kodo/manual/1206/put-policy
            PutPolicy putPolicy = new PutPolicy();
            putPolicy.Scope = Bucket + ":" + saveFile;  //覆盖式更新
            if (!mimeType.IsNullOrEmpty())
            {
                putPolicy.MimeLimit = mimeType;

            }
            // putPolicy.SetExpires(3600);
            string token = Auth.CreateUploadToken(mac, putPolicy.ToJsonString());
            Config config = new Config
            {
                Zone = Zone.ZoneCnSouth,
                ChunkSize = ChunkUnit.U1024K
            };
            // 包含两个参数，并且都有默认值
            // 参数1(bool): uploadFromCDN是否从CDN加速上传，默认否
            // 参数2(enum): chunkUnit上传分片大小，可选值128KB,256KB,512KB,1024KB,2048KB,4096KB
            ResumableUploader ru = new ResumableUploader(config);
            UploadProgressHandler upph = new UploadProgressHandler(ResumableUploader.DefaultUploadProgressHandler);
            var putExtra = new PutExtra
            {
                ProgressHandler = upph,
                MaxRetryTimes = 10,
            };
            // ResumableUploader.UploadFile有多种形式，您可以根据需要来选择
            //
            // 最简模式，使用默认recordFile和默认uploadProgressHandler
            // UploadFile(localFile,saveKey,token)
            // 
            // 基本模式，使用默认uploadProgressHandler
            // UploadFile(localFile,saveKey,token,recordFile)
            //
            // 一般模式，使用自定义进度处理(可以监视上传进度)
            // UploadFile(localFile,saveKey,token,recordFile,uploadProgressHandler)
            //
            // 高级模式，包含上传控制(可控制暂停/继续 或者强制终止)
            // UploadFile(localFile,saveKey,token,recordFile,uploadProgressHandler,uploadController)
            // 
            // 支持自定义参数
            //var extra = new System.Collections.Generic.Dictionary<string, string>();
            //extra.Add("FileType", "UploadFromLocal");
            //extra.Add("YourKey", "YourValue");
            //uploadFile(...,extra,...)
            //UploadController upctl = new UploadController();
            var result = await ru.UploadStream(new MemoryStream(content), saveFile, token, putExtra);

            return result;
        }
        #endregion

        /// <summary>
        /// 是否本系统图片
        /// </summary>
        /// <param name="url">当前url</param>
        /// <returns></returns>
        public static bool IsSystemImage(string url)
        {


            var systemImgDomain = ConfigManagerConf.GetReferenceValue("QiNiu:SystemDomain");
            foreach (var imgDomain in systemImgDomain)
            {
                if (url.Contains(imgDomain))
                {
                    return true;
                }
            }
            return false;
        }
        /// <summary>
        /// 根据图片路径获得系统支持的格式的所有路径，比如http://img.blsct.com/xxx,jpg得到["http://img.blsct.com/xxx,jpg","http://clound.cn/xxx,jpg"]
        /// </summary>
        /// <param name="imgUrl"></param>
        /// <returns></returns>
        public static List<string> GetMultipleImgPath(string imgUrl)
        {
            var systemImgDomain = ConfigManagerConf.GetReferenceValue("QiNiu:SystemDomain");
            string domain = "";
            foreach (var imgDomain in systemImgDomain)
            {
                if (imgUrl.Contains(imgDomain))
                {
                    domain = imgDomain;
                }
            }
            List<string> imgList = new List<string>();
            foreach (var imgDomain in systemImgDomain)
            {
                imgList.Add(imgUrl.Replace(domain, imgDomain));
            }
            return imgList;
        }

        #region 获取七牛云缩略图，默认为550宽高

        /// <summary>
        /// 获取七牛云等比缩放缩略图，默认为550宽高，可用于放大的配置
        /// </summary>
        /// <param name="url">七牛云图片路径(clouddn.com格式）</param>
        /// <param name="width">宽度</param>
        /// <param name="height">高度</param>
        /// <param name="quantity">图片质量，0-100</param>
        /// <returns></returns>
        public static string GetQiNiuScaleThumbnail(string url, int width = 550, int height = 550, int quantity = 75)
        {
            var imgFunc = $"imageMogr2/thumbnail/!{width}x{height}r/blur/1x0/quality/{quantity}";
            if (url.Contains("clouddn.com") && !url.Contains("imageMogr2") && width > 0 && height > 0)  //代表七牛云图片路径
            {
                return url + "?" + imgFunc;
            }
            return url;
        }
        #endregion

        /// <summary>
        /// 获取缩略图
        /// </summary>
        /// <param name="url">七牛云图片路径(clouddn.com格式）</param>
        /// <param name="width">宽度</param>
        /// <param name="height">高度</param>
        /// <returns></returns>
        public static string GetQiNiuThumbnail(string url, int width = 100, int height = 100)
        {
            var imgFunc = $"imageView2/2/w/{width}/h/{height}/q/75|imageslim";
            if (url.Contains("clouddn.com") && !url.Contains("imageView2") && width > 0 && height > 0)  //代表七牛云图片路径
            {
                return url + "?" + imgFunc;
            }
            return url;
        }

        #region 查找文件路径
        /// <summary>
        /// 查找文件路径
        /// </summary>
        /// <param name="saveFile"></param>
        /// <returns></returns>
        public static string CreateSkumsUrl(string saveFile)
        {
            string url = "";
            try
            {
                url = DownloadManager.CreatePublishUrl(PicServerUrl, saveFile);
            }
            catch (Exception ex)
            {
                string error = ex.ToString();
            }
            return url;
        }
        #endregion

        #region 复制文件

        /// <summary>
        /// 复制文件
        /// </summary>
        /// <param name="saveFile"></param>
        /// <param name="descFile"></param>
        /// <returns></returns>
        public static async Task<string> CopyFileAsync(string saveFile, string descFile)
        {
            // 公网可访问的文件链接
            Mac mac = new Mac(AccessKey, SecretKey);
            Config config = new Config
            {
                // 设置上传区域
                Zone = Zone.ZoneCnSouth
            };
            var buckerManager = new BucketManager(mac, config);

            string op = buckerManager.CopyOp(Bucket, saveFile, Bucket, descFile, true);
            List<string> ops = new List<string>
            {
                op
            };
            BatchResult ret = await buckerManager.Batch(ops);
            if (ret.Code / 100 != 2)
            {
            }
            foreach (BatchInfo info in ret.Result)
            {
                if (info.Code != (int)HttpCode.OK)
                {
                }

            }

            return descFile;
        }





        #endregion

        #region 七牛云拉取文件
        /// <summary>
        /// 七牛云拉取文件
        /// </summary>
        /// <param name="url"></param>
        /// <param name="saveFile"></param>
        /// <returns></returns>
        public static async Task<FetchResult> FetchFileAsync(string url, string saveFile)
        {
            // 公网可访问的文件链接
            Mac mac = new Mac(AccessKey, SecretKey);
            Config config = new Config
            {
                // 设置上传区域
                Zone = Zone.ZoneCnSouth
            };
            var buckerManager = new BucketManager(mac, config);
            return await buckerManager.Fetch(url, Bucket, saveFile);
        }



        /// <summary>
        /// 上传https文件
        /// </summary>
        /// <param name="url"></param>
        /// <param name="saveFile"></param>
        /// <returns></returns>
        private static async Task<HttpResult> FetchHttpsFileAsync(string url, string saveFile)
        {
            try
            {
                var bytes = DownloadHttpsFile(url.Trim());

                return await UploadStreamAsync(saveFile, bytes);

            }
            catch (Exception ex)
            {
                LogHelper.LogException(ex);
                return new HttpResult() { Code = 500, Text = "下载https文件失败!" + url };
            }
        }

        #region 替换小图

        /// <summary>
        /// 替换小图
        /// </summary>
        /// <param name="picUrl"></param>
        /// <param name="isError">是否产生过一次80x80的图片，如果产生过80x80的图片，则按500x500爬取</param>
        /// <returns></returns>
        public static string ReplaceEbayPicUrl(string picUrl, bool isError = false)
        {
            if (!picUrl.IsNullOrEmpty())
            {
                if (picUrl.Contains("i.ebayimg.com/00/"))
                {
                    string regexCode = "https://i.ebayimg.com/00/s/(.*)/z/(.*)/(.*)";
                    var reg = new Regex(regexCode);
                    var mc = reg.Match(picUrl);
                    if (mc.Success)
                    {
                        var str = mc.Groups[2].Value;
                        var newUrl = "https://i.ebayimg.com/images/g/" + str + "/s-l800.jpg";
                        if (isError)
                        {
                            newUrl = "https://i.ebayimg.com/images/g/" + str + "/s-l500.jpg";
                        }
                        return newUrl;
                    }

                    return picUrl;



                }
                else if (picUrl.Contains("ebayimg.com"))
                {
                    if (!isError)
                    {
                        var bigImgUrl = picUrl.Replace("s-l300", "s-l800");
                        bigImgUrl = bigImgUrl.Replace("s-l500", "s-l800");
                        return bigImgUrl;
                    }
                    else
                    {
                        return picUrl.Replace("s-l300", "s-l500");
                    }


                }




            }
            return picUrl;
        }
        #endregion

        #region 获取图片的大小和尺寸
        /// <summary>  
        /// 获取图片的大小和尺寸  
        /// </summary>  
        /// <param name="aPhotoUrl">图片url</param>  
        /// <param name="iWidth">图片宽度</param>  
        /// <param name="iHeight">图片高度</param>  
        private void GetPhotoInfo(string aPhotoUrl, ref int iWidth, ref int iHeight)
        {
            Uri mUri = new Uri(aPhotoUrl);
            HttpWebRequest mRequest = (HttpWebRequest)WebRequest.Create(mUri);
            mRequest.Method = "GET";
            mRequest.Timeout = 200;
            HttpWebResponse mResponse = (HttpWebResponse)mRequest.GetResponse();
            Stream mStream = mResponse.GetResponseStream();
            Image mImage = Image.FromStream(mStream);

            iWidth = mImage.Width;
            iHeight = mImage.Height;
            mStream.Close();

        }
        #endregion

        /// <summary>  
        /// 下载https文件
        /// </summary>  
        /// <param name="posturl">请求的接口链接</param>  
        /// <returns>返回的结果</returns>  
        ///   
        #region 
        public static byte[] DownloadHttpsFile(string posturl)
        {
            try
            {
                WebClient client = new WebClient();
                byte[] bytes = client.DownloadData(posturl);

                return bytes;
            }
            catch (Exception ex)
            {
                try
                {
                    return DownloadByProxy(posturl);
                }
                catch (Exception other)
                {
                    throw other;
                }
            }
        }
        /// <summary>
        /// 通过代理下载图片
        /// </summary>
        /// <param name="postUrl"></param>
        /// <returns></returns>
        public static byte[] DownloadByProxy(string postUrl)
        {

            var downloadUrl = ProxyUrl + "/" + postUrl;
            WebClient client = new WebClient();
            byte[] bytes = client.DownloadData(downloadUrl);

            return bytes;
        }
        #endregion

        #region 七牛云图片信息

        #endregion

        #endregion
    }
    /// <summary>
    /// 七牛云图片格式
    /// </summary>
    public class QiNiuFileInfo
    {
        [JsonProperty("size")]
        public long Size { get; set; }
        [JsonProperty("format")]
        public string Format { get; set; }
        [JsonProperty("width")]
        public int Width { get; set; }
        [JsonProperty("height")]
        public int Height { get; set; }
        [JsonProperty("colorModel")]
        public string ColorModel { get; set; }
    }
}
