using Bailun.AbpCore;
using Bailun.AbpCore.ServiceFabric;
using Bailun.Discuz.Domain.ExternalApi;
using Bailun.ServiceFabric;
using Bailun.ServiceFabric.Exceptionless;
using Bailun.ServiceFabric.Exceptionless.Logging;
using Bailun.ServiceFabric.MicroService;
using Exceptionless;
using Exceptionless.Models;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http.Features;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Bailun.Discuz
{
    public class Startup
    {
        private readonly IConfigurationRoot _appConfiguration;
        public Startup(IHostingEnvironment env)
        {
            _appConfiguration = env.GetAppConfiguration();
            ConfigManagerConf.SetConfiguration(_appConfiguration);
        }

        public IServiceProvider ConfigureServices(IServiceCollection services)
        {
            services.AddMvc().AddMvcApiResult();

            services.AddMicroServiceApi<ITaskJobApi>(ConfigManagerConf.GetValue("ApiServerUrl:TaskJobUrl"));

            //扩大接口能接收的post容量
            services.Configure<FormOptions>(options =>
            {
                options.ValueCountLimit = int.MaxValue; // 2000 items max
                options.ValueLengthLimit = 1024 * 1024 * 100; // 100MB max len form data
            });
            services.AddMicroServiceApi<IPamsApi>(ConfigManagerConf.GetValue("ApiServerUrl:PamsUrl"));
            //services.AddSingleton<IHttpApiFactory<IProductApi>, HttpApiFactory<IProductApi>>(p =>
            //{
            //    return new HttpApiFactory<IProductApi>().ConfigureHttpApiConfig(c =>
            //    {
            //        c.HttpHost = new Uri(ConfigManagerConf.GetValue("ApiServerUrl:ProductUrl"));
            //        c.LoggerFactory = p.GetRequiredService<ILoggerFactory>();
            //    });
            //});
            //services.AddSingleton(p =>
            //{
            //    var factory = p.GetRequiredService<IHttpApiFactory<IProductApi>>();
            //    return factory.CreateHttpApi();
            //});

            //注入日志
            services.AddSingleton<ILessLog, LessLog>();

            string hostName = ConfigManagerConf.GetValue("redis:HostName");
            string port = ConfigManagerConf.GetValue("redis:Port");
            string password = ConfigManagerConf.GetValue("redis:Password");
            string defaultdatabase = ConfigManagerConf.GetValue("redis:Defaultdatabase");

            var redis_connString = $"{hostName}:{port}, defaultDatabase = {defaultdatabase},password={password}, poolsize = 500, ssl = false, writeBuffer = 10240";
            var rs = new CSRedis.CSRedisClient(redis_connString);

            RedisHelper.Initialization(rs);//初始化Redis

            return services.AddAbpService<ServiceModule,BaseContext>(_appConfiguration);
        }

        public void Configure(IApplicationBuilder app, IHostingEnvironment env, ILoggerFactory loggerFactory, IApiInfo apiInfo)
        {

            app.UseAbpService(_appConfiguration, loggerFactory, apiInfo);
            app.UseExceptionless(_appConfiguration);

            ExceptionlessClient.Default.SubmittingEvent += Default_SubmittingEvent;
        }

        /// <summary>
        /// 默认提交异常处理事件
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private static void Default_SubmittingEvent(object sender, EventSubmittingEventArgs e)
        {
            var argEvent = e.Event;
            if (argEvent.Type == Event.KnownTypes.Log && argEvent.Source == "Ocelot.Configuration.Repository.FileConfigurationPoller")
            {
                e.Cancel = true;
                return;
            }
            // 只处理未处理的异常
            if (!e.IsUnhandledError)
                return;


            //忽略没有错误体的错误
            var error = argEvent.GetError();
            if (error == null)
                return;

            // 忽略404错误
            if (e.Event.IsNotFound())
            {
                e.Cancel = true;
                return;
            }

            //忽略401(Unauthorized)和请求验证的错误.
            if (error.Code == "401")
            {
                e.Cancel = true;
                return;
            }

            //忽略任何未被代码抛出的异常
            var handledNamespaces = new List<string> { "Exceptionless" };
            var handledNamespaceList = error.StackTrace.Select(s => s.DeclaringNamespace).Distinct();
            if (!handledNamespaceList.Any(ns => handledNamespaces.Any(ns.Contains)))
            {
                e.Cancel = true;
                return;
            }

            e.Event.Tags.Add("未捕获异常");//添加系统异常标签
            e.Event.MarkAsCritical();//标记为关键异常

        }
    }
}
