﻿using System;
using System.Collections.Generic;
using System.Text;
using Bailun.ServiceFabric;

namespace Bailun.Discuz.Domain.ExternalApi.ApiDtos.Account
{
    /// <summary>
    /// pams返回的带授权账号model
    /// </summary>
    public class PlatformAccount
    {
        /// <summary>
        /// 账号Id
        /// </summary>
        public int Id { get; set; }

        /// <summary>
        /// 账号
        /// </summary>
        public string Account { get; set; }

        /// <summary>
        /// 账号登录邮箱
        /// </summary>
        public string EmailAccount { get; set; }

        /// <summary>
        /// oms编码
        /// </summary>
        public string OmsCode { get; set; }

        /// <summary>
        /// oms账号
        /// </summary>
        public string OmsAccount { get; set; }

        /// <summary>
        /// 平台Id
        /// </summary>
        public int PlatformId { get; set; }

        /// <summary>
        /// 平台(中文)
        /// </summary>
        public string Platform { get; set; }

        /// <summary>
        /// 平台(英文)
        /// </summary>
        public string PlatformEn { get; set; }

        /// <summary>
        /// 站点Id
        /// </summary>
        public int SiteId { get; set; }

        /// <summary>
        /// 站点(中文)
        /// </summary>
        public string Site { get; set; }

        /// <summary>
        /// 站点(英文)
        /// </summary>
        public string SiteEn { get; set; }

        /// <summary>
        /// 授权JSON
        /// </summary>
        public string AuthJson { get; set; }

        public Auth Auth
        {
            get
            {
                if (!AuthJson.IsNullOrEmpty())
                {
                    return AuthJson.ToObject<Auth>();
                }
                return new Auth();
            }
        }

        public string Token
        {
            get
            {
                if (Auth != null && !Auth.Access_token.IsNullOrEmpty())
                {
                    return Auth.Access_token;
                }
                return string.Empty;
            }
        }

        /// <summary>
        /// 状态:1#启用;0#禁用;
        /// </summary>
        public int Status { get; set; }

        /// <summary>
        /// 状态(中文)
        /// </summary>
        public string StatusCn { get; set; }


        /// <summary>
        /// SOAP授权token
        /// </summary>
        public string SoapAuthToken { get; set; }

        /// <summary>
        /// SOAP授权状态
        /// </summary>
        public int SoapAuthStatus { get; set; }

        /// <summary>
        /// 平台账号授权状态
        /// </summary>
        public int AuthStatus { get; set; }

        /// <summary>
        /// 扩展
        /// </summary>
        public string ExtensionInfo { get; set; }

        /// <summary>
        /// 开发者信息
        /// </summary>
        public string DeveloperJson { get; set; }
        /// <summary>
        /// 账号管理员
        /// </summary>
        public string Manager { get; set; }
        /// <summary>
        /// Seller Id
        /// </summary>
        public string SellerId { get; set; }
        /// <summary>
        /// 账号提供者id
        /// </summary>
        public int UserId { get; set; }
        /// <summary>
        /// 
        /// </summary>
        public string EbayAdAuthJson { get; set; }

        public string AmazonAdAuthJson { get; set; }
        /// <summary>
        /// 店铺名
        /// </summary>
        public string ShopName { get; set; }
    }

    public class Auth
    {
        /// <summary>
        /// token
        /// </summary>
        public string Access_token { get; set; }
        /// <summary>
        /// 过期时间
        /// </summary>
        public string Expires_in { get; set; }

        /// <summary>
        /// 刷新token
        /// </summary>
        public string Refresh_token { get; set; }
    }
}
