﻿using Abp.AspNetCore;
using Abp.AspNetCore.SignalR;
using Abp.Modules;
using Abp.Reflection.Extensions;
using Bailun.AbpCore.ServiceFabric;
using Bailun.ServiceFabric;
using Bailun.ServiceFabric.MicroService;
using Microsoft.AspNetCore.Hosting;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Configuration;
using Z.EntityFramework.Extensions;

namespace Bailun.Discuz
{
    [DependsOn(
        typeof(AbpServiceFabricModule),
        typeof(ApplicationModule),
        typeof(EFCoreModule),
        typeof(AbpAspNetCoreModule),
        typeof(AbpAspNetCoreSignalRModule)
        )]
    public class ServiceModule : AbpModule
    {
        private readonly IHostingEnvironment _env;
        private readonly IConfigurationRoot _appConfiguration;
        private readonly IApiInfo _apiInfo;

        public ServiceModule(IHostingEnvironment env, IApiInfo apiInfo)
        {
            _env = env;
            _appConfiguration = env.GetAppConfiguration();
            _apiInfo = apiInfo;
        }
        public override void PreInitialize()
        {
            var connectionString = _appConfiguration.GetConnectionString(_apiInfo.ConnectionStringName);
            EntityFrameworkManager.ContextFactory = context =>
            {
                var optionsBuilder = new DbContextOptionsBuilder<BaseContext>();
                optionsBuilder.UseMySql(connectionString);
                return new BaseContext(optionsBuilder.Options);
            };
        }
        public override void Initialize()
        {
            IocManager.RegisterAssemblyByConvention(typeof(ServiceModule).GetAssembly());
        }
    }
}
