﻿using Bailun.Discuz.Domain.Account;
using Bailun.ServiceFabric;
using System.Collections.Generic;
using Abp.AutoMapper;

namespace Bailun.Discuz.Application.Account.Dto
{
    [AutoMap(typeof(LazadaAccountPublishConfig))]
    public class AccountPublishConfigDto
    {
        public long Id { get; set; }

        public long AccountId { get; set; }

        public string AccountName { get; set; }

        public AccountType? AccountType { get; set; }

        public string AccountTypeName
        {
            get
            {
                if (AccountType.HasValue)
                {
                    return AccountType.GetDescription();
                }

                return "";
            }
        }

        public string Market { get; set; }

        public int? OnlineCount { get; set; }

        public IEnumerable<KeyValuePair<long, string>> PublishableCategories { get; set; }

        public IEnumerable<KeyValuePair<long, string>> UnpublishableCategories { get; set; }
    }
}
